/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxygenKnnFloatVectorQuery
extends KnnFloatVectorQuery {
    private static final Logger logger = LoggerFactory.getLogger(OxygenKnnFloatVectorQuery.class);
    private float cosineSimilarityThreshold;

    public OxygenKnnFloatVectorQuery(String field, float[] target, int k, float cosineSimilarityThreshold) {
        super(field, target, k);
        this.cosineSimilarityThreshold = cosineSimilarityThreshold;
    }

    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        TopDocs initialResults = super.approximateSearch(context, acceptDocs, visitedLimit, knnCollectorManager);
        ArrayList<ScoreDoc> filteredResults = new ArrayList<ScoreDoc>();
        LeafReader reader = context.reader();
        FloatVectorValues floatVectorValues = reader.getFloatVectorValues(this.field);
        for (ScoreDoc scoreDoc : initialResults.scoreDocs) {
            if (floatVectorValues == null || floatVectorValues.advance(scoreDoc.doc) != scoreDoc.doc) continue;
            float[] embedding = floatVectorValues.vectorValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Field: {} Doc: {} Score: {} Embedding: {}", new Object[]{this.field, scoreDoc.doc, Float.valueOf(scoreDoc.score), Arrays.toString(embedding)});
            }
            if (!(scoreDoc.score > this.cosineSimilarityThreshold)) continue;
            filteredResults.add(scoreDoc);
        }
        if (filteredResults.isEmpty()) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        ScoreDoc[] resultingDocs = new ScoreDoc[filteredResults.size()];
        for (int i = 0; i < filteredResults.size(); ++i) {
            resultingDocs[i] = (ScoreDoc)filteredResults.get(i);
        }
        return new TopDocs(new TotalHits((long)resultingDocs.length, initialResults.totalHits.relation), resultingDocs);
    }
}

