/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.queryparser.charstream.CharStream;
import org.apache.lucene.queryparser.charstream.FastCharStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserTokenManager;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.SearchQueryBuilder;
import ro.sync.textsearch.scoring.FieldBoostProvider;

public class HTMLSearchQueryBuilder
extends SearchQueryBuilder {
    public HTMLSearchQueryBuilder(Analyzer analyzer, String text, SearchOptions searchOptions, boolean activateWildcardScoring) throws ParseException, IndexSearcher.TooManyClauses {
        super(analyzer, text, searchOptions, activateWildcardScoring);
    }

    @Override
    protected Query buildInContentQueryOverMultipleFields(String original, String text, SearchOptions searchOptions) throws ParseException {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        BoostQuery defaultQuery = new BoostQuery(super.buildInContentQueryOverMultipleFields(original, text, searchOptions), 1.0f);
        bq.add((Query)defaultQuery, BooleanClause.Occur.SHOULD);
        if (!HTMLSearchQueryBuilder.isComplexQuery(original)) {
            List<String> terms = this.tokenizeQuery(original);
            if (terms.size() >= 2) {
                StringBuilder combination = new StringBuilder(String.format("%s ", terms.get(0)));
                float boost = 5.0f;
                for (int i = 1; i < terms.size(); ++i) {
                    combination.append(String.format("%s ", terms.get(i)));
                    BoostQuery q = new BoostQuery(this.buildInContentQueryOverMultipleFieldsHelper(String.format("\"%s\"~5", combination), searchOptions), boost);
                    bq.add((Query)q, BooleanClause.Occur.SHOULD);
                    boost *= 5.0f;
                }
            }
            BoostQuery phraseQuery = new BoostQuery(this.buildInContentQueryOverMultipleFieldsHelper(String.format("\"%s\"", original), searchOptions), 1000.0f);
            bq.add((Query)phraseQuery, BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    private Query buildInContentQueryOverMultipleFieldsHelper(String text, SearchOptions searchOptions) throws ParseException {
        Map<String, Float> fieldsAndBoosts = searchOptions.isApplyAdvancedScoring() ? FieldBoostProvider.getAdvancedScoringMap() : FieldBoostProvider.getDefaultScoringMap();
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndBoosts.entrySet()) {
            String field = fieldEntry.getKey();
            Float boost = fieldEntry.getValue();
            QueryParser parser = new QueryParser(field, this.analyzer);
            BoostQuery boosted = new BoostQuery(parser.parse(text), boost.floatValue());
            bq.add((Query)boosted, BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    static boolean isComplexQuery(String text) throws ParseException {
        QueryParserTokenManager tm = new QueryParserTokenManager((CharStream)new FastCharStream((Reader)new StringReader(text)));
        Token nextToken = tm.getNextToken();
        while (nextToken.kind != 0) {
            switch (nextToken.kind) {
                case 8: 
                case 9: 
                case 10: 
                case 16: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    return true;
                }
            }
            nextToken = tm.getNextToken();
        }
        return false;
    }

    List<String> tokenizeQuery(String query) {
        ArrayList<String> terms = new ArrayList<String>();
        TokenStream tokenStream = this.analyzer.tokenStream(null, (Reader)new StringReader(query));
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        try {
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                String term = charTermAttribute.toString();
                terms.add(term);
            }
            tokenStream.end();
            tokenStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return terms;
    }
}

