/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.exe4j.runtime.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class DirectoryUtil {
    public static void emptyDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (DirectoryUtil.isRegularDirectory(file)) {
                DirectoryUtil.deleteDirectory(file);
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public static void deleteDirectory(File dir) {
        DirectoryUtil.emptyDirectory(dir);
        dir.delete();
    }

    public static void copyDirectory(File sourceDir, File targetDir, boolean recursive) throws IOException {
        DirectoryUtil.copyDirectory(sourceDir, targetDir, recursive, null, null);
    }

    public static void copyDirectory(File sourceDir, File targetDir, boolean recursive, Collection excludeSuffixes, Collection excludeFiles) throws IOException {
        File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File sourceFile = new File(sourceDir, file.getName()).getCanonicalFile();
            if (excludeFiles != null && excludeFiles.contains(sourceFile)) continue;
            File targetFile = new File(targetDir, sourceFile.getName());
            if (sourceFile.isDirectory() && recursive) {
                if (!targetFile.exists() && !targetFile.mkdirs()) {
                    throw new IOException("Cannot create " + targetDir.getPath());
                }
                DirectoryUtil.copyDirectory(sourceFile, targetFile, true, excludeSuffixes, excludeFiles);
                continue;
            }
            boolean excluded = false;
            if (excludeSuffixes != null) {
                Iterator it = excludeSuffixes.iterator();
                while (it.hasNext() && !excluded) {
                    String suffix = ((String)it.next()).toLowerCase(Locale.ENGLISH);
                    if (!sourceFile.getName().toLowerCase(Locale.ENGLISH).endsWith(suffix)) continue;
                    excluded = true;
                }
            }
            if (excluded) continue;
            FileUtil.copyFile(sourceFile, targetFile);
        }
    }

    public static boolean isRegularDirectory(File file) {
        return file.isDirectory() && !Files.isSymbolicLink(file.toPath());
    }
}

