/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashMap;
import java.util.Map;
import org.htmlcleaner.AttributeTransformation;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.Utils;

public class CleanerTransformations {
    private Map mappings = new HashMap();
    private TagTransformation globalTransformations = new TagTransformation();

    public CleanerTransformations() {
    }

    public CleanerTransformations(Map transInfos) {
        this.updateTagTransformations(transInfos);
    }

    public void addTransformation(TagTransformation tagTransformation) {
        if (tagTransformation != null) {
            this.mappings.put(tagTransformation.getSourceTag(), tagTransformation);
        }
    }

    public void addGlobalTransformation(AttributeTransformation attributeTransformation) {
        this.globalTransformations.addAttributePatternTransformation(attributeTransformation);
    }

    public boolean hasTransformationForTag(String tagName) {
        return tagName != null && this.mappings.containsKey(tagName.toLowerCase());
    }

    public TagTransformation getTransformation(String tagName) {
        return tagName != null ? (TagTransformation)this.mappings.get(tagName.toLowerCase()) : null;
    }

    public void updateTagTransformations(String key, String value) {
        int index = key.indexOf(46);
        if (index <= 0) {
            String destTag = null;
            boolean preserveSourceAtts = true;
            if (value != null) {
                String[] tokens = Utils.tokenize(value, ",;");
                if (tokens.length > 0) {
                    destTag = tokens[0];
                }
                if (tokens.length > 1) {
                    preserveSourceAtts = "true".equalsIgnoreCase(tokens[1]) || "yes".equalsIgnoreCase(tokens[1]) || "1".equals(tokens[1]);
                }
            }
            TagTransformation newTagTrans = new TagTransformation(key, destTag, preserveSourceAtts);
            this.addTransformation(newTagTrans);
        } else {
            String[] parts = Utils.tokenize(key, ".");
            String tagName = parts[0];
            TagTransformation trans = this.getTransformation(tagName);
            if (trans != null) {
                trans.addAttributeTransformation(parts[1], value);
            }
        }
    }

    public void updateTagTransformations(Map transInfos) {
        for (Map.Entry entry : transInfos.entrySet()) {
            String tag = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.updateTagTransformations(tag, value);
        }
    }

    public Map<String, String> transformAttributes(String originalTagName, Map<String, String> attributes) {
        TagTransformation tagTrans = this.getTransformation(originalTagName);
        Map<String, String> results = tagTrans != null ? tagTrans.applyTagTransformations(attributes) : attributes;
        return this.globalTransformations.applyTagTransformations(results);
    }

    public String getTagName(String tagName) {
        TagTransformation tagTransformation = null;
        if (this.hasTransformationForTag(tagName) && (tagTransformation = this.getTransformation(tagName)) != null) {
            return tagTransformation.getDestTag();
        }
        return tagName;
    }

    public void clear() {
        this.mappings.clear();
    }
}

