/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.XMLSerializer15;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PersistenceUtils {
    private static String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    public static final String NODE_COMPONENT = "component";
    public static final String ATTRIBUTE_VERSION = "version";

    public static void saveXMLDocumentToFile(Document document, String fileName, String encoding) throws IOException {
        if (PersistenceUtils.isSunPackageIncluded()) {
            XMLSerializer15.save(document, fileName, encoding, PersistenceUtils.getDefaultXmlVersion());
        }
    }

    public static void saveXMLDocumentToStream(Document document, OutputStream out, String encoding) throws IOException {
        if (PersistenceUtils.isSunPackageIncluded()) {
            XMLSerializer15.save(document, out, encoding, PersistenceUtils.getDefaultXmlVersion());
        }
    }

    private static boolean isSunPackageIncluded() {
        try {
            Class.forName("com.sun.org.apache.xml.internal.serialize.OutputFormat");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getDefaultXmlEncoding() {
        return DEFAULT_XML_ENCODING;
    }

    public static void setDefaultXmlEncoding(String defaultXmlEncoding) {
        DEFAULT_XML_ENCODING = defaultXmlEncoding;
    }

    public static String getDefaultXmlVersion() {
        return DEFAULT_XML_VERSION;
    }

    public static void setDefaultXmlVersion(String defaultXmlVersion) {
        DEFAULT_XML_ENCODING = defaultXmlVersion;
    }

    public static Document getDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static Document getDocument(String fileName) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new File(fileName));
    }

    public static String getVersion(Document document) {
        Node component = document.getElementsByTagName(NODE_COMPONENT).item(0);
        NamedNodeMap componentAttributes = component.getAttributes();
        String version = null;
        for (int i = 0; i < componentAttributes.getLength(); ++i) {
            Node attribute = componentAttributes.item(i);
            if (!ATTRIBUTE_VERSION.equals(attribute.getNodeName())) continue;
            version = attribute.getNodeValue();
            break;
        }
        return version;
    }

    public static int[] stringToIntArray(String s) {
        if (s == null || s.trim().length() == 0) {
            return new int[0];
        }
        String[] ss = s.split(", ");
        int[] is = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            String index = ss[i];
            try {
                is[i] = Integer.parseInt(index);
                continue;
            }
            catch (NumberFormatException e) {
                is[i] = -1;
            }
        }
        return is;
    }

    public static String intArrayToString(int[] indices) {
        if (indices == null || indices.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            buf.append(index);
            if (i == indices.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static boolean isXmlFormat(byte[] byteArray) {
        if (byteArray == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < Math.min(byteArray.length, 10); ++i) {
            buffer.append((char)byteArray[i]);
        }
        String string = buffer.toString().toLowerCase(Locale.getDefault());
        return string.contains("xml");
    }

    public static byte[] bufferStreamToArray(InputStream stream) throws IOException {
        int readLength;
        int length = 1;
        byte[] currentBuffer = new byte[length];
        for (readLength = stream.read(currentBuffer, 0, length); readLength >= length; readLength += length) {
            int newLength = length * 2;
            byte[] newBuffer = new byte[newLength];
            System.arraycopy(currentBuffer, 0, newBuffer, 0, length);
            readLength = stream.read(newBuffer, length, length);
            currentBuffer = newBuffer;
            if (readLength < 0) break;
            length = newLength;
        }
        if (readLength < 0) {
            return currentBuffer;
        }
        byte[] finalBuffer = new byte[readLength];
        System.arraycopy(currentBuffer, 0, finalBuffer, 0, readLength);
        return finalBuffer;
    }
}

