/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.Resource;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class WindowFloatingContainer
extends ResizableWindow
implements FloatingContainer {
    private final DockingManager _dockingManager;
    private final FloatingContainer.FloatingContainerManager _floatingContainerManager;
    private int _dockID = 0;

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner, String title) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, title, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner, String title) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, title, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window owner) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, "", false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window owner, String title) throws HeadlessException {
        this(dockingManager, floatingContainerManager, owner, title, false);
    }

    public WindowFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, Window owner, String title, boolean modal) throws HeadlessException {
        super(owner);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.initWindowFloatingContainer();
    }

    @Override
    protected void initComponents() {
        this.setName("Window");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        super.initComponents();
    }

    protected void initWindowFloatingContainer() {
        this.initListeners();
        this.initKeyBindings();
        this.resetDockID();
    }

    protected void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                if (!(e.getOppositeWindow() instanceof FloatingContainer) && WindowFloatingContainer.this._floatingContainerManager != null) {
                    WindowFloatingContainer.this._floatingContainerManager.floatingFrameActivated(e);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                super.windowDeactivated(e);
                if (WindowFloatingContainer.this._floatingContainerManager != null) {
                    WindowFloatingContainer.this._floatingContainerManager.floatingFrameDeactivated(e);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                DockingUtils.closeFloatingContainer(WindowFloatingContainer.this.getDockingManager(), WindowFloatingContainer.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                DockingUtils.closeFloatingContainer(WindowFloatingContainer.this.getDockingManager(), WindowFloatingContainer.this);
            }
        });
    }

    protected void initKeyBindings() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (WindowFloatingContainer.this.isFocusOwner() && e.getKeyCode() == 115 && e.isAltDown()) {
                    DockingUtils.closeFloatingContainer(WindowFloatingContainer.this.getDockingManager(), WindowFloatingContainer.this);
                    e.consume();
                }
            }
        });
    }

    @Override
    public Component getRoutingComponent() {
        return this._dockingManager.getMainContainer();
    }

    @Override
    public boolean hasTitleBar() {
        return UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    @Override
    public Rectangle getInitialBounds(Rectangle savedBounds) {
        return savedBounds;
    }

    @Override
    public void updateUndecorated() {
        boolean show = this.isVisible();
        this.setVisible(false);
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
        } else {
            BorderUIResource border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (show || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
    }

    @Override
    public void updateBorders() {
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
        }
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void hideItselfIfEmpty() {
        List<DockableFrame> frames = DockingUtils.getAllDockableFrameOf(this.getContentPane());
        if (frames == null || frames.size() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int id) {
        this._dockID = id;
    }

    @Override
    public void resetDockID() {
        this._dockID = -1;
        if (this._dockingManager != null) {
            this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        }
    }

    @Override
    public boolean isUndecorated() {
        return false;
    }

    @Override
    public void updateTitle() {
    }

    @Override
    public void setResizable(boolean resizable) {
        this.getResizable().setResizableCorners(resizable ? 255 : 0);
    }

    @Override
    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }

    protected class CloseFloatingDockableFrameAction
    extends AbstractAction {
        public CloseFloatingDockableFrameAction() {
            super(WindowFloatingContainer.this.getDockingManager() != null ? WindowFloatingContainer.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockingUtils.closeFloatingContainer(WindowFloatingContainer.this.getDockingManager(), WindowFloatingContainer.this);
        }
    }
}

