/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FloatingFrames;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.HiddenFrames;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class SaveUtils {
    private static final int COC = 1123;
    private static final int FRC = 1124;
    private static final int DF = 1125;
    private static final int WKS = 1126;
    private static final int FLC = 1127;
    protected static final int INVALID_COMPONENT = 65535;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    SaveUtils() {
    }

    static short readShort(DataInputStream in) throws IOException {
        return in.readShort();
    }

    static void writeShort(DataOutputStream out, short i) throws IOException {
        out.writeShort(i);
    }

    static int readInt(DataInputStream in) throws IOException {
        return in.readInt();
    }

    static void writeInt(DataOutputStream out, int i) throws IOException {
        out.writeInt(i);
    }

    static String readString(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again. The length of the string as " + length + " is too long.");
        }
        if (length == -1) {
            throw new IOException("The layout is corrupted. Please remove it and try again. The string length as -1 is invalid.");
        }
        char[] b = new char[length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = in.readChar();
        }
        return new String(b);
    }

    static void writeString(DataOutputStream out, String s) throws IOException {
        out.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            out.writeChar(s.charAt(i));
        }
    }

    static Dimension readSize(DataInputStream in) throws IOException {
        Dimension dim = new Dimension(in.readInt(), in.readInt());
        return SaveUtils.detectWrongSize(dim);
    }

    static void writeSize(DataOutputStream out, Component component) throws IOException {
        Dimension dim = component.getPreferredSize();
        if (dim == null || SystemInfo.isJdk15Above() && !component.isPreferredSizeSet()) {
            out.writeInt(-1);
            out.writeInt(-1);
        } else {
            out.writeInt(dim.width);
            out.writeInt(dim.height);
        }
    }

    static Rectangle readRectangle(DataInputStream in) throws IOException {
        return new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    static void writeRectangle(DataOutputStream out, Rectangle rect) throws IOException {
        if (rect == null) {
            out.writeInt(60);
            out.writeInt(60);
            out.writeInt(200);
            out.writeInt(200);
        } else {
            out.writeInt(rect.x);
            out.writeInt(rect.y);
            out.writeInt(rect.width);
            out.writeInt(rect.height);
        }
    }

    static short readVersion(DataInputStream in) throws IOException {
        return SaveUtils.readShort(in);
    }

    static void writeVersion(DataOutputStream out, short version) throws IOException {
        SaveUtils.writeShort(out, version);
    }

    static HiddenFrames readContext(DockingManager dockingManager, DataInputStream in, Map<String, DockContext> contexts) throws IOException {
        HashMap<String, DockContext> contextCopy = new HashMap<String, DockContext>(contexts);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int currentDockSide;
            String key = SaveUtils.readString(in);
            DockContext context = new DockContext();
            context.setDockID(dockingManager, in.readInt());
            context.setInitSide(in.readInt());
            context.setInitIndex(in.readInt());
            context.setInitPosition(in.readInt() != 0);
            context.setCanMode(in.readInt());
            context.setInitMode(in.readInt());
            context.setCurrentMode(in.readInt());
            if (context.isAutohideShowing()) {
                context.setCurrentMode(2);
            }
            if (((currentDockSide = in.readInt()) & Integer.MIN_VALUE) != 0) {
                currentDockSide &= Integer.MIN_VALUE;
                context.setAvailable(false);
            }
            context.setCurrentDockSide(currentDockSide);
            context.setDockedWidth(in.readInt());
            context.setDockedHeight(in.readInt());
            context.setAutohideWidth(in.readInt());
            context.setAutohideHeight(in.readInt());
            Rectangle rect = SaveUtils.readRectangle(in);
            if (!rect.isEmpty()) {
                context.setUndockedBounds(rect);
            }
            context.setHiddenPreviousState(SaveUtils.readPreviousState(in));
            context.setClosePreviousState(SaveUtils.readPreviousState(in));
            context.setDockPreviousState(SaveUtils.readPreviousState(in));
            context.setFloatPreviousState(SaveUtils.readPreviousState(in));
            context.setAutohidePreviousState(SaveUtils.readPreviousState(in));
            DockContext previousContext = (DockContext)contextCopy.remove(key);
            if (previousContext != null) {
                context.setInitAutohideHeight(previousContext.getInitAutohideHeight());
                context.setInitAutohideWidth(previousContext.getInitAutohideWidth());
                context.setInitIndex(previousContext.getInitIndex());
                context.setInitMode(previousContext.getInitMode());
                context.setInitSide(previousContext.getInitSide());
                context.setInitUndockedBounds(previousContext.getInitUndockedBounds());
            }
            contexts.put(key, context);
        }
        HiddenFrames newFrames = new HiddenFrames();
        for (String s : contextCopy.keySet()) {
            newFrames.add(s);
        }
        return newFrames;
    }

    static void writeContext(DataOutputStream out, Map<String, DockContext> contexts) throws IOException {
        out.writeInt(contexts.size());
        Set<String> set = contexts.keySet();
        for (String key : set) {
            DockContext context = contexts.get(key);
            SaveUtils.writeString(out, key);
            out.writeInt(context.getDockID());
            out.writeInt(context.getInitSide());
            out.writeInt(context.getInitIndex());
            out.writeInt(context.isInitPosition() ? 1 : 0);
            out.writeInt(context.getCanMode());
            out.writeInt(context.getInitMode());
            if (context.isAutohideShowing()) {
                out.writeInt(2);
            } else {
                out.writeInt(context.getCurrentMode());
            }
            int currentDockSide = context.getCurrentDockSide();
            if (!context.isAvailable()) {
                currentDockSide |= Integer.MIN_VALUE;
            }
            out.writeInt(currentDockSide);
            out.writeInt(context.getDockedWidth());
            out.writeInt(context.getDockedHeight());
            out.writeInt(context.getAutohideWidth());
            out.writeInt(context.getAutohideHeight());
            if (context.getUndockedBounds() != null) {
                SaveUtils.writeRectangle(out, context.getUndockedBounds());
            } else {
                SaveUtils.writeRectangle(out, new Rectangle(0, 0, 0, 0));
            }
            SaveUtils.writePreviousState(out, context.getHiddenPreviousState());
            SaveUtils.writePreviousState(out, context.getClosePreviousState());
            SaveUtils.writePreviousState(out, context.getDockPreviousState());
            SaveUtils.writePreviousState(out, context.getFloatPreviousState());
            SaveUtils.writePreviousState(out, context.getAutohidePreviousState());
        }
    }

    static void writeComponent(DataOutputStream out, int version, Component component) throws IOException {
        if (component instanceof ContainerContainer) {
            SaveUtils.writeContainerContainer(out, version, (ContainerContainer)component);
        } else if (component instanceof FrameContainer) {
            SaveUtils.writeFrameContainer(out, version, (FrameContainer)component);
        } else if (component instanceof DockableFrame) {
            SaveUtils.writeDockableFrame(out, version, (DockableFrame)component);
        } else if (component instanceof Workspace) {
            SaveUtils.writeWorkspace(out, version, (Workspace)component);
        } else if (component instanceof FloatingContainer) {
            SaveUtils.writeFloatingContainer(out, version, (FloatingContainer)((Object)component));
        } else {
            SaveUtils.writeInt(out, 65535);
        }
    }

    static Component readComponent(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        int type = in.readInt();
        boolean activate = false;
        if ((type & Integer.MIN_VALUE) != 0 && (type &= Integer.MAX_VALUE) == 1125) {
            activate = true;
        }
        switch (type) {
            case 1123: {
                return SaveUtils.readContainerContainer(dockingManager, version, in);
            }
            case 1124: {
                return SaveUtils.readFrameContainer(dockingManager, version, in);
            }
            case 1125: {
                return SaveUtils.readDockableFrame(dockingManager, version, in, activate);
            }
            case 1126: {
                return SaveUtils.readWorkspace(dockingManager, version, in);
            }
            case 1127: {
                return SaveUtils.readFloatingContainer(dockingManager, version, in);
            }
        }
        return null;
    }

    private static ContainerContainer readContainerContainer(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        int count;
        ContainerContainer cc = dockingManager.createContainerContainer();
        cc.setOrientation(in.readInt());
        cc.setDockID(in.readInt());
        boolean hasProportions = false;
        if (version >= 20) {
            cc.setProportionalLayout(in.readBoolean());
            if (cc.isProportionalLayout()) {
                cc.setInitiallyEven(in.readBoolean());
                count = in.readInt();
                if (count > 0) {
                    double[] p = new double[count];
                    for (int i = 0; i < p.length; ++i) {
                        p[i] = in.readDouble();
                    }
                    cc.setEventualProportions(p);
                    hasProportions = true;
                }
            }
        } else {
            cc.setInitiallyEven(false);
        }
        count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Component comp = SaveUtils.readComponent(dockingManager, version, in);
            if (comp == null) continue;
            cc.add(comp);
        }
        Dimension dim = SaveUtils.readSize(in);
        if (dim != null && (dim.height != 0 || dim.width != 0)) {
            cc.setPreferredSize(dim);
        }
        if (cc.getComponentCount() == 0 && !hasProportions) {
            return null;
        }
        return cc;
    }

    private static void writeContainerContainer(DataOutputStream out, int version, ContainerContainer cc) throws IOException {
        out.writeInt(1123);
        out.writeInt(cc.getOrientation());
        out.writeInt(cc.getDockID());
        if (version >= 20) {
            out.writeBoolean(cc.isProportionalLayout());
            if (cc.isProportionalLayout()) {
                out.writeBoolean(cc.isInitiallyEven());
                double[] props = cc.getProportions();
                out.writeInt(props == null ? -1 : props.length);
                if (props != null) {
                    for (double p : props) {
                        out.writeDouble(p);
                    }
                }
            }
        }
        out.writeInt(cc.getPaneCount());
        for (int i = 0; i < cc.getPaneCount(); ++i) {
            SaveUtils.writeComponent(out, version, cc.getPaneAt(i));
        }
        SaveUtils.writeSize(out, cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameContainer readFrameContainer(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        int selected;
        FrameContainer fc = dockingManager.createFrameContainer();
        fc.setDockID(in.readInt());
        int count = in.readInt();
        fc.setSuppressSetSelectedIndex(true);
        fc.setSuppressStateChangedEvents(true);
        try {
            for (int i = 0; i < count; ++i) {
                DockableFrame dockableFrame = (DockableFrame)SaveUtils.readComponent(dockingManager, version, in);
                if (dockableFrame == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
                fc.addTab(dockableFrame);
            }
            Dimension dim = SaveUtils.readSize(in);
            if (dim != null) {
                fc.setPreferredSize(dim);
            }
            selected = in.readInt();
            if (fc.getTabCount() == 0) {
                FrameContainer frameContainer = null;
                return frameContainer;
            }
        }
        finally {
            fc.setSuppressSetSelectedIndex(false);
            fc.setSuppressStateChangedEvents(false);
        }
        if (selected >= 0 && selected < fc.getTabCount()) {
            fc.setSelectedIndex(selected);
        } else if (fc.getTabCount() > 0) {
            fc.setSelectedIndex(0);
        }
        fc.setPreviousSelectedFrame(fc.getSelectedFrame());
        return fc;
    }

    private static void writeFrameContainer(DataOutputStream out, int version, FrameContainer fc) throws IOException {
        DockableFrame f;
        int i;
        out.writeInt(1124);
        out.writeInt(fc.getDockID());
        int tabCount = 0;
        for (i = 0; i < fc.getTabCount(); ++i) {
            f = (DockableFrame)fc.getComponentAt(i);
            if (f.isTransient()) continue;
            ++tabCount;
        }
        out.writeInt(tabCount);
        if (tabCount != 0) {
            for (i = 0; i < fc.getTabCount(); ++i) {
                f = (DockableFrame)fc.getComponentAt(i);
                if (f.isTransient()) continue;
                SaveUtils.writeDockableFrame(out, version, f);
            }
        }
        SaveUtils.writeSize(out, fc);
        out.writeInt(fc.getSelectedIndex());
    }

    private static DockableFrame readDockableFrame(DockingManager dockingManager, int version, DataInputStream in, boolean activate) throws IOException {
        String name = SaveUtils.readString(in);
        DockableFrame df = dockingManager.getFrame(name);
        if (df != null) {
            DockContext dockContext = null;
            if (!df.isTransient()) {
                dockContext = dockingManager.getContextOf(name);
            }
            if (dockContext != null) {
                df.setContext(dockContext);
            }
            if (!df.isHidden()) {
                dockingManager.removeFromHiddenFrames(name);
            }
            df.setAvailable(true);
            if (activate && dockingManager instanceof DefaultDockingManager) {
                ((DefaultDockingManager)dockingManager).setFrameToActivate(name);
            }
        }
        return df;
    }

    private static void writeDockableFrame(DataOutputStream out, int version, DockableFrame df) throws IOException {
        int value = 1125;
        if (df.getDockingManager() != null && df.getKey().equals(df.getDockingManager().getActiveFrameKey())) {
            value |= Integer.MIN_VALUE;
        }
        out.writeInt(value);
        SaveUtils.writeString(out, df.getKey());
    }

    private static Workspace readWorkspace(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        SaveUtils.readSize(in);
        Workspace ws = dockingManager.getWorkspace();
        int acceptDockableFrame = SaveUtils.readInt(in);
        ws.setAcceptDockableFrame(acceptDockableFrame == 1);
        if (acceptDockableFrame == 1) {
            ws.removeAll();
            int count = SaveUtils.readInt(in);
            for (int i = 0; i < count; ++i) {
                Component c = SaveUtils.readComponent(dockingManager, version, in);
                if (c == null || !ws.isAcceptDockableFrame()) continue;
                ws.add(c);
            }
        }
        return ws;
    }

    private static void writeWorkspace(DataOutputStream out, int version, Workspace ws) throws IOException {
        out.writeInt(1126);
        SaveUtils.writeSize(out, ws);
        if (ws.isAcceptDockableFrame()) {
            SaveUtils.writeInt(out, 1);
            SaveUtils.writeInt(out, ws.getComponentCount());
            for (int i = 0; i < ws.getComponentCount(); ++i) {
                SaveUtils.writeComponent(out, version, ws.getComponent(i));
            }
        } else {
            SaveUtils.writeInt(out, 0);
        }
    }

    private static Container readFloatingContainer(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        Rectangle rect = SaveUtils.readRectangle(in);
        int count = in.readInt();
        if (count == 0) {
            return null;
        }
        RootPaneContainer container = dockingManager.getRootPaneContainer();
        if (container == null) {
            throw new IllegalStateException("Failed to create floating frame because the top level window is not available. Please make sure you load the layout after the contentContainer is added to Swing component tree hierarchy or make sure you pass in a valid rootPaneContainer in the constructor of DefaultDockingManager.");
        }
        FloatingContainer fc = dockingManager.createFloatingContainer(SwingUtilities.getWindowAncestor(container.getRootPane()));
        DockingManager.FloatingContainerCustomizer customizer = dockingManager.getFloatingContainerCustomizer();
        if (customizer != null) {
            customizer.customize(fc);
        }
        Rectangle floatingContainerBounds = PortingUtils.overlapWithScreenBounds((Component)((Object)fc), rect);
        if (dockingManager instanceof DefaultDockingManager) {
            ((DefaultDockingManager)dockingManager).adjustBoundsForSnap(new Rectangle(), floatingContainerBounds);
        }
        fc.setBounds(floatingContainerBounds);
        for (int i = 0; i < count; ++i) {
            Component comp = SaveUtils.readComponent(dockingManager, version, in);
            if (comp == null) continue;
            fc.getContentPane().add(comp);
        }
        if (fc.getContentPane().getComponentCount() == 0) {
            fc.dispose();
            return null;
        }
        final int[] counts = new int[]{0};
        JideSwingUtilities.setRecursively(fc.getContentPane(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame;
            }

            @Override
            public void action(Component c) {
                counts[0] = counts[0] + 1;
            }

            @Override
            public void postAction(Component c) {
            }
        });
        if (counts[0] <= 0) {
            fc.dispose();
            return null;
        }
        fc.updateUndecorated();
        return (Container)((Object)fc);
    }

    private static void writeFloatingContainer(DataOutputStream out, int version, FloatingContainer fc) throws IOException {
        boolean visible;
        out.writeInt(1127);
        Rectangle bounds = fc.getBounds();
        int contY = bounds.y;
        boolean bl = visible = contY >= -5000;
        if (!visible) {
            bounds.y += 10000;
        }
        SaveUtils.writeRectangle(out, bounds);
        out.writeInt(fc.getContentPane().getComponentCount());
        for (int i = 0; i < fc.getContentPane().getComponentCount(); ++i) {
            SaveUtils.writeComponent(out, version, fc.getContentPane().getComponent(i));
        }
    }

    static FloatingFrames readFloatingFrames(DockingManager dockingManager, int version, DataInputStream in) throws IOException {
        FloatingFrames frames = new FloatingFrames();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Component comp = SaveUtils.readComponent(dockingManager, version, in);
            if (comp == null || !(comp instanceof FloatingContainer)) continue;
            frames.add((FloatingContainer)((Object)comp));
        }
        return frames;
    }

    static void writeFloatingFrames(DataOutputStream out, int version, FloatingFrames frames) throws IOException {
        int framesSize = frames != null ? frames.size() : 0;
        out.writeInt(framesSize);
        if (frames != null) {
            for (int i = 0; i < framesSize; ++i) {
                SaveUtils.writeComponent(out, version, (Container)frames.get(i));
            }
        }
    }

    static HiddenFrames readHiddenFrames(DataInputStream in) throws IOException {
        HiddenFrames frames = new HiddenFrames();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String name = SaveUtils.readString(in);
            frames.add(name);
        }
        return frames;
    }

    static void writeHiddenFrames(DataOutputStream out, HiddenFrames frames) throws IOException {
        out.writeInt(frames.size());
        for (String name : frames) {
            SaveUtils.writeString(out, name);
        }
    }

    private static SidePaneGroup readSideGroup(DockingManager dockingManager, AutoHideContainer.MouseInputCreator creator, int version, DataInputStream in, int side) throws IOException {
        SidePaneGroup group = new SidePaneGroup();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            SidePaneItem item = SaveUtils.readSideItem(dockingManager, creator, version, in, side);
            if (item == null) continue;
            group.add(item);
        }
        int selected = in.readInt();
        if (selected >= 0 && selected < group.size()) {
            group.setSelectedIndex(selected);
        }
        if (group.size() > 0) {
            return group;
        }
        return null;
    }

    private static void writeSideGroup(DataOutputStream out, int version, SidePaneGroup group) throws IOException {
        out.writeInt(group.size());
        for (SidePaneItem g : group) {
            SaveUtils.writeSideItem(out, version, g);
        }
        out.writeInt(group.getSelectedIndex());
    }

    private static SidePaneItem readSideItem(DockingManager dockingManager, AutoHideContainer.MouseInputCreator creator, int version, DataInputStream in, int side) throws IOException {
        SaveUtils.readString(in);
        DockableFrame frame = (DockableFrame)SaveUtils.readComponent(dockingManager, version, in);
        if (frame != null && frame.getContext() != null && frame.isAvailable() && !frame.shouldVetoShowing()) {
            SidePaneItem item = new SidePaneItem(frame.getSideTitle(), frame.getFrameIcon(), frame, creator.createAutoHideMouseInputListener(frame, side));
            item.setSelected(false);
            return item;
        }
        return null;
    }

    private static void writeSideItem(DataOutputStream out, int version, SidePaneItem item) throws IOException {
        SaveUtils.writeString(out, item.getTitle());
        SaveUtils.writeComponent(out, version, item.getComponent());
    }

    static AutoHideContainer readAutohideContainer(DockingManager dockingManager, AutoHideContainer.MouseInputCreator creator, int version, DataInputStream in) throws IOException {
        AutoHideContainer ac = dockingManager.createAutoHideContainer(in.readInt());
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            SidePaneGroup group = SaveUtils.readSideGroup(dockingManager, creator, version, in, DockingUtils.convertToDockSide(ac.getAttachedSide()));
            if (group == null) continue;
            ac.addGroup(group);
        }
        return ac;
    }

    static void writeAutohideContainer(DataOutputStream out, int version, AutoHideContainer ac) throws IOException {
        out.writeInt(ac.getAttachedSide());
        out.writeInt(ac.getGroups().size());
        for (int i = 0; i < ac.getGroups().size(); ++i) {
            SaveUtils.writeSideGroup(out, version, ac.getGroups().get(i));
        }
    }

    private static PreviousState readPreviousState(DataInputStream in) throws IOException {
        int valid = in.readInt();
        if (valid == 1) {
            int i;
            PreviousState state = new PreviousState();
            state.mode = in.readInt();
            state.dockID = in.readInt();
            state.rootID = in.readInt();
            state.rcBounds = SaveUtils.readRectangle(in);
            state.side = in.readInt();
            state.index = in.readInt();
            state.fcID = in.readInt();
            int count = in.readInt();
            if (count != 0) {
                state.fcChildren = new ArrayList();
                for (i = 0; i < count; ++i) {
                    state.fcChildren.add(in.readInt());
                }
            }
            if ((count = in.readInt()) != 0) {
                state.parentStates = new ArrayList();
                for (i = 0; i < count; ++i) {
                    PreviousState.ParentState pState = new PreviousState.ParentState();
                    pState.ccID = in.readInt();
                    pState.myID = in.readInt();
                    pState.orientation = in.readInt();
                    int count2 = in.readInt();
                    if (count2 != 0) {
                        pState.ccChildren = new ArrayList();
                        for (int j = 0; j < count2; ++j) {
                            pState.ccChildren.add(in.readInt());
                        }
                    }
                    state.parentStates.add(pState);
                }
            }
            return state;
        }
        return null;
    }

    private static void writePreviousState(DataOutputStream out, PreviousState state) throws IOException {
        if (state != null) {
            out.writeInt(1);
            out.writeInt(state.mode);
            out.writeInt(state.dockID);
            out.writeInt(state.rootID);
            SaveUtils.writeRectangle(out, state.rcBounds);
            out.writeInt(state.side);
            out.writeInt(state.index);
            out.writeInt(state.fcID);
            if (state.fcChildren != null) {
                out.writeInt(state.fcChildren.size());
                for (Integer childDockID : state.fcChildren) {
                    out.writeInt(childDockID);
                }
            } else {
                out.writeInt(0);
            }
            if (state.parentStates != null) {
                out.writeInt(state.parentStates.size());
                for (PreviousState.ParentState pState : state.parentStates) {
                    out.writeInt(pState.ccID);
                    out.writeInt(pState.myID);
                    out.writeInt(pState.orientation);
                    if (pState.ccChildren != null) {
                        out.writeInt(pState.ccChildren.size());
                        for (Integer childDockID : pState.ccChildren) {
                            out.writeInt(childDockID);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
    }

    private static Dimension detectWrongSize(Dimension dimension) {
        if (dimension.width == -1 && dimension.height == -1) {
            return null;
        }
        return dimension;
    }
}

