/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.swing.ContentContainer;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class DefaultDockableBarHolder
extends JFrame
implements DockableBarHolder {
    private DockableBarManager _dockableBarManager;

    public DefaultDockableBarHolder() throws HeadlessException {
        try {
            this.initFrame(this.getContentPane());
        }
        finally {
            this.setContentPaneCheckingEnabled(true);
        }
    }

    public DefaultDockableBarHolder(GraphicsConfiguration gc) {
        super(gc);
        try {
            this.initFrame(this.getContentPane());
        }
        finally {
            this.setContentPaneCheckingEnabled(true);
        }
    }

    public DefaultDockableBarHolder(String title) throws HeadlessException {
        super(title);
        try {
            this.initFrame(this.getContentPane());
        }
        finally {
            this.setContentPaneCheckingEnabled(true);
        }
    }

    public DefaultDockableBarHolder(String title, GraphicsConfiguration gc) {
        super(title, gc);
        try {
            this.initFrame(this.getContentPane());
        }
        finally {
            this.setContentPaneCheckingEnabled(true);
        }
    }

    protected void initFrame(Container container) {
        ContentContainer contentContainer = this.createContentContainer();
        container.setLayout(new BorderLayout());
        container.add((Component)contentContainer, "Center");
        contentContainer.setLayout(new BorderLayout());
        this._dockableBarManager = this.createDockableBarManager(contentContainer);
    }

    protected DockableBarManager createDockableBarManager(Container contentContainer) {
        return new DefaultDockableBarManager(this, contentContainer);
    }

    protected ContentContainer createContentContainer() {
        return new ContentContainer();
    }

    @Override
    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._dockableBarManager;
    }

    @Override
    public JMenuBar getJMenuBar() {
        if (this.getDockableBarManager() != null) {
            Collection<DockableBar> barCollection = this.getDockableBarManager().getAllDockableBars();
            for (DockableBar bar : barCollection) {
                if (!bar.isMenuBar()) continue;
                return bar;
            }
        }
        return super.getJMenuBar();
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.isRootPaneCheckingEnabled();
    }

    protected void setContentPaneCheckingEnabled(boolean contentPaneCheckingEnabled) {
        this.setRootPaneCheckingEnabled(contentPaneCheckingEnabled);
    }
}

