/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util.editorvars;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.util.editorvars.EditorVariablesConstants;
import ro.sync.util.editorvars.expander.EditorVariableExpander;
import ro.sync.util.editorvars.expander.EditorVariableResolver;
import ro.sync.util.editorvars.expander.ErrorListener;
import ro.sync.util.editorvars.expander.OperationCancelledException;
import ro.sync.util.editorvars.parser.ParseException;
import ro.sync.util.editorvars.parser.model.EditorVariable;
import ro.sync.util.editorvars.parser.model.LexicalItem;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class EditorVariablesBase
implements EditorVariablesConstants {
    private static final Logger logger = LoggerFactory.getLogger((String)EditorVariablesBase.class.getName());

    EditorVariablesBase() {
    }

    public static String expandEnvAndSystem(String string) {
        EditorVariableExpander editorVariableExpander = new EditorVariableExpander();
        editorVariableExpander.addErrorListener(new ErrorListener(){

            public void error(String string, ParseException parseException) {
                logger.debug((Object)parseException, (Throwable)parseException);
            }
        });
        EditorVariablesBase.registerEnvAndSystemResolver(editorVariableExpander);
        try {
            string = editorVariableExpander.expand(string);
        }
        catch (OperationCancelledException | ParseException throwable) {
            logger.error((Object)throwable, throwable);
        }
        return string;
    }

    protected static void registerEnvAndSystemResolver(EditorVariableExpander editorVariableExpander) {
        editorVariableExpander.register(EditorVariablesBase.getName("${env("), new EditorVariableResolver(){

            public String resolve(EditorVariable editorVariable) {
                try {
                    String string = ((LexicalItem)editorVariable.getParams().get(0)).getStringValue();
                    return System.getenv(string);
                }
                catch (SecurityException securityException) {
                    logger.error("Insufficient privilidges to access System.env, possibly running from applet " + securityException, (Throwable)securityException);
                    return "";
                }
            }
        });
        editorVariableExpander.register(EditorVariablesBase.getName("${system("), new EditorVariableResolver(){

            public String resolve(EditorVariable editorVariable) {
                String string = ((LexicalItem)editorVariable.getParams().get(0)).getStringValue();
                return System.getProperty(string);
            }
        });
    }

    protected static final String getName(String string) {
        return string.replace("${", "").replace("}", "").replace("(", "");
    }

    protected static final boolean fastEquals(String string, String string2) {
        char c2;
        int n2 = 0;
        int n3 = string2.length();
        if (string2.startsWith("${")) {
            n2 = "${".length();
        }
        if ((c2 = string2.charAt(string2.length() - 1)) == '(' || c2 == '}') {
            --n3;
        }
        return string2.subSequence(n2, n3).equals(string);
    }

    public static String replaceFunctions(String string, String string2, String string3, EditorVariables._d _d2) {
        if (string != null && string.contains(string2) && string.contains(string3)) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder(string);
            while (n2 >= 0) {
                if ((n2 = stringBuilder.indexOf(string2, n2)) == -1) continue;
                int n3 = EditorVariablesBase.findEndIndex(stringBuilder, string3, n2 + 1);
                if (n3 == -1) break;
                String string4 = stringBuilder.substring(n2 + string2.length(), n3);
                if (string4.length() > 0) {
                    String string5 = _d2.b(string4);
                    if (string5 != null) {
                        int n4 = n3 + string3.length() - n2;
                        String string6 = String.valueOf(string5);
                        stringBuilder.replace(n2, n2 + n4, string6);
                        n2 += string6.length();
                        continue;
                    }
                    n2 = n3 + string3.length();
                    continue;
                }
                n2 = n3 + string3.length();
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private static int findEndIndex(StringBuilder stringBuilder, String string, int n2) {
        int n3 = stringBuilder.indexOf(string, n2);
        if (n3 != -1) {
            int n4 = stringBuilder.indexOf("${", n2);
            if (n4 == -1 || n3 < n4) {
                return n3;
            }
            int n5 = EditorVariablesBase.findEndIndex(stringBuilder, string, n3 + string.length());
            if (n5 != -1) {
                n3 = n5;
            }
        }
        return n3;
    }

    static String getTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }
}

