/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ui.tree.state;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableList;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TreeStateInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)TreeStateInfo.class.getName());
    private URL systemID;
    private SerializableList<Integer> currentSelectionPath;
    private SerializableList<SerializableList<Integer>> expandedPaths;

    public TreeStateInfo() {
    }

    public TreeStateInfo(URL uRL, SerializableList<Integer> serializableList, SerializableList<SerializableList<Integer>> serializableList2) {
        this.systemID = uRL;
        this.currentSelectionPath = new SerializableList(serializableList);
        this.expandedPaths = serializableList2;
    }

    public URL getSystemID() {
        return this.systemID;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.systemID == null) {
            throw new InvalidPersistentObjException("Missing system ID in the mark location.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            TreeStateInfo treeStateInfo = (TreeStateInfo)super.clone();
            if (this.currentSelectionPath != null) {
                treeStateInfo.currentSelectionPath = (SerializableList)this.currentSelectionPath.clone();
            }
            if (this.expandedPaths != null) {
                treeStateInfo.expandedPaths = (SerializableList)this.expandedPaths.clone();
            }
            return treeStateInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public String toString() {
        return "Opened file: " + URLUtil.filterPasswords((String)String.valueOf(this.systemID));
    }

    public SerializableList<Integer> getCurrentSelectionPath() {
        return this.currentSelectionPath;
    }

    public SerializableList<SerializableList<Integer>> getExpandedPaths() {
        return this.expandedPaths;
    }
}

