/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.zip;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.JarDriver;
import de.schlichtherle.io.archive.zip.OdfDriver;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.archive.ArchiveUtil;
import ro.sync.basic.archive.BasicArchiveUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.og;
import ro.sync.exml.v;
import ro.sync.exml.zip.ArchiveDescriptor;
import ro.sync.exml.zip.b.c;
import ro.sync.exml.zip.l;
import ro.sync.exml.zip.t;
import ro.sync.exml.zip.z;
import ro.sync.i18n.d;
import ro.sync.i18n.r;

public class cb
implements ArchiveUtil {
    private Logger b = LoggerFactory.getLogger((String)cb.class.getName());
    protected static final d d = r.m();
    private UnsupportedCharsetException c = null;

    public boolean hasArchiveExtension(URL uRL) {
        boolean bl = false;
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            bl = this.hasArchiveExtension(file);
        }
        return bl;
    }

    public boolean hasArchiveExtension(File file) {
        boolean bl = false;
        if (file != null) {
            String string = URLUtil.getExtension((String)file.getName());
            for (String string2 : this.getAllSupportedArchiveExtensions()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void initTrueZIPLibrary() {
        List<ArchiveDescriptor> list = t.i().c();
        this.c = null;
        DefaultArchiveDetector defaultArchiveDetector = (DefaultArchiveDetector)de.schlichtherle.io.File.getDefaultArchiveDetector();
        for (ArchiveDescriptor archiveDescriptor : list) {
            try {
                defaultArchiveDetector = new DefaultArchiveDetector(defaultArchiveDetector, this.c(archiveDescriptor.getExtensions()), this.b(archiveDescriptor.getType()));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.c = unsupportedCharsetException;
            }
        }
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)defaultArchiveDetector);
    }

    private ArchiveDriver b(int n2) {
        Object object = null;
        if (n2 == 0) {
            object = new z();
        } else if (n2 == 1) {
            object = new JarDriver();
        } else if (n2 == 2) {
            object = new OdfDriver();
        } else if (n2 == 3) {
            object = new c();
        }
        return object;
    }

    private String c(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public URL archiveFileToURL(File file) throws MalformedURLException {
        de.schlichtherle.io.File file2;
        if (file instanceof de.schlichtherle.io.File && (file2 = ((de.schlichtherle.io.File)file).getTopLevelArchive()) != null) {
            String string = URLUtil.getRelativeLocation((URL)file2.toURL(), (URL)new URL(file.toURL().toString().replace("#", "%23")));
            string = string.replace("%23", "#");
            String string2 = "zip:" + URLUtil.correct((String)(file2.toURL().toString() + "!/" + string), (boolean)true);
            return new URL(string2);
        }
        return null;
    }

    public URI archiveFileToURI(File file) throws URISyntaxException, MalformedURLException {
        de.schlichtherle.io.File file2;
        URI uRI = null;
        if (file instanceof de.schlichtherle.io.File && (file2 = ((de.schlichtherle.io.File)file).getTopLevelArchive()) != null) {
            String string = null;
            string = file2 == file ? "" : URLUtil.getRelativeLocation((String)file2.toURL().toString(), (String)file.toURL().toString());
            uRI = new URI("zip", null, "/" + string, URLUtil.correct((File)file2).toString(), null);
        }
        return uRI;
    }

    public URL archiveURIToURL(URI uRI) throws MalformedURLException {
        if (uRI.getQuery() != null && uRI.getQuery().length() > 0 && uRI.getPath() != null && uRI.getPath().length() > 0) {
            String string = "zip:" + URLUtil.correct((String)uRI.getQuery(), (boolean)false) + "!" + URLUtil.correct((String)uRI.getPath(), (boolean)true);
            return new URL(string);
        }
        return null;
    }

    public File archiveURLToFile(URL uRL) throws IOException {
        return BasicArchiveUtil.archiveURLToFile((URL)uRL);
    }

    public List<String> getAllSupportedArchiveExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ArchiveDescriptor> list = t.i().c();
        for (ArchiveDescriptor archiveDescriptor : list) {
            arrayList.addAll(Arrays.asList(archiveDescriptor.getExtensions()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> populatePropertiesMap(File file) throws IOException {
        LinkedHashMap<String, Object> linkedHashMap = null;
        ZipFile zipFile = null;
        try {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(true);
            if (!(file instanceof de.schlichtherle.io.File)) return linkedHashMap;
            de.schlichtherle.io.File file2 = ((de.schlichtherle.io.File)file).getTopLevelArchive();
            if (file2 == file || file2 == ((de.schlichtherle.io.File)file).getEnclArchive()) {
                zipFile = new ZipFile((File)file2);
                linkedHashMap = new LinkedHashMap();
                if (file == file2) {
                    linkedHashMap.put(d.getString("Path"), file.getAbsolutePath());
                    linkedHashMap.put(d.getString("Files"), String.valueOf(zipFile.size()));
                    long l2 = 0L;
                    long l3 = 0L;
                    Enumeration enumeration = zipFile.entries();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                            l2 += zipEntry.getCompressedSize();
                            l3 += zipEntry.getSize();
                        }
                    }
                    linkedHashMap.put(d.getString("Compressed_size"), numberFormat.format(l2) + " bytes");
                    linkedHashMap.put(d.getString("Size"), numberFormat.format(l3) + " bytes");
                    int n2 = 0;
                    if (l3 != 0L) {
                        n2 = (int)((l3 - l2) * 100L / l3);
                    }
                    linkedHashMap.put(d.getString("Deflated"), String.valueOf(n2) + "%");
                    if (zipFile.getComment() == null) return linkedHashMap;
                    linkedHashMap.put(d.getString("Comment"), zipFile.getComment());
                    return linkedHashMap;
                } else if (file.isFile() || ((de.schlichtherle.io.File)file).isArchive()) {
                    ZipEntry zipEntry = zipFile.getEntry(((de.schlichtherle.io.File)file).getEnclEntryName());
                    if (zipEntry == null) throw new IOException("Could not obtain entry for: " + file);
                    linkedHashMap.put(d.getString("File_name"), zipEntry.getName());
                    linkedHashMap.put(d.getString("Compressed_size"), numberFormat.format(zipEntry.getCompressedSize()) + " bytes");
                    linkedHashMap.put(d.getString("Size"), numberFormat.format(zipEntry.getSize()) + " bytes");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
                    linkedHashMap.put(d.getString("Last_change_date"), simpleDateFormat.format(new Date(zipEntry.getTime())));
                    linkedHashMap.put("CRC32", Long.toHexString(zipEntry.getCrc()));
                    linkedHashMap.put(d.getString("Comment"), zipEntry.getComment());
                    return linkedHashMap;
                } else {
                    linkedHashMap.put(d.getString("Folder_name"), ((de.schlichtherle.io.File)file).getEnclEntryName());
                }
                return linkedHashMap;
            } else {
                linkedHashMap = new LinkedHashMap<String, Object>();
                linkedHashMap.put(d.getString("File_name"), file.getName());
                linkedHashMap.put(d.getString("Size"), numberFormat.format(file.length()) + " bytes");
            }
            return linkedHashMap;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    this.b.error((Object)iOException, (Throwable)iOException);
                }
            }
        }
    }

    public File[] condenseFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(fileArray));
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file = fileArray[i2];
            for (int i3 = i2 + 1; i3 < fileArray.length; ++i3) {
                File file2 = fileArray[i3];
                if (!(file instanceof de.schlichtherle.io.File) || !(file2 instanceof de.schlichtherle.io.File)) continue;
                if (((de.schlichtherle.io.File)file).isParentOf(file2)) {
                    arrayList.remove(file2);
                    continue;
                }
                if (!((de.schlichtherle.io.File)file2).isParentOf(file)) continue;
                arrayList.remove(file);
            }
        }
        return arrayList.toArray(new File[0]);
    }

    public UnsupportedCharsetException getUnsupportedCharsetException() {
        return this.c;
    }

    public boolean askIfUnknownArchive(File file) {
        boolean bl = false;
        if (file != null && file.exists() && file.isFile() && !(bl = this.hasArchiveExtension(file))) {
            String string = URLUtil.getExtension((String)file.getName());
            if (string != null && !"".equals(string.trim())) {
                if (og.p(file.getPath()) == null) {
                    String string2 = d.getString("Unknown_archive_extension_warning");
                    string2 = MessageFormat.format(string2, "'" + string + "'");
                    if (v.getInstance().showConfirmDialog(string2) == 0) {
                        ArchiveDescriptor archiveDescriptor = new ArchiveDescriptor(string + " archive", new String[]{string}, 0);
                        t.i().b(archiveDescriptor);
                        t.i().g();
                        v.getInstance().getPreferencePagePresenter().c();
                        if (this.hasArchiveExtension(file)) {
                            this.initTrueZIPLibrary();
                            bl = true;
                        }
                    }
                } else {
                    v.getInstance().showErrorMessage(d.getString("The_archive_has_an_unknown_format"));
                }
            } else {
                v.getInstance().showErrorMessage(d.getString("Invalid_archive_extension"));
            }
        }
        return bl;
    }

    public boolean isArchiveEntry(File file) {
        return BasicArchiveUtil.isArchiveEntry((File)file);
    }

    public boolean isTopLevelArchive(File file) {
        return file instanceof de.schlichtherle.io.File && file.exists() && ((de.schlichtherle.io.File)file).isArchive() && ((de.schlichtherle.io.File)file).getDelegate().isFile();
    }

    public boolean isArchive(File file) {
        return file instanceof de.schlichtherle.io.File && file.exists() && ((de.schlichtherle.io.File)file).isArchive();
    }

    public void umount(File file) {
        l.t().p(file);
    }

    public void updateLastModified(File file) {
        File file2 = URLUtil.getTopArchive((String)file.getAbsolutePath());
        if (file2 != null) {
            file2.setLastModified(System.currentTimeMillis());
        } else {
            this.b.warn("Could not update archive modification time for archive entry: " + file);
        }
    }
}

