/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.view.graphics.BaseShape;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.view.graphics.Shape;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Circle
extends BaseShape {
    public final int x;
    public final int y;
    public final int radius;

    public Circle(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.radius = n4;
    }

    @Override
    public Rectangle getBounds() {
        int n2 = this.radius * 2;
        return new Rectangle(this.x - this.radius, this.y - this.radius, n2, n2);
    }

    @Override
    public Shape translate(int n2, int n3) {
        return new Circle(this.x + n2, this.y + n3, this.radius);
    }

    @Override
    public boolean contains(int n2, int n3) {
        int n4 = this.x - n2;
        int n5 = this.y - n3;
        int n6 = (int)Math.sqrt(n4 * n4 + n5 * n5);
        return this.radius >= n6;
    }

    public String toString() {
        return "Circle x=" + this.x + ", y=" + this.y + ", r=" + this.radius;
    }
}

