/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.Anchor;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.outline.TokenIndexPath;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XMLAnchor
implements Anchor {
    private static final Logger logger = LoggerFactory.getLogger((String)XMLAnchor.class.getName());
    public static final int AFTER_START = 0;
    public static final int AFTER_MIDDLE = 1;
    public static final int AFTER_END = 2;
    private TokenIndexPath indexPath;
    private boolean whitespaceBefore;
    private int tokenPosition;
    private int chCount;
    private int chCountInsideEnd;
    private String condition;
    private boolean anchorsOnChangeTrackingPI;
    private boolean isInTag;

    public String toString() {
        return this.getClass().getName() + " - [" + this.indexPath + ", ws: " + this.whitespaceBefore + ", after: " + this.tokenPosition + ", count: " + this.chCount + "]";
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.chCount < 0) {
            this.chCount = 0;
        }
        if (this.tokenPosition < 0) {
            this.tokenPosition = 0;
        }
        if (this.tokenPosition > 2) {
            this.tokenPosition = 2;
        }
    }

    public int getChCount() {
        return this.chCount;
    }

    public void setChCount(int n2) {
        this.chCount = n2;
    }

    public TokenIndexPath getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(TokenIndexPath tokenIndexPath) {
        this.indexPath = tokenIndexPath;
    }

    public int getTokenPosition() {
        return this.tokenPosition;
    }

    public void setTokenPosition(int n2) {
        this.tokenPosition = n2;
    }

    public boolean isWhitespaceBefore() {
        return this.whitespaceBefore;
    }

    public void setWhitespaceBefore(boolean bl) {
        this.whitespaceBefore = bl;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"condition"};
    }

    @Override
    public Object clone() {
        XMLAnchor xMLAnchor = null;
        try {
            xMLAnchor = (XMLAnchor)super.clone();
            if (this.indexPath != null) {
                xMLAnchor.indexPath = (TokenIndexPath)this.indexPath.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return xMLAnchor;
    }

    public void setAnchorsOnChangeTrackingPI(boolean bl) {
        this.anchorsOnChangeTrackingPI = bl;
    }

    public boolean getAnchorsOnChangeTrackingPI() {
        return this.anchorsOnChangeTrackingPI;
    }

    public void setChCountInsideEnd(int n2) {
        this.chCountInsideEnd = n2;
    }

    public int getChCountInsideEnd() {
        return this.chCountInsideEnd;
    }

    public boolean isInTag() {
        return this.isInTag;
    }

    public void setInTag(boolean bl) {
        this.isInTag = bl;
    }
}

