/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.projecteditingstate;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.Anchor;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.ui.marks.text.debugger.BreakpointAnchor;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class MarkLocation
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)MarkLocation.class.getName());
    URL systemID;
    Anchor anchor;

    public MarkLocation() {
    }

    public MarkLocation(URL uRL, Anchor anchor) {
        this.systemID = uRL;
        this.anchor = anchor;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.anchor == null) {
            throw new InvalidPersistentObjException("Missing anchor in the mark location.");
        }
        if (this.systemID == null && !(this.anchor instanceof BreakpointAnchor)) {
            throw new InvalidPersistentObjException("Missing system ID in the mark location.");
        }
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public URL getSystemID() {
        return this.systemID;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        MarkLocation markLocation = null;
        try {
            markLocation = (MarkLocation)super.clone();
            if (this.anchor != null) {
                markLocation.anchor = (Anchor)this.anchor.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return markLocation;
    }
}

