/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.testing;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.util.testing.StaticFieldOverrider;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorIdIndex;
import ro.sync.ecss.extensions.api.webapp.WebappActionsManager;
import ro.sync.ecss.extensions.api.webapp.WebappAuthorDocumentFactory;
import ro.sync.ecss.webapp.k.b;
import ro.sync.exml.editor.DocumentTypeRepository;
import ro.sync.exml.options.Options;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.io.TemporaryFilesFactory;
import ro.sync.net.protocol.OxygenURLStreamHandlerFactory;
import ro.sync.security.ISecurityChecker;
import ro.sync.security.SecurityChecker;
import ro.sync.ui.application.b.l;
import ro.sync.ui.application.security.g;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.xml.catalogresolver.CatalogResolverFactory;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class MockAuthorDocumentFactory {
    private static final Logger b = LoggerFactory.getLogger((String)MockAuthorDocumentFactory.class.getName());
    public static final String USER = "oxygen_user";
    private static boolean d = false;
    private static Thread c;

    public static void initForTest() {
        if (!d) {
            d = true;
            c = Thread.currentThread();
            try {
                MockAuthorDocumentFactory.setUrlStreamHandlerFactory(new OxygenURLStreamHandlerFactory());
            }
            catch (Error | Exception throwable) {
                b.debug((Object)throwable, throwable);
            }
            MockAuthorDocumentFactory.forceInitForTests();
            try {
                StaticFieldOverrider.overrideField(StaticComponentsRegistry.class, (String)"closed", (Object)Boolean.FALSE);
            }
            catch (Exception exception) {
                b.debug((Object)exception, (Throwable)exception);
            }
            MockAuthorDocumentFactory.f();
        }
        if (Thread.currentThread() == c) {
            ro.sync.ecss.webapp.d.b.c(USER);
        }
    }

    public static void forceInitForTests() {
        l.b(null);
        System.setProperty("com.oxygenxml.bundle.descriptor", "webapp");
        l.d();
        Options.clearInstanceTest();
        DocumentTypeRepository.clearInstanceTest();
        EditorVariables.resetFrameworksDir();
        PluginManager.setInstanceFromTC(null);
        PluginManager.setPluginsDir(null);
        File file = new File(".");
        try {
            if (!MockAuthorDocumentFactory.c(file) && !MockAuthorDocumentFactory.c(file = new File("test/fake_editor_home/"))) {
                b.warn("Failed to load frameworks from folder: {}. ", (Object)file.getAbsolutePath());
                file = new File("target/");
            }
            System.setProperty("com.oxygenxml.editor.home.url", URLUtil.correct((File)file).toString());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        try {
            System.setProperty("com.oxygenxml.bundle.descriptor", "webapp");
            WebappAuthorDocumentFactory.setOptions(file, null);
            Options.getInstance().setBooleanProperty("run.untrusted.referenced.code", true);
        }
        catch (MalformedURLException malformedURLException) {
            b.error((Object)malformedURLException, (Throwable)malformedURLException);
        }
        try {
            WebappAuthorDocumentFactory.setFrameworks(new File(file, "frameworks"));
        }
        catch (MalformedURLException malformedURLException) {
            b.error((Object)malformedURLException, (Throwable)malformedURLException);
        }
        CatalogResolverFactory.reset();
        SecurityChecker.setInstance((ISecurityChecker)new b(Options.getInstance(), new g()));
    }

    private static boolean c(File file) {
        File file2 = new File(file, "frameworks");
        return file2.exists();
    }

    private static Map<String, URLStreamHandler> d() throws NoSuchFieldException, IllegalAccessException {
        Field field = URL.class.getDeclaredField("handlers");
        field.setAccessible(true);
        Hashtable hashtable = (Hashtable)field.get(null);
        return hashtable;
    }

    private static void e(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        try {
            Map<String, URLStreamHandler> map = MockAuthorDocumentFactory.d();
            map.put("file", uRLStreamHandlerFactory.createURLStreamHandler("file"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setUrlStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) throws Exception {
        URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        if (uRLStreamHandlerFactory != null && uRLStreamHandlerFactory.createURLStreamHandler("file") != null) {
            MockAuthorDocumentFactory.e(uRLStreamHandlerFactory);
        }
    }

    private static void f() {
        Thread thread = Thread.currentThread();
        if (thread == c) {
            ro.sync.ecss.webapp.d.b.b();
        }
    }

    public static AuthorDocumentModel create(File file) throws Exception {
        String string = IOUtil.readFile((File)file, (String)"UTF8");
        return MockAuthorDocumentFactory.create(string, "");
    }

    public static AuthorDocumentModel create(File file, Map<String, Object> map) throws Exception {
        String string = IOUtil.read((Reader)new FileReader(file)).toString();
        return MockAuthorDocumentFactory.create(string, "", map);
    }

    public static AuthorDocumentModel create(String string, String string2, Map<String, Object> map) throws Exception {
        AuthorDocumentModel authorDocumentModel = MockAuthorDocumentFactory.createNoMocks(string, string2, map);
        AuthorDocumentModel authorDocumentModel2 = (AuthorDocumentModel)Mockito.spy((Object)authorDocumentModel);
        Mockito.when(authorDocumentModel2.getNodeIndexer()).thenReturn((Object)((AuthorIdIndex)Mockito.spy(authorDocumentModel.getNodeIndexer())));
        WebappActionsManager webappActionsManager = authorDocumentModel.getActionsManager();
        Mockito.when((Object)authorDocumentModel2.getActionsManager()).thenReturn((Object)((WebappActionsManager)Mockito.spy((Object)webappActionsManager)));
        ((AuthorDocumentModel)Mockito.doAnswer(invocationOnMock -> {
            authorDocumentModel.dispose();
            return null;
        }).when((Object)authorDocumentModel2)).dispose();
        return authorDocumentModel2;
    }

    public static AuthorDocumentModel create(String string, String string2) throws Exception {
        return MockAuthorDocumentFactory.create(string, string2, Collections.emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return MockAuthorDocumentFactory.createNoMocks(string, string2, Collections.emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String object, String string, Map<String, Object> map) throws IOException, ParserConfigurationException, SAXException {
        String string2 = "file:///dummy.xml";
        if (string != null && string.length() != 0) {
            object = MockAuthorDocumentFactory.getCSSPi(string) + (String)object;
        }
        StringReader stringReader = new StringReader((String)object);
        return WebappAuthorDocumentFactory.createAuthorDocumentInfo(string2, stringReader, map);
    }

    public static int getCSSProcessingInstructionLength(String string) throws IOException {
        String string2 = MockAuthorDocumentFactory.getCSSPi(string);
        return string2.length() - 2;
    }

    public static String getCSSPi(String string) throws IOException {
        File file = TemporaryFilesFactory.createNonConfidentialTempFile("webapp-css", ".css", null);
        file.deleteOnExit();
        FileUtils.writeStringToFile((File)file, (String)string, (Charset)StandardCharsets.UTF_8);
        return "<?xml-stylesheet type=\"text/css\" href=\"" + URLUtil.correct((File)file) + "\"?>";
    }

    static {
        MockAuthorDocumentFactory.initForTest();
    }
}

