/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationWithCustomUndoBehavior;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ReloadContentOperation
implements AuthorOperation,
AuthorOperationWithCustomUndoBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ReloadContentOperation.class.getName());
    static final String ARGUMENT_MARK_AS_NOT_MODIFIED = "markAsNotModified";
    static final String ARGUMENT_FORCED = "forced";
    static final String ARGUMENT_DISCARD_UNDOABLE_EDITS = "discard_undoable_edits";
    private static ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("markAsNotModified", 0, "After reloading the content the editor may appear as modified. Sometimes, the content is already present on the file server, so the user should not save it again. This flags can be used in these cases to prevent the editor from showing as modified", new String[]{"true", "false"}, "false"), new ArgumentDescriptor("forced", 0, "Control whether we force reloading the document even if the content did not change.", new String[]{"true", "false"}, "true"), new ArgumentDescriptor("discard_undoable_edits", 0, "Control whether we discard undoable edits.", new String[]{"true", "false"}, "false")};

    @Override
    public String getDescription() {
        return "Reloads the content of the editor by reading again from the URL used to open it";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        int n2 = authorEditorAccess.getAuthorSelectionModel().getSelectionInterval().getEndOffset();
        URL uRL = authorEditorAccess.getEditorLocation();
        Reader reader = null;
        boolean bl = true;
        try {
            reader = authorAccess.getUtilAccess().createReader(uRL, "UTF-8");
            if (ReloadContentOperation.isArgumentTrue(argumentsMap, ARGUMENT_FORCED)) {
                authorEditorAccess.reloadContent(reader, ReloadContentOperation.isArgumentTrue(argumentsMap, ARGUMENT_DISCARD_UNDOABLE_EDITS));
            } else {
                bl = ReloadContentOperation.reloadFromReaderIfModified(authorEditorAccess, reader);
            }
        }
        catch (IOException iOException) {
            throw new AuthorOperationException("Could not read the content of the editor from its URL: " + uRL, iOException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    LOGGER.debug("Could not close reader.", (Throwable)iOException);
                }
            }
        }
        if (ReloadContentOperation.isArgumentTrue(argumentsMap, ARGUMENT_MARK_AS_NOT_MODIFIED)) {
            authorAccess.getEditorAccess().setModified(false);
        }
        if (bl) {
            int n3 = authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset();
            if (n2 >= n3) {
                n2 = n3 - 1;
            }
            authorAccess.getEditorAccess().getAuthorSelectionModel().setSelection(n2, n2);
        }
    }

    private static boolean isArgumentTrue(ArgumentsMap argumentsMap, String string) {
        Object object = argumentsMap.getArgumentValue(string);
        return Boolean.TRUE.equals(object) || "true".equals(object);
    }

    private static boolean reloadFromReaderIfModified(AuthorEditorAccess authorEditorAccess, Reader reader) throws IOException {
        String string = IOUtil.read((Reader)reader).toString();
        String string2 = IOUtil.read((Reader)authorEditorAccess.createContentReader()).toString();
        boolean bl = true;
        if (!string.equals(string2)) {
            try (StringReader stringReader = new StringReader(string);){
                authorEditorAccess.reloadContent(stringReader, false);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }
}

