/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.imagemap.SupportedFrameworks;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class EditImageMapCore {
    private static final Logger logger = LoggerFactory.getLogger((String)EditImageMapCore.class.getName());

    protected AuthorNode getFullySelectedNode(AuthorDocumentController authorDocumentController, int n2, int n3, boolean bl) {
        AuthorNode authorNode = null;
        if (bl) {
            try {
                AuthorNode authorNode2;
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n2);
                if (offsetInformation.getPositionType() == 1 && (authorNode2 = authorDocumentController.getNodeAtOffset(n2 + 1)).getStartOffset() == n2 && authorNode2.getEndOffset() == n3 - 1) {
                    authorNode = authorNode2;
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return authorNode;
    }

    protected final AuthorNode findNodeOfInterest(AuthorAccess authorAccess, AuthorNode authorNode, String[] stringArray) throws BadLocationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        AuthorNode authorNode2 = authorNode;
        if (authorNode2 == null) {
            authorNode2 = this.getFullySelectedNode(authorDocumentController, authorEditorAccess.getSelectionStart(), authorEditorAccess.getSelectionEnd(), authorEditorAccess.hasSelection());
        }
        if (authorNode2 == null) {
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            authorNode2 = authorDocumentController.getNodeAtOffset(n2);
        }
        while (authorNode2 != null && !this.isNodeOfInterest(authorNode2, stringArray)) {
            authorNode2 = authorNode2.getParent();
        }
        return authorNode2;
    }

    private boolean isNodeOfInterest(AuthorNode authorNode, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!this.isNodeOfInterest(authorNode, stringArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNodeOfInterest(AuthorNode authorNode, String string) {
        if (authorNode.getType() == 0) {
            return string.equals(((AuthorElement)authorNode).getLocalName());
        }
        return false;
    }

    public abstract AuthorNode[] getNodesOfInterest(AuthorAccess var1, AuthorNode var2, boolean var3) throws BadLocationException, AuthorOperationException;

    public abstract SupportedFrameworks getSupportedFramework(String var1);
}

