/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceType;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class DiffEntry
implements Difference,
Comparable {
    private boolean d = false;
    protected Position lStart;
    protected Position lEnd;
    protected Position rStart;
    protected Position rEnd;
    private DifferenceType c = null;
    private DiffEntry b;

    public DiffEntry(Document document, int n2, int n3, Document document2, int n4, int n5) throws BadLocationException {
        this(document.createPosition(n2), document.createPosition(n3), document2.createPosition(n4), document2.createPosition(n5));
    }

    public DiffEntry(Position position, Position position2, Position position3, Position position4) {
        this.lStart = position;
        this.lEnd = position2;
        this.rStart = position3;
        this.rEnd = position4;
    }

    @Override
    public DifferenceType getType() {
        if (this.c != null) {
            return this.c;
        }
        DifferenceType differenceType = this.getLeftIntervalLength() > 0 && this.getRightIntervalLength() == 0 ? DifferenceType.LEFT_CHANGED : (this.getRightIntervalLength() > 0 && this.getLeftIntervalLength() == 0 ? DifferenceType.RIGHT_CHANGED : DifferenceType.BOTH_CHANGED);
        return differenceType;
    }

    public void enforceDifferenceType(DifferenceType differenceType) {
        this.c = differenceType;
    }

    @Override
    public int getLeftIntervalStart() {
        return this.lStart.getOffset();
    }

    @Override
    public int getLeftIntervalEnd() {
        return this.lEnd.getOffset();
    }

    public int getLeftIntervalLength() {
        return this.getLeftIntervalEnd() - this.getLeftIntervalStart();
    }

    @Override
    public int getRightIntervalStart() {
        return this.rStart.getOffset();
    }

    @Override
    public int getRightIntervalEnd() {
        return this.rEnd.getOffset();
    }

    public int getRightIntervalLength() {
        return this.getRightIntervalEnd() - this.getRightIntervalStart();
    }

    public boolean isMerged() {
        return this.d;
    }

    public void setIsMerged() {
        this.lEnd = this.lStart;
        this.rEnd = this.rStart;
        this.d = true;
    }

    public String toString() {
        return "Difference \nLeft interval [start: " + this.lStart + " end:" + this.lEnd + "]\nRight interval [start:" + this.rStart + " end:" + this.rEnd + "]\n";
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this;
        if (!bl && object instanceof DiffEntry) {
            DiffEntry diffEntry = (DiffEntry)object;
            bl = this.getType() == diffEntry.getType() && this.getLeftIntervalStart() == diffEntry.getLeftIntervalStart() && this.getLeftIntervalEnd() == diffEntry.getLeftIntervalEnd() && this.getRightIntervalStart() == diffEntry.getRightIntervalStart() && this.getRightIntervalEnd() == diffEntry.getRightIntervalEnd();
        }
        return bl;
    }

    public int hashCode() {
        return ("" + this.getType() + this.getLeftIntervalStart() + this.getRightIntervalStart()).hashCode();
    }

    public int compareTo(Object object) {
        int n2 = 0;
        if (object instanceof DiffEntry) {
            DiffEntry diffEntry = (DiffEntry)object;
            n2 = this.getRightIntervalStart() - diffEntry.getRightIntervalStart();
            if (n2 == 0 && (n2 = this.getRightIntervalEnd() - diffEntry.getRightIntervalEnd()) == 0 && (n2 = this.getLeftIntervalStart() - diffEntry.getLeftIntervalStart()) == 0) {
                n2 = this.getLeftIntervalEnd() - diffEntry.getLeftIntervalEnd();
            }
        }
        return n2;
    }

    public void setLeftIntervalStartPosition(Position position) {
        this.lStart = position;
    }

    public void setRightIntervalStartPosition(Position position) {
        this.rStart = position;
    }

    public void setLeftIntervalEndPosition(Position position) {
        this.lEnd = position;
    }

    public void setRightIntervalEndPosition(Position position) {
        this.rEnd = position;
    }

    public void setParentDifference(DiffEntry diffEntry) {
        this.b = diffEntry;
    }

    public DiffEntry getParentDifference() {
        return this.b;
    }
}

