/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.Icon;

public abstract class AbstractArchiveDriver
implements ArchiveDriver,
Serializable {
    private static final long serialVersionUID = 6546816846546846516L;
    private final String charset;
    private final Icon openIcon;
    private final Icon closedIcon;
    private transient ThreadLocalEncoder encoder;

    protected AbstractArchiveDriver(String charset, Icon openIcon, Icon closedIcon) {
        this.charset = charset;
        this.encoder = new ThreadLocalEncoder();
        this.openIcon = openIcon;
        this.closedIcon = closedIcon;
        UnsupportedEncodingException uee = AbstractArchiveDriver.testJSE11Support(charset);
        UnsupportedCharsetException uce = AbstractArchiveDriver.testJSE14Support(charset);
        if (uee != null || uce != null) {
            if (uee == null) {
                throw new InconsistentCharsetSupportError(charset, uce);
            }
            if (uce == null) {
                throw new InconsistentCharsetSupportError(charset, uee);
            }
            throw uce;
        }
        assert (this.invariants());
    }

    private static UnsupportedEncodingException testJSE11Support(String charset) {
        try {
            new String(new byte[0], charset);
        }
        catch (UnsupportedEncodingException ex) {
            return ex;
        }
        return null;
    }

    private static UnsupportedCharsetException testJSE14Support(String charset) {
        try {
            Charset.forName(charset);
        }
        catch (UnsupportedCharsetException ex) {
            return ex;
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        assert (this.encoder == null);
        this.encoder = new ThreadLocalEncoder();
        try {
            this.invariants();
        }
        catch (AssertionError ex) {
            throw (InvalidObjectException)new InvalidObjectException(((Throwable)((Object)ex)).toString()).initCause((Throwable)((Object)ex));
        }
    }

    private boolean invariants() {
        if (this.charset == null) {
            throw new AssertionError((Object)"character set not initialized");
        }
        try {
            this.ensureEncodable("");
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
        return true;
    }

    protected void ensureEncodable(String entryName) throws CharConversionException {
        if (!this.encoder.canEncode(entryName)) {
            throw new CharConversionException(entryName + " (illegal characters in entry name)");
        }
    }

    public final String getCharset() {
        return this.charset;
    }

    @Deprecated
    public final String getEncoding() {
        return this.charset;
    }

    @Override
    public final Icon getOpenIcon(Archive archive) {
        return this.openIcon;
    }

    @Override
    public final Icon getClosedIcon(Archive archive) {
        return this.closedIcon;
    }

    private final class ThreadLocalEncoder
    extends ThreadLocal {
        private ThreadLocalEncoder() {
        }

        protected Object initialValue() {
            return Charset.forName(AbstractArchiveDriver.this.charset).newEncoder();
        }

        boolean canEncode(CharSequence cs) {
            return ((CharsetEncoder)this.get()).canEncode(cs);
        }
    }

    protected static final class InconsistentCharsetSupportError
    extends Error {
        private InconsistentCharsetSupportError(String charset, Exception cause) {
            super(InconsistentCharsetSupportError.message(charset, cause), cause);
        }

        private static String message(String charset, Exception cause) {
            String[] stringArray;
            assert (cause instanceof UnsupportedEncodingException || cause instanceof UnsupportedCharsetException);
            if (cause instanceof UnsupportedEncodingException) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "J2SE 1.4";
                stringArray = stringArray2;
                stringArray2[1] = "JSE 1.1";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "JSE 1.1";
                stringArray = stringArray3;
                stringArray3[1] = "J2SE 1.4";
            }
            String[] api = stringArray;
            return "The character set '" + charset + "' is supported by the " + api[0] + " API, but not the " + api[1] + " API.\nThis requires fixing the Java Runtime Environment!\nPlease read the Javadoc of this error class for more information.";
        }
    }
}

