/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.AbstractArchiveDetector;
import de.schlichtherle.io.ArchiveDriverRegistry;
import de.schlichtherle.io.GlobalArchiveDriverRegistry;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.util.SuffixSet;
import de.schlichtherle.util.regex.ThreadLocalMatcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;

public class DefaultArchiveDetector
extends AbstractArchiveDetector
implements Serializable {
    private static final long serialVersionUID = 848158760183179884L;
    public static final String DEFAULT_SUFFIXES;
    public static final String ALL_SUFFIXES;
    private final ArchiveDriverRegistry registry;
    private final String list;
    private transient ThreadLocalMatcher matcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultArchiveDetector(String string) {
        this.registry = GlobalArchiveDriverRegistry.INSTANCE;
        SuffixSet suffixSet = new SuffixSet(string);
        SuffixSet suffixSet2 = this.registry.suffixes();
        if (suffixSet.retainAll(suffixSet2)) {
            SuffixSet suffixSet3 = new SuffixSet(string);
            suffixSet3.removeAll(suffixSet2);
            throw new IllegalArgumentException("\"" + suffixSet3 + "\" (no archive driver installed for these suffixes)");
        }
        this.list = suffixSet.toString();
        this.matcher = new ThreadLocalMatcher(suffixSet.toRegex());
    }

    public DefaultArchiveDetector(String string, ArchiveDriver archiveDriver) {
        this(NULL, string, archiveDriver);
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, String string, ArchiveDriver archiveDriver) {
        this(defaultArchiveDetector, new Object[]{string, archiveDriver});
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, Object[] objectArray) {
        this(defaultArchiveDetector, DefaultArchiveDetector.toMap(objectArray));
    }

    public DefaultArchiveDetector(DefaultArchiveDetector defaultArchiveDetector, Map map) {
        this.registry = new ArchiveDriverRegistry(defaultArchiveDetector.registry, map);
        SuffixSet suffixSet = this.registry.decorate(new SuffixSet(defaultArchiveDetector.list));
        this.list = suffixSet.toString();
        this.matcher = new ThreadLocalMatcher(suffixSet.toRegex());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.matcher = new ThreadLocalMatcher(new SuffixSet(this.list).toRegex());
    }

    private static Map toMap(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>((int)((double)objectArray.length / 0.75) + 1);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            linkedHashMap.put(objectArray[i], objectArray[++i]);
        }
        return linkedHashMap;
    }

    public ArchiveDriver getArchiveDriver(String string) {
        Matcher matcher = this.matcher.reset(string);
        if (!matcher.matches()) {
            return null;
        }
        ArchiveDriver archiveDriver = this.registry.getArchiveDriver(matcher.group(1).toLowerCase(Locale.ENGLISH));
        if (!$assertionsDisabled && archiveDriver == null) {
            throw new AssertionError((Object)"archive driver does not exist for a recognized suffix");
        }
        return archiveDriver;
    }

    public String getSuffixes() {
        return this.list;
    }

    static {
        $assertionsDisabled = !DefaultArchiveDetector.class.desiredAssertionStatus();
        DEFAULT_SUFFIXES = GlobalArchiveDriverRegistry.INSTANCE.defaultSuffixes;
        ALL_SUFFIXES = GlobalArchiveDriverRegistry.INSTANCE.allSuffixes;
    }
}

