/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.option.sql.SQLColumn;
import net.sf.saxon.option.sql.SQLConnect;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Whitespace;

public class SQLInsert
extends ExtensionInstruction {
    Expression connection;
    String table;

    protected void prepareAttributes() {
        this.table = this.attributes().getValue(NamespaceUri.NULL, "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        AttributeInfo connectAtt = this.attributes().get(NamespaceUri.NULL, "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt.getValue(), connectAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.connection = this.typeCheck("connection", this.connection);
        for (NodeInfo curr : this.children()) {
            if (curr instanceof SQLColumn || curr.getNodeKind() == 3 && Whitespace.isAllWhite((UnicodeString)curr.getUnicodeStringValue())) continue;
            this.compileError("Only sql:column is allowed as a child of sql:insert", "XTSE0010");
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        StringBuilder statement = new StringBuilder(120);
        statement.append("INSERT INTO ").append(this.table).append(" (");
        int cols = 0;
        for (NodeInfo child : this.children(SQLColumn.class::isInstance)) {
            if (cols++ > 0) {
                statement.append(',');
            }
            String colname = ((SQLColumn)child).getColumnName();
            statement.append(colname);
        }
        statement.append(") VALUES (");
        for (int i = 0; i < cols; ++i) {
            if (i != 0) {
                statement.append(',');
            }
            statement.append('?');
        }
        statement.append(')');
        return new InsertInstruction(this.connection, statement.toString(), this.getColumnInstructions(exec, decl));
    }

    public List<Expression> getColumnInstructions(Compilation exec, ComponentDeclaration decl) throws XPathException {
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        for (NodeInfo child : this.children(SQLColumn.class::isInstance)) {
            list.add(((SQLColumn)child).compile(exec, decl));
        }
        return list;
    }

    private static class InsertInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int FIRST_COLUMN = 1;
        String statement;

        public InsertInstruction(Expression connection, String statement, List<Expression> columnInstructions) {
            Expression[] sub = new Expression[columnInstructions.size() + 1];
            sub[0] = connection;
            for (int i = 0; i < columnInstructions.size(); ++i) {
                sub[i + 1] = columnInstructions.get(i);
            }
            this.statement = statement;
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:insert";
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
            try (PreparedStatement ps = connection.prepareStatement(this.statement);){
                ParameterMetaData metaData = ps.getParameterMetaData();
                int i = 1;
                for (int c = 1; c < arguments.length; ++c) {
                    Object value;
                    AtomicValue v = (AtomicValue)arguments[c].head();
                    String parameterClassName = null;
                    try {
                        parameterClassName = metaData.getParameterClassName(c);
                    }
                    catch (SQLException ex) {
                        parameterClassName = "java.lang.String";
                    }
                    switch (parameterClassName) {
                        case "java.lang.String": {
                            value = v.getStringValue();
                            break;
                        }
                        case "java.sql.Date": {
                            value = Date.valueOf(v.getStringValue());
                            break;
                        }
                        default: {
                            try {
                                Class<?> targetClass = Class.forName(parameterClassName);
                                PJConverter converter = PJConverter.allocate((Configuration)context.getConfiguration(), (ItemType)v.getPrimitiveType(), (int)16384, targetClass);
                                value = converter.convert((Sequence)v, targetClass, context);
                                break;
                            }
                            catch (ClassNotFoundException err) {
                                throw new XPathException("xsl:insert - cannot convert value to required class " + parameterClassName);
                            }
                        }
                    }
                    ps.setObject(i++, value);
                }
                ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("SQL INSERT failed: " + ex.getMessage(), "SXSQ0004", context);
            }
            return EmptySequence.getInstance();
        }
    }
}

