/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Pattern;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;
    Expression autoCommit = Literal.makeEmptySequence();
    private static final Pattern namePattern = Pattern.compile("\"[^\"]+\"|[A-Za-z_][A-Za-z0-9_]*");

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected void prepareAttributes() {
        AttributeMap atts = this.attributes();
        AttributeInfo dbAtt = atts.get(NamespaceUri.NULL, "database");
        String dbName = "";
        if (dbAtt == null) {
            this.reportAbsence("database");
        } else {
            dbName = dbAtt.getValue();
        }
        this.database = this.makeAttributeValueTemplate(dbName, dbAtt);
        AttributeInfo dbDriver = atts.get(NamespaceUri.NULL, "driver");
        String dbDriverName = null;
        if (dbDriver == null) {
            if (dbName.length() > 9 && dbName.substring(0, 9).equals("jdbc:odbc")) {
                dbDriverName = "sun.jdbc.odbc.JdbcOdbcDriver";
            }
        } else {
            dbDriverName = dbDriver.getValue();
        }
        this.driver = dbDriverName != null ? this.makeAttributeValueTemplate(dbDriverName, dbDriver) : Literal.makeEmptySequence();
        AttributeInfo dbUser = atts.get(NamespaceUri.NULL, "user");
        String dbUserName = null;
        if (dbUser == null) {
            this.reportAbsence("user");
        } else {
            dbUserName = dbUser.getValue();
        }
        this.user = this.makeAttributeValueTemplate(dbUserName, dbUser);
        AttributeInfo dbPass = atts.get(NamespaceUri.NULL, "password");
        String dbPassword = null;
        if (dbPass == null) {
            this.reportAbsence("password");
        } else {
            dbPassword = dbPass.getValue();
        }
        this.password = this.makeAttributeValueTemplate(dbPassword, dbPass);
        AttributeInfo dbAutoCommit = atts.get(NamespaceUri.NULL, "auto-commit");
        if (dbAutoCommit != null) {
            String dbAuto = dbAutoCommit.getValue();
            this.autoCommit = this.makeAttributeValueTemplate(dbAuto, dbAutoCommit);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.getConfiguration().checkLicensedFeature(8, "sql:connect", this.getPackageData().getLocalLicenseId());
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
        this.autoCommit = this.typeCheck("auto-commit", this.autoCommit);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password, this.autoCommit);
    }

    public static String quoteSqlName(String name) {
        if (namePattern.matcher(name).matches()) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }

    public static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;
        public static final int AUTOCOMMIT = 4;

        private ConnectInstruction() {
        }

        public ConnectInstruction(Expression database, Expression driver, Expression user, Expression password, Expression autoCommit) {
            Expression[] subs = new Expression[]{database, driver, user, password, autoCommit};
            this.setArguments(subs);
        }

        public int getImplementationMethod() {
            return 1;
        }

        protected int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:connect";
        }

        public ConnectInstruction copy(RebindingMap rebindings) {
            return (ConnectInstruction)new ConnectInstruction().copyOperandsFrom(this);
        }

        public ObjectValue<Connection> call(XPathContext context, Sequence[] arguments) throws XPathException {
            Connection connection = null;
            String dbString = this.str(arguments[0]);
            String dbDriverString = this.str(arguments[1]);
            String userString = this.str(arguments[2]);
            String pwdString = this.str(arguments[3]);
            String autoCommitString = this.str(arguments[4]);
            try {
                Class.forName(dbDriverString);
            }
            catch (ClassNotFoundException e) {
                throw new XPathException("Failed to load JDBC driver " + dbDriverString, (Throwable)e).withXPathContext(context).withErrorCode("SXSQ0003").withLocation(this.getLocation());
            }
            try {
                if (context.getConfiguration().isTiming()) {
                    DriverManager.setLogWriter(new PrintWriter(System.err));
                }
                connection = DriverManager.getConnection(dbString, userString, pwdString);
            }
            catch (SQLException ex) {
                throw new XPathException("JDBC Connection Failure", (Throwable)ex).withXPathContext(context).withErrorCode("SXSQ0003").withLocation(this.getLocation());
            }
            try {
                if (autoCommitString.length() > 0) {
                    connection.setAutoCommit("yes".equals(autoCommitString));
                }
            }
            catch (SQLException e) {
                throw new XPathException("Failed to set autoCommit on JDBC connection " + dbDriverString, (Throwable)e).withXPathContext(context).withErrorCode("SXSQ0003").withLocation(this.getLocation());
            }
            return new ObjectValue((Object)connection, Connection.class);
        }

        private String str(Sequence iterator) throws XPathException {
            Item item = iterator.head();
            return item == null ? "" : item.getStringValue();
        }
    }
}

