/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.sql.SQLConnect;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class SQLColumn
extends StyleElement {
    private String name;
    private Expression select;

    public boolean isInstruction() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return false;
    }

    protected void prepareAttributes() {
        String selectAtt = null;
        String nameAtt = null;
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("name")) {
                nameAtt = Whitespace.trim((String)value);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = value;
                this.select = this.makeExpression(selectAtt, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            this.name = "saxon-dummy-column";
        } else {
            this.name = SQLConnect.quoteSqlName(nameAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        try {
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(4, "sql:column/select", 0);
            this.select = this.getConfiguration().getTypeChecker(false).staticTypeCheck(this.select, SequenceType.SINGLE_ATOMIC, role, this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return this.select;
    }

    public String getColumnName() {
        return this.getAttributeValue(NamespaceUri.NULL, "name");
    }
}

