/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLConnectFn;
import com.saxonica.functions.sql.SQLDeleteFn;
import com.saxonica.functions.sql.SQLExecuteFn;
import com.saxonica.functions.sql.SQLInsertFn;
import com.saxonica.functions.sql.SQLPreparedQueryFn;
import com.saxonica.functions.sql.SQLPreparedStatementFn;
import com.saxonica.functions.sql.SQLQueryFn;
import com.saxonica.functions.sql.SQLUpdateFn;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SQLFunctionSet
extends BuiltInFunctionSet {
    protected Configuration config;

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.init();
    }

    public static List<MapItem> sqlQueryResult(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        ArrayList<MapItem> out = new ArrayList<MapItem>();
        int icol = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            DictionaryMap map = new DictionaryMap();
            for (int col = 1; col <= icol; ++col) {
                String result = rs.getString(col);
                String sqlName = metaData.getColumnName(col);
                if (map.containsStringKey(sqlName)) {
                    int suffix = 1;
                    String baseName = sqlName;
                    sqlName = baseName + suffix;
                    while (map.containsStringKey(sqlName)) {
                        sqlName = baseName + ++suffix;
                    }
                }
                map.initialPut(sqlName, (GroundedValue)(result == null ? EmptySequence.getInstance() : new StringValue(result)));
            }
            out.add((MapItem)map);
        }
        return out;
    }

    public static void setSqlStatementParam(PreparedStatement ps, int index, Sequence value, XPathContext context) throws XPathException {
        block16: {
            try {
                AtomicSequence as = Atomizer.atomize((Sequence)value);
                ParameterMetaData metaData = ps.getParameterMetaData();
                if (as.getLength() == 0) {
                    ps.setNull(index, JDBCType.NULL.ordinal());
                    break block16;
                }
                if (as.getLength() == 1) {
                    AtomicValue av = as.head();
                    String parameterClassName = null;
                    try {
                        parameterClassName = metaData.getParameterClassName(index);
                    }
                    catch (SQLException ex) {
                        parameterClassName = "java.lang.String";
                    }
                    Object obj = null;
                    switch (parameterClassName) {
                        case "java.lang.String": {
                            ps.setString(index, av.getStringValue());
                            return;
                        }
                        case "java.sql.Date": {
                            obj = Date.valueOf(av.getStringValue());
                            break;
                        }
                        default: {
                            try {
                                Class<?> targetClass = Class.forName(parameterClassName);
                                PJConverter converter = PJConverter.allocate((Configuration)context.getConfiguration(), (ItemType)av.getPrimitiveType(), (int)16384, targetClass);
                                obj = converter.convert((Sequence)av, targetClass, context);
                                break;
                            }
                            catch (ClassNotFoundException err) {
                                throw new XPathException("Cannot convert value to required class " + parameterClassName);
                            }
                        }
                    }
                    ps.setObject(index, obj);
                    break block16;
                }
                throw new XPathException("Cannot substitute sequence of length " + as.getLength() + " into prepared SQL statement");
            }
            catch (SQLException e) {
                throw new XPathException("Failure supplying argument to prepared SQL statement", (Throwable)e);
            }
        }
    }

    public static void supplyParameters(ParameterMetaData metaData, SequenceType[] parameterTypes) throws SQLException {
        int arity = metaData.getParameterCount();
        block20: for (int i = 0; i < arity; ++i) {
            String parameterClassName = null;
            try {
                parameterClassName = metaData.getParameterClassName(i + 1);
            }
            catch (SQLException ex) {
                parameterClassName = "java.lang.String";
            }
            switch (parameterClassName) {
                default: {
                    parameterTypes[i] = SequenceType.SINGLE_STRING;
                    continue block20;
                }
                case "java.lang.Boolean": {
                    parameterTypes[i] = SequenceType.SINGLE_BOOLEAN;
                    continue block20;
                }
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Short": 
                case "java.lang.Byte": {
                    parameterTypes[i] = SequenceType.SINGLE_INTEGER;
                    continue block20;
                }
                case "java.lang.Double": {
                    parameterTypes[i] = SequenceType.SINGLE_DOUBLE;
                    continue block20;
                }
                case "java.lang.Float": {
                    parameterTypes[i] = SequenceType.SINGLE_FLOAT;
                    continue block20;
                }
                case "java.math.BigDecimal": {
                    parameterTypes[i] = SequenceType.SINGLE_DECIMAL;
                }
            }
        }
    }

    public static Connection expectConnection(Sequence arg, XPathContext context) throws XPathException {
        Item conn = arg.head();
        if (!(conn instanceof AnyExternalObject) || !(((AnyExternalObject)conn).getWrappedObject() instanceof Connection)) {
            throw new XPathException("Value of connection argument is not a JDBC Connection", "SXSQ0001", context);
        }
        return (Connection)((AnyExternalObject)conn).getWrappedObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        JavaExternalObjectType result;
        Configuration configuration = this.config;
        synchronized (configuration) {
            result = JavaExternalObjectType.of(Connection.class);
        }
        JavaExternalObjectType connectionType = result;
        this.register("connect", 1, e -> e.populate(SQLConnectFn::new, (ItemType)connectionType, 16384, 512).arg(0, (ItemType)MapType.ANY_MAP_TYPE, 16384, null));
        this.register("delete", 3, e -> e.populate(SQLDeleteFn::new, (ItemType)AnyItemType.getInstance(), 24576, 8704).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null));
        this.register("execute", 2, e -> e.populate(SQLExecuteFn::new, (ItemType)AnyItemType.getInstance(), 24576, 8704).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null));
        this.register("insert", 3, e -> e.populate(SQLInsertFn::new, (ItemType)AnyItemType.getInstance(), 24576, 8704).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)MapType.ANY_MAP_TYPE, 16384, null));
        this.register("prepared-statement", 2, e -> e.populate(SQLPreparedStatementFn::new, (ItemType)AnyItemType.getInstance(), 24576, 512).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null));
        this.register("prepared-query", 2, e -> e.populate(SQLPreparedQueryFn::new, (ItemType)AnyFunctionType.getInstance(), 16384, 512).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null));
        this.register("query", 3, e -> e.populate(SQLQueryFn::new, (ItemType)MapType.ANY_MAP_TYPE, 57344, 512).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 57344, null));
        this.register("query", 4, e -> e.populate(SQLQueryFn::new, (ItemType)MapType.ANY_MAP_TYPE, 57344, 512).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 57344, null).arg(3, (ItemType)BuiltInAtomicType.STRING, 16384, null));
        this.register("update", 4, e -> e.populate(SQLUpdateFn::new, (ItemType)AnyItemType.getInstance(), 24576, 8704).arg(0, (ItemType)connectionType, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(3, (ItemType)MapType.ANY_MAP_TYPE, 16384, null));
    }

    public NamespaceUri getNamespace() {
        return NamespaceUri.SQL;
    }

    public String getConventionalPrefix() {
        return "sql";
    }
}

