/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathActivationRule
extends AbstractXMLActivationRule {
    protected static final byte S_XE_RECOGNIZED_OPEN_TAG = 1;
    protected static final byte S_XE_RECOGNIZED_ATTRIBUTE_NAME = 2;
    protected static final byte S_XE_RECOGNIZED_EQUALS_OPERATOR = 3;
    public static final byte S_NXE_RECOGNIZED_OPEN_TAG = 4;
    public static final byte S_NXE_RECOGNIZED_ATTRIBUTE_NAME_USE_WHEN = 5;
    public static final byte S_NXE_RECOGNIZED_EQUALS_OPERATOR_USE_WHEN = 6;
    private static final byte S_XE_ACTIVE_OPEN_PARANTHESIS_SQ = 7;
    private static final byte S_XE_ACTIVE_OPEN_PARANTHESIS_DQ = 8;
    protected static final byte S_XE_ACTIVE_SQ = 10;
    protected static final byte S_XE_ACTIVE_DQ = 11;
    protected static final byte S_NXE_ACTIVE_SQ = 12;
    protected static final byte S_NXE_ACTIVE_DQ = 13;
    private static final byte S_NXE_ACTIVE_OPEN_PARANTHESIS_SQ = 14;
    private static final byte S_NXE_ACTIVE_OPEN_PARANTHESIS_DQ = 15;
    public static final byte S_NXE_USE_WHEN_ACTIVE_SQ = 16;
    public static final byte S_NXE_USE_WHEN_ACTIVE_DQ = 17;
    private static final Logger logger = LoggerFactory.getLogger((String)XPathActivationRule.class.getName());
    private static final char BRACE_OPEN_CHAR = '{';
    private static final char BRACE_CLOSED_CHAR = '}';
    private String lastUpdatedOriginalTokenText;
    private byte lastUpdatedTokenId;
    private int[][] lastIntRanges;
    private final String[] elementsWithXPathAttributes;
    private final int[] elementsWithXPathAttributesLen;
    private final Map<String, List<String>> elementsToAttributesMap = new HashMap<String, List<String>>();
    String lastKnownTag;
    private static final int[] ACTIVATION_STATES = new int[]{10, 11, 7, 8, 12, 13, 16, 17, 14, 15};
    private static final ActivationRange[] ERA;

    public XPathActivationRule(Map<String, List<String>> elementsToAttributesMap) {
        this.elementsToAttributesMap.putAll(elementsToAttributesMap);
        this.elementsWithXPathAttributes = elementsToAttributesMap.keySet().toArray(new String[0]);
        this.elementsWithXPathAttributesLen = new int[this.elementsWithXPathAttributes.length];
        for (int i = 0; i < this.elementsWithXPathAttributesLen.length; ++i) {
            this.elementsWithXPathAttributesLen[i] = this.elementsWithXPathAttributes[i].length();
        }
    }

    @Override
    public boolean isStartTag(byte tokenID) {
        return super.isStartTag(tokenID) || tokenID == 17;
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastUpdatedTokenId = tokenId;
        this.lastUpdatedOriginalTokenText = originalTokenText;
        this.lastIntRanges = null;
        String tokenText = trimmedTokenText;
        boolean isEmpty = tokenText.isEmpty();
        boolean pushback = false;
        do {
            logger.debug("Updating {} - '{}'\t in state {}{}", new Object[]{tokenId, trimmedTokenText, this.state, pushback ? " (pushed back)" : ""});
            pushback = false;
            switch (this.state) {
                case 0: {
                    if (!this.isStartTag(tokenId) || tokenText.startsWith("</")) break;
                    int cIdx = tokenText.indexOf(58) + 1;
                    if (cIdx == 0 && !tokenText.isEmpty() && tokenText.charAt(0) == '<') {
                        ++cIdx;
                    }
                    boolean found = false;
                    int len = this.elementsWithXPathAttributes.length;
                    for (int i = 0; i < len && !found; ++i) {
                        this.lastKnownTag = null;
                        if (tokenText.length() - cIdx != this.elementsWithXPathAttributesLen[i] || !tokenText.regionMatches(cIdx, this.elementsWithXPathAttributes[i], 0, this.elementsWithXPathAttributesLen[i])) continue;
                        found = true;
                        this.lastKnownTag = this.elementsWithXPathAttributes[i];
                    }
                    this.state = (byte)(found ? 1 : 4);
                    break;
                }
                case 4: {
                    if (tokenId == 7) {
                        if (!tokenText.endsWith("use-when")) break;
                        this.state = (byte)5;
                        break;
                    }
                    if (XPathActivationRule.isAttributeValueQuote(tokenId)) {
                        this.updateParenthesisRangeAndCorrespondingState(tokenId, originalTokenText, Map.of((byte)4, new byte[]{14, 12}, (byte)3, new byte[]{15, 13}));
                        break;
                    }
                    if (tokenId == 9) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 1: {
                    List<String> xpathAttributes = this.elementsToAttributesMap.get(this.lastKnownTag);
                    if (tokenId == 7 && xpathAttributes != null && xpathAttributes.contains(tokenText)) {
                        this.state = (byte)2;
                        break;
                    }
                    if (tokenId == 7 || tokenId == 9) break;
                    if (XPathActivationRule.isAttributeValueQuote(tokenId)) {
                        this.updateParenthesisRangeAndCorrespondingState(tokenId, originalTokenText, Map.of((byte)4, new byte[]{7, 10}, (byte)3, new byte[]{8, 11}));
                        break;
                    }
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)3;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)6;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    this.state = 0;
                    break;
                }
                case 6: {
                    if (XPathActivationRule.isAttributeValueQuote(tokenId)) {
                        this.lastIntRanges = XPathActivationRule.getAllValueRanges(tokenId, this.lastUpdatedOriginalTokenText);
                        this.state = (byte)(tokenId == 4 ? 16 : 17);
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.isEmpty()) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (tokenId == 4) {
                        this.state = (byte)10;
                        break;
                    }
                    if (tokenId == 3) {
                        this.state = (byte)11;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 12: 
                case 13: {
                    if (tokenId == 4 && this.state == 12 || tokenId == 3 && this.state == 13) {
                        if (isEmpty || tokenText.charAt(0) != this.getQuoteCharBasedOnState()) {
                            this.lastIntRanges = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                            if (this.lastIntRanges == null) {
                                this.state = (byte)4;
                                break;
                            }
                            if (!XPathActivationRule.lastParenthesisDoesNotClose(this.lastIntRanges, originalTokenText)) break;
                            this.state = (byte)(this.state == 12 ? 14 : 15);
                            break;
                        }
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    if (tokenId == 7) {
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 14: 
                case 15: {
                    pushback = this.handleActiveOpenParenthesisState(tokenId, Map.of((byte)4, (byte)14, (byte)3, (byte)15), tokenText, originalTokenText, Map.of((byte)14, (byte)12, (byte)15, (byte)13), (byte)4);
                    break;
                }
                case 7: 
                case 8: {
                    pushback = this.handleActiveOpenParenthesisState(tokenId, Map.of((byte)4, (byte)7, (byte)3, (byte)8), tokenText, originalTokenText, Map.of((byte)7, (byte)10, (byte)8, (byte)11), (byte)1);
                    break;
                }
                case 10: 
                case 11: {
                    if (tokenId == 4 && this.state == 10 || tokenId == 3 && this.state == 11) {
                        if (isEmpty || tokenText.charAt(0) != this.getQuoteCharBasedOnState()) break;
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                case 16: 
                case 17: {
                    if (tokenId == 4 && this.state == 16 || tokenId == 3 && this.state == 17) {
                        if (isEmpty || tokenText.charAt(0) != XPathActivationRule.getAttributeValueQuoteChar(tokenId)) break;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = (byte)4;
                    break;
                }
                default: {
                    logger.error("Illegal state.");
                }
            }
            logger.debug("\t\t\t\t\t==> {}", (Object)this.state);
        } while (pushback);
    }

    private void updateParenthesisRangeAndCorrespondingState(byte attrValueQuoteTokenID, String originalTokenText, Map<Byte, byte[]> attrValueQuoteTokenToParanthesisBasedStateMap) {
        this.lastIntRanges = XPathActivationRule.getParenthesisRange(originalTokenText, false);
        if (this.lastIntRanges != null) {
            byte[] states = attrValueQuoteTokenToParanthesisBasedStateMap.get(attrValueQuoteTokenID);
            this.state = XPathActivationRule.lastParenthesisDoesNotClose(this.lastIntRanges, originalTokenText) ? states[0] : states[1];
        }
    }

    private boolean handleActiveOpenParenthesisState(byte attrValueQuoteTokenID, Map<Byte, Byte> quoteTokenIDToActiveOpenParentesisStateMap, String trimmedTokenText, String originalTokenText, Map<Byte, Byte> activeOpenParanthesisStateToActiveQuoteState, byte openTagStateForAttrNameTokenID) {
        boolean pushback = false;
        if (XPathActivationRule.isAttributeValueQuote(attrValueQuoteTokenID) && this.state == quoteTokenIDToActiveOpenParentesisStateMap.get(attrValueQuoteTokenID)) {
            if (trimmedTokenText.isEmpty() || trimmedTokenText.charAt(0) != this.getQuoteCharBasedOnState()) {
                this.lastIntRanges = XPathActivationRule.getParenthesisRange(originalTokenText, true);
                if (this.lastIntRanges == null) {
                    logger.error("This should not happen. There should be at least a range because it was an open parenthesis in the token before.");
                } else if (!XPathActivationRule.lastParenthesisDoesNotClose(this.lastIntRanges, originalTokenText)) {
                    this.state = activeOpenParanthesisStateToActiveQuoteState.get(this.state);
                }
            } else {
                pushback = true;
                this.state = openTagStateForAttrNameTokenID;
            }
        } else if (attrValueQuoteTokenID == 7) {
            pushback = true;
            this.state = openTagStateForAttrNameTokenID;
        } else {
            pushback = true;
            this.state = 0;
        }
        return pushback;
    }

    private char getQuoteCharBasedOnState() {
        return (char)(this.state == 10 || this.state == 12 || this.state == 7 || this.state == 14 ? 39 : 34);
    }

    private static int[][] getAllValueRanges(byte tokenId, String originalTokenText) {
        int start = 1;
        int end = -1;
        int l = originalTokenText.length();
        end = originalTokenText.charAt(l - 1) == XPathActivationRule.getAttributeValueQuoteChar(tokenId) ? l - 1 : l;
        return new int[][]{{start, end}};
    }

    private static boolean lastParenthesisDoesNotClose(int[][] ranges, String originalTokenText) {
        boolean isNotClosed;
        boolean bl = isNotClosed = ranges[ranges.length - 1][1] < 0;
        if (logger.isDebugEnabled()) {
            logger.debug("The parenthesis are not closed for: '{}' = {}", (Object)originalTokenText, (Object)isNotClosed);
            logger.debug("Ranges are: '{}", (Object)XPathActivationRule.dumpRangesArray(ranges));
        }
        return isNotClosed;
    }

    private static String dumpRangesArray(int[][] ranges) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            builder.append(Arrays.toString(ranges[i])).append(',');
        }
        return builder.toString();
    }

    private static int[][] getParenthesisRange(String text, boolean alreadyOpenParenthesis) {
        logger.debug("Find all ranges in |{}|", (Object)text);
        int s = 0;
        int rangeBegin = alreadyOpenParenthesis ? 0 : -1;
        int rangeEnd = -1;
        int[][] ranges = null;
        int rangesCurrentIndex = 0;
        int len = text.length();
        while (true) {
            for (int i = s; i < len; ++i) {
                int nch;
                char ch = text.charAt(i);
                int n = nch = i < len - 1 ? (int)text.charAt(i + 1) : -1;
                if (ch == '{' && nch == 123 || ch == '}' && nch == 125) {
                    ++i;
                } else if (rangeBegin == -1) {
                    if (ch == '{') {
                        rangeBegin = i + 1;
                    }
                } else if (ch == '}') {
                    rangeEnd = i;
                }
                if (rangeBegin != -1 && rangeEnd != -1) break;
            }
            int n = s = rangeEnd == -1 ? len : rangeEnd + 1;
            if (rangeBegin == -1) break;
            if (ranges == null) {
                ranges = new int[1][];
                rangesCurrentIndex = 0;
            }
            if (rangesCurrentIndex == ranges.length) {
                int[][] nr = new int[rangesCurrentIndex + 1][];
                System.arraycopy(ranges, 0, nr, 0, ranges.length);
                ranges = nr;
            }
            ranges[rangesCurrentIndex] = new int[]{rangeBegin, rangeEnd};
            ++rangesCurrentIndex;
            rangeBegin = -1;
            rangeEnd = -1;
        }
        return ranges;
    }

    @Override
    public int getActivationState() {
        return Arrays.binarySearch(ACTIVATION_STATES, (int)this.state) >= 0 ? -1 : -2;
    }

    @Override
    public boolean useSavedLexicalState() {
        return this.state != 12 && this.state != 13 || this.lastIntRanges == null || this.lastIntRanges.length < 2;
    }

    @Override
    public ActivationRange[] getRanges() {
        ActivationRange[] ranges = null;
        if (XPathActivationRule.isAttributeValueQuote(this.lastUpdatedTokenId)) {
            int len = this.lastUpdatedOriginalTokenText.length();
            if (this.isActiveState()) {
                logger.debug("LPR {}", new Supplier[]{() -> Arrays.toString((Object[])this.lastIntRanges)});
                if (this.lastIntRanges != null) {
                    ranges = this.getParenthesisRanges();
                }
            }
            if (ranges == null && (this.state == 10 || this.state == 11 || this.state == 16 || this.state == 17)) {
                int beginIndex;
                char ch = this.state == 10 || this.state == 16 ? (char)'\'' : '\"';
                int n = beginIndex = ch == this.lastUpdatedOriginalTokenText.charAt(0) ? 1 : 0;
                int endIndex = len <= 1 ? beginIndex : (ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len);
                if (endIndex >= beginIndex) {
                    ranges = new ActivationRange[]{new ActivationRange(beginIndex, endIndex)};
                }
            }
        }
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        ActivationRange[] rangesLog = ranges;
        logger.debug(() -> "Created ranges " + Arrays.toString(rangesLog));
        return ranges;
    }

    private boolean isActiveState() {
        return this.state == 12 || this.state == 13 || this.state == 10 || this.state == 11 || this.state == 7 || this.state == 8 || this.state == 14 || this.state == 15;
    }

    private ActivationRange[] getParenthesisRanges() {
        int rc = this.lastIntRanges.length;
        ArrayList<ActivationRange> tmp = new ArrayList<ActivationRange>(rc);
        int len = this.lastUpdatedOriginalTokenText.length();
        for (int i = 0; i < rc; ++i) {
            int beginIndex = this.lastIntRanges[i][0];
            int endIndex = this.lastIntRanges[i][1];
            if (endIndex == -1) {
                char ch = this.state == 12 || this.state == 14 ? (char)'\'' : '\"';
                int n = endIndex = ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len;
            }
            if (endIndex < beginIndex) continue;
            tmp.add(new ActivationRange(beginIndex, endIndex));
        }
        return tmp.toArray(ERA);
    }

    static {
        Arrays.sort(ACTIVATION_STATES);
        ERA = new ActivationRange[0];
    }
}

