/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.Schema;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;

public class NumberGenerator {
    private JsonGeneratorEngine generator;
    private final boolean isRandom;
    private final boolean isDefault;
    private final boolean isNone;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;

    public NumberGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
        this.isRandom = this.generator.getOptions().getPropValuesGeneration().equals("Random");
        this.isDefault = this.generator.getOptions().getPropValuesGeneration().equals("Default");
        this.isNone = this.generator.getOptions().getPropValuesGeneration().equals("None");
    }

    String generateFromNumberSchema(NumberSchema numberSchema) {
        ArrayList<Schema> schemaAsArray = new ArrayList<Schema>();
        schemaAsArray.add((Schema)numberSchema);
        return String.valueOf(this.generateFromNumberSchemas(schemaAsArray));
    }

    Number generateFromNumberSchemas(List<Schema> numberSchemas) {
        Number multipleOf;
        int isExMaximum;
        Number maximum;
        if (this.isNone) {
            return 0;
        }
        NumberSchema firstSchema = (NumberSchema)numberSchemas.get(0);
        Object defaultValue = firstSchema.getUnprocessedProperties().getOrDefault("default", null);
        ArrayList examples = firstSchema.getUnprocessedProperties().getOrDefault("examples", null);
        Integer minIntValue = null;
        Integer maxIntValue = null;
        Number minimum = firstSchema.getExclusiveMinimumLimit() != null ? (Number)firstSchema.getExclusiveMinimumLimit() : (Number)firstSchema.getMinimum();
        Number number = maximum = firstSchema.getExclusiveMaximumLimit() != null ? (Number)firstSchema.getExclusiveMaximumLimit() : (Number)firstSchema.getMaximum();
        if (minimum == null && maximum == null) {
            minIntValue = 0;
        }
        int isExMinimum = firstSchema.isExclusiveMinimum() ? 1 : 0;
        int n = isExMaximum = firstSchema.isExclusiveMaximum() ? 1 : 0;
        if (firstSchema.getExclusiveMinimumLimit() != null) {
            minIntValue = firstSchema.getExclusiveMinimumLimit().intValue() + 1;
        } else if (firstSchema.getMinimum() != null) {
            minIntValue = firstSchema.getMinimum().intValue() + isExMinimum;
        }
        maxIntValue = firstSchema.getExclusiveMaximumLimit() != null ? Integer.valueOf(firstSchema.getExclusiveMaximumLimit().intValue() - 1) : (firstSchema.getMaximum() != null ? Integer.valueOf(firstSchema.getMaximum().intValue() - isExMaximum) : Integer.valueOf(minIntValue + 100));
        Number number2 = multipleOf = firstSchema.getMultipleOf() != null ? (Number)firstSchema.getMultipleOf() : (Number)1;
        if (numberSchemas.size() > 1) {
            for (int i = 1; i < numberSchemas.size(); ++i) {
                NumberSchema numberSchema = (NumberSchema)numberSchemas.get(i);
                defaultValue = numberSchema.getUnprocessedProperties().getOrDefault("default", null);
                examples = numberSchema.getUnprocessedProperties().getOrDefault("examples", null);
                Number localExMinimum = numberSchema.getExclusiveMinimumLimit();
                Number localExMaximum = numberSchema.getExclusiveMaximumLimit();
                Number localMinimum = numberSchema.getMinimum();
                Number localMaximum = numberSchema.getMaximum();
                if (localExMinimum != null && localExMinimum.intValue() > minIntValue) {
                    minIntValue = localExMinimum.intValue() + 1;
                } else if (localMinimum != null && localMinimum.intValue() > minIntValue) {
                    isExMinimum = numberSchema.isExclusiveMinimum() ? 1 : 0;
                    minIntValue = localMinimum.intValue() + isExMinimum;
                }
                if (localExMaximum != null && localExMaximum.intValue() < maxIntValue) {
                    maxIntValue = localExMaximum.intValue() - 1;
                } else if (localMaximum != null && localMaximum.intValue() < maxIntValue) {
                    isExMaximum = numberSchema.isExclusiveMaximum() ? 1 : 0;
                    maxIntValue = localMaximum.intValue() - isExMaximum;
                }
                if (numberSchema.getMultipleOf() == null) continue;
                multipleOf = numberSchema.getMultipleOf().intValue();
            }
        }
        return this.generateNumber(minIntValue, maxIntValue, multipleOf.doubleValue(), defaultValue, examples);
    }

    private Number generateNumber(Integer minIntValue, Integer maxIntValue, double multipleOf, Object defaultValue, ArrayList<?> examples) {
        if (minIntValue == null && (minIntValue = Integer.valueOf(0)) > maxIntValue) {
            minIntValue = maxIntValue - 100;
        }
        double numberToGenerate = minIntValue.intValue();
        if (this.isDefault && (defaultValue != null || examples != null)) {
            if (defaultValue != null) {
                numberToGenerate = Double.parseDouble(defaultValue.toString());
            } else if (!examples.isEmpty()) {
                numberToGenerate = Double.parseDouble(examples.get(0).toString());
            }
        } else if (this.isRandom) {
            while (numberToGenerate < (double)maxIntValue.intValue()) {
                int random = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt((int)((double)maxIntValue.intValue() / multipleOf) + 1) + (multipleOf == 1.0 ? 0 : 1);
                numberToGenerate = BigDecimal.valueOf(multipleOf).multiply(new BigDecimal(random)).doubleValue();
                if (!(numberToGenerate >= (double)minIntValue.intValue())) continue;
                break;
            }
        } else if (multipleOf != 1.0) {
            while (numberToGenerate <= (double)maxIntValue.intValue() && !((numberToGenerate += multipleOf) >= (double)minIntValue.intValue())) {
            }
        }
        if (numberToGenerate == Math.floor(numberToGenerate)) {
            return (int)numberToGenerate;
        }
        return numberToGenerate;
    }
}

