/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedPatternFuture;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.relaxng.pattern.AnnotationsImpl;
import com.thaiopensource.relaxng.pattern.AnyNameClass;
import com.thaiopensource.relaxng.pattern.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.pattern.AttributeNameClassChecker;
import com.thaiopensource.relaxng.pattern.BuiltinDatatypeLibraryFactory;
import com.thaiopensource.relaxng.pattern.ChoiceNameClass;
import com.thaiopensource.relaxng.pattern.CommentListImpl;
import com.thaiopensource.relaxng.pattern.ErrorNameClass;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameFormatter;
import com.thaiopensource.relaxng.pattern.NsNameClass;
import com.thaiopensource.relaxng.pattern.NsNameExceptNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFuture;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SchemaBuilderImpl
extends AnnotationsImpl
implements ElementAnnotationBuilder<Locator, VoidValue, CommentListImpl>,
SchemaBuilder<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
    private final SchemaBuilderImpl parent;
    private boolean hadError = false;
    private final SubParser<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParser;
    private final SchemaPatternBuilder pb;
    private final DatatypeLibraryFactory datatypeLibraryFactory;
    private final String inheritNs;
    private final ErrorHandler eh;
    private final OpenIncludes openIncludes;
    private final AttributeNameClassChecker attributeNameClassChecker = new AttributeNameClassChecker();
    static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    public static Pattern parse(Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parseable, ErrorHandler eh, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder pb, boolean isAttributesPattern) throws IllegalSchemaException, IOException, SAXException {
        try {
            SchemaBuilderImpl sb = new SchemaBuilderImpl(parseable, eh, new BuiltinDatatypeLibraryFactory(datatypeLibraryFactory), pb);
            Pattern pattern = parseable.parse(sb, new RootScope(sb));
            if (isAttributesPattern) {
                pattern = sb.wrapAttributesPattern(pattern);
            }
            return sb.expandPattern(pattern);
        }
        catch (BuildException e) {
            throw SchemaBuilderImpl.unwrapBuildException(e);
        }
    }

    public static PatternFuture installHandlers(ParseReceiver<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parser, XMLReader xr, ErrorHandler eh, DatatypeLibraryFactory dlf, SchemaPatternBuilder pb) throws SAXException {
        final SchemaBuilderImpl sb = new SchemaBuilderImpl(parser, eh, new BuiltinDatatypeLibraryFactory(dlf), pb);
        final ParsedPatternFuture<Pattern> pf = parser.installHandlers(xr, sb, new RootScope(sb));
        return new PatternFuture(){

            @java.lang.Override
            public Pattern getPattern(boolean isAttributesPattern) throws IllegalSchemaException, SAXException, IOException {
                try {
                    Pattern pattern = (Pattern)pf.getParsedPattern();
                    if (isAttributesPattern) {
                        pattern = sb.wrapAttributesPattern(pattern);
                    }
                    return sb.expandPattern(pattern);
                }
                catch (BuildException e) {
                    throw SchemaBuilderImpl.unwrapBuildException(e);
                }
            }
        };
    }

    public static RuntimeException unwrapBuildException(BuildException e) throws SAXException, IllegalSchemaException, IOException {
        Throwable t = e.getCause();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof IllegalSchemaException) {
            throw new IllegalSchemaException();
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof Exception) {
            throw new SAXException((Exception)t);
        }
        throw new SAXException(t.getClass().getName() + " thrown");
    }

    private Pattern wrapAttributesPattern(Pattern pattern) {
        return this.makeElement(this.makeAnyName(null, null), pattern, null, null);
    }

    private Pattern expandPattern(Pattern pattern) throws IllegalSchemaException, BuildException {
        if (!this.hadError) {
            try {
                pattern.checkRecursion(0);
                pattern = pattern.expand(this.pb);
                pattern.checkRestrictions(0, null, null);
                if (!this.hadError) {
                    return pattern;
                }
            }
            catch (SAXParseException e) {
                this.error(e);
            }
            catch (SAXException e) {
                throw new BuildException(e);
            }
            catch (RestrictionViolationException e) {
                if (e.getName() != null) {
                    this.error(e.getMessageId(), NameFormatter.format(e.getName()), e.getLocator());
                }
                if (e.getNamespaceUri() != null) {
                    this.error(e.getMessageId(), e.getNamespaceUri(), e.getLocator());
                }
                this.error(e.getMessageId(), e.getLocator());
            }
        }
        throw new IllegalSchemaException();
    }

    private SchemaBuilderImpl(SubParser<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParser, ErrorHandler eh, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder pb) {
        this.parent = null;
        this.subParser = subParser;
        this.eh = eh;
        this.datatypeLibraryFactory = datatypeLibraryFactory;
        this.pb = pb;
        this.inheritNs = "";
        this.openIncludes = null;
    }

    private SchemaBuilderImpl(String inheritNs, String uri, SchemaBuilderImpl parent) {
        this.parent = parent;
        this.subParser = parent.subParser;
        this.eh = parent.eh;
        this.datatypeLibraryFactory = parent.datatypeLibraryFactory;
        this.pb = parent.pb;
        this.inheritNs = parent.resolveInherit(inheritNs);
        this.openIncludes = new OpenIncludes(uri, parent.openIncludes);
    }

    @java.lang.Override
    public Pattern makeChoice(List<Pattern> patterns, Locator loc, AnnotationsImpl anno) throws BuildException {
        int nPatterns = patterns.size();
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = patterns.get(0);
        for (int i = 1; i < nPatterns; ++i) {
            result = this.pb.makeChoice(result, patterns.get(i));
        }
        return result;
    }

    @java.lang.Override
    public Pattern makeInterleave(List<Pattern> patterns, Locator loc, AnnotationsImpl anno) throws BuildException {
        int nPatterns = patterns.size();
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = patterns.get(0);
        for (int i = 1; i < nPatterns; ++i) {
            result = this.pb.makeInterleave(result, patterns.get(i));
        }
        return result;
    }

    @java.lang.Override
    public Pattern makeGroup(List<Pattern> patterns, Locator loc, AnnotationsImpl anno) throws BuildException {
        int nPatterns = patterns.size();
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = patterns.get(0);
        for (int i = 1; i < nPatterns; ++i) {
            result = this.pb.makeGroup(result, patterns.get(i));
        }
        return result;
    }

    @java.lang.Override
    public Pattern makeOneOrMore(Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeOneOrMore(p);
    }

    @java.lang.Override
    public Pattern makeZeroOrMore(Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeZeroOrMore(p);
    }

    @java.lang.Override
    public Pattern makeOptional(Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeOptional(p);
    }

    @java.lang.Override
    public Pattern makeList(Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeList(p, loc);
    }

    @java.lang.Override
    public Pattern makeMixed(Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeMixed(p);
    }

    @java.lang.Override
    public Pattern makeEmpty(Locator loc, AnnotationsImpl anno) {
        return this.pb.makeEmpty();
    }

    @java.lang.Override
    public Pattern makeNotAllowed(Locator loc, AnnotationsImpl anno) {
        return this.pb.makeUnexpandedNotAllowed();
    }

    @java.lang.Override
    public Pattern makeText(Locator loc, AnnotationsImpl anno) {
        return this.pb.makeText();
    }

    @java.lang.Override
    public Pattern makeErrorPattern() {
        return this.pb.makeError();
    }

    @java.lang.Override
    public NameClass makeErrorNameClass() {
        return new ErrorNameClass();
    }

    @java.lang.Override
    public Pattern makeAttribute(NameClass nc, Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        String messageId = this.attributeNameClassChecker.checkNameClass(nc);
        if (messageId != null) {
            this.error(messageId, loc);
        }
        return this.pb.makeAttribute(nc, p, loc, anno != null ? anno.defaultValue : null);
    }

    @java.lang.Override
    public Pattern makeElement(NameClass nc, Pattern p, Locator loc, AnnotationsImpl anno) throws BuildException {
        return this.pb.makeElement(nc, p, loc);
    }

    @java.lang.Override
    public DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDataPatternBuilder(String datatypeLibrary, String type, Locator loc) throws BuildException {
        DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
        if (dl == null) {
            this.error("unrecognized_datatype_library", datatypeLibrary, loc);
        } else {
            try {
                return new DataPatternBuilderImpl(dl.createDatatypeBuilder(type), new Name(datatypeLibrary, type));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    this.error("unsupported_datatype_detail", datatypeLibrary, type, detail, loc);
                }
                this.error("unrecognized_datatype", datatypeLibrary, type, loc);
            }
        }
        return new DummyDataPatternBuilder();
    }

    @java.lang.Override
    public Pattern makeValue(String datatypeLibrary, String type, String value, Context context, String ns, Locator loc, AnnotationsImpl anno) throws BuildException {
        block8: {
            DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
            if (dl == null) {
                this.error("unrecognized_datatype_library", datatypeLibrary, loc);
            } else {
                try {
                    DatatypeBuilder dtb = dl.createDatatypeBuilder(type);
                    try {
                        Datatype dt = dtb.createDatatype();
                        Object obj = dt.createValue(value, new ValidationContextImpl(context, ns));
                        if (obj != null) {
                            return this.pb.makeValue(dt, new Name(datatypeLibrary, type), obj, value);
                        }
                        this.error("invalid_value", value, loc);
                    }
                    catch (DatatypeException e) {
                        String detail = e.getMessage();
                        if (detail != null) {
                            this.error("datatype_requires_param_detail", detail, loc);
                            break block8;
                        }
                        this.error("datatype_requires_param", loc);
                    }
                }
                catch (DatatypeException e) {
                    this.error("unrecognized_datatype", datatypeLibrary, type, loc);
                }
            }
        }
        return this.pb.makeError();
    }

    @java.lang.Override
    public Grammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeGrammar(Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parent) {
        return new GrammarImpl(this, parent);
    }

    @java.lang.Override
    public Pattern makeExternalRef(String href, String base, String ns, Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> scope, Locator loc, AnnotationsImpl anno) throws BuildException {
        SubParseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParseable = this.subParser.createSubParseable(href, base);
        String uri = subParseable.getUri();
        OpenIncludes inc = this.openIncludes;
        while (inc != null) {
            if (inc.uri.equals(uri)) {
                this.error("recursive_include", uri, loc);
                return this.pb.makeError();
            }
            inc = inc.parent;
        }
        try {
            return subParseable.parse(new SchemaBuilderImpl(ns, uri, this), scope);
        }
        catch (IllegalSchemaException e) {
            this.noteError();
            return this.pb.makeError();
        }
    }

    @java.lang.Override
    public NameClass makeNameClassChoice(List<NameClass> nameClasses, Locator loc, AnnotationsImpl anno) {
        int nNameClasses = nameClasses.size();
        if (nNameClasses <= 0) {
            throw new IllegalArgumentException();
        }
        NameClass result = nameClasses.get(0);
        for (int i = 1; i < nNameClasses; ++i) {
            result = new ChoiceNameClass(result, nameClasses.get(i));
        }
        return result;
    }

    @java.lang.Override
    public NameClass makeName(String ns, String localName, String prefix, Locator loc, AnnotationsImpl anno) {
        return new SimpleNameClass(new Name(this.resolveInherit(ns), localName));
    }

    @java.lang.Override
    public NameClass makeNsName(String ns, Locator loc, AnnotationsImpl anno) {
        return new NsNameClass(this.resolveInherit(ns));
    }

    @java.lang.Override
    public NameClass makeNsName(String ns, NameClass except, Locator loc, AnnotationsImpl anno) {
        return new NsNameExceptNameClass(this.resolveInherit(ns), except);
    }

    @java.lang.Override
    public NameClass makeAnyName(Locator loc, AnnotationsImpl anno) {
        return new AnyNameClass();
    }

    @java.lang.Override
    public NameClass makeAnyName(NameClass except, Locator loc, AnnotationsImpl anno) {
        return new AnyNameExceptNameClass(except);
    }

    @java.lang.Override
    public AnnotationsImpl makeAnnotations(CommentListImpl comments, Context context) {
        return new AnnotationsImpl();
    }

    @java.lang.Override
    public VoidValue makeElementAnnotation() throws BuildException {
        return VoidValue.VOID;
    }

    @java.lang.Override
    public void addText(String value, Locator loc, CommentListImpl comments) throws BuildException {
    }

    @java.lang.Override
    public ElementAnnotationBuilder<Locator, VoidValue, CommentListImpl> makeElementAnnotationBuilder(String ns, String localName, String prefix, Locator loc, CommentListImpl comments, Context context) {
        return this;
    }

    @java.lang.Override
    public CommentListImpl makeCommentList() {
        return this;
    }

    @java.lang.Override
    public boolean usesComments() {
        return false;
    }

    @java.lang.Override
    public Pattern annotatePattern(Pattern p, AnnotationsImpl anno) throws BuildException {
        return p;
    }

    @java.lang.Override
    public NameClass annotateNameClass(NameClass nc, AnnotationsImpl anno) throws BuildException {
        return nc;
    }

    @java.lang.Override
    public Pattern annotateAfterPattern(Pattern p, VoidValue e) throws BuildException {
        return p;
    }

    @java.lang.Override
    public NameClass annotateAfterNameClass(NameClass nc, VoidValue e) throws BuildException {
        return nc;
    }

    @java.lang.Override
    public Pattern commentAfterPattern(Pattern p, CommentListImpl comments) throws BuildException {
        return p;
    }

    @java.lang.Override
    public NameClass commentAfterNameClass(NameClass nc, CommentListImpl comments) throws BuildException {
        return nc;
    }

    private String resolveInherit(String ns) {
        if (ns == INHERIT_NS) {
            return this.inheritNs;
        }
        return ns;
    }

    @java.lang.Override
    public Locator makeLocation(String systemId, int lineNumber, int columnNumber) {
        return new LocatorImpl(systemId, lineNumber, columnNumber);
    }

    private void error(SAXParseException message) throws BuildException {
        this.noteError();
        try {
            if (this.eh != null) {
                this.eh.error(message);
            }
        }
        catch (SAXException e) {
            throw new BuildException(e);
        }
    }

    private void error(String key, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key), loc));
    }

    private void error(String key, String arg, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, arg), loc));
    }

    private void error(String key, String arg1, String arg2, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, arg1, arg2), loc));
    }

    private void error(String key, String arg1, String arg2, String arg3, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, new Object[]{arg1, arg2, arg3}), loc));
    }

    private void noteError() {
        if (!this.hadError && this.parent != null) {
            this.parent.noteError();
        }
        this.hadError = true;
    }

    static class RootScope
    implements Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;

        RootScope(SchemaBuilderImpl sb) {
            this.sb = sb;
        }

        @java.lang.Override
        public Pattern makeParentRef(String name, Locator loc, AnnotationsImpl anno) throws BuildException {
            this.sb.error("parent_ref_outside_grammar", loc);
            return this.sb.makeErrorPattern();
        }

        @java.lang.Override
        public Pattern makeRef(String name, Locator loc, AnnotationsImpl anno) throws BuildException {
            this.sb.error("ref_outside_grammar", loc);
            return this.sb.makeErrorPattern();
        }
    }

    static class OpenIncludes {
        final String uri;
        final OpenIncludes parent;

        OpenIncludes(String uri, OpenIncludes parent) {
            this.uri = uri;
            this.parent = parent;
        }
    }

    private class DataPatternBuilderImpl
    implements DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final DatatypeBuilder dtb;
        private final Name dtName;
        private final List<String> params = new ArrayList<String>();

        DataPatternBuilderImpl(DatatypeBuilder dtb, Name dtName) {
            this.dtb = dtb;
            this.dtName = dtName;
        }

        @java.lang.Override
        public void addParam(String name, String value, Context context, String ns, Locator loc, AnnotationsImpl anno) throws BuildException {
            try {
                this.dtb.addParameter(name, value, new ValidationContextImpl(context, ns));
                this.params.add(name);
                this.params.add(value);
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                int pos = e.getIndex();
                String displayedParam = pos == -1 ? null : this.displayParam(value, pos);
                if (displayedParam != null) {
                    if (detail != null) {
                        SchemaBuilderImpl.this.error("invalid_param_detail_display", detail, displayedParam, loc);
                    } else {
                        SchemaBuilderImpl.this.error("invalid_param_display", displayedParam, loc);
                    }
                }
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_param_detail", detail, loc);
                }
                SchemaBuilderImpl.this.error("invalid_param", loc);
            }
        }

        @java.lang.Override
        public void annotation(VoidValue ea) throws BuildException {
        }

        String displayParam(String value, int pos) {
            if (pos < 0) {
                pos = 0;
            } else if (pos > value.length()) {
                pos = value.length();
            }
            return localizer.message("display_param", value.substring(0, pos), value.substring(pos));
        }

        @java.lang.Override
        public Pattern makePattern(Locator loc, AnnotationsImpl anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeData(this.dtb.createDatatype(), this.dtName, this.params);
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, loc);
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", loc);
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }

        @java.lang.Override
        public Pattern makePattern(Pattern except, Locator loc, AnnotationsImpl anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeDataExcept(this.dtb.createDatatype(), this.dtName, this.params, except, loc);
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, loc);
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", loc);
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }
    }

    private class DummyDataPatternBuilder
    implements DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private DummyDataPatternBuilder() {
        }

        @java.lang.Override
        public void addParam(String name, String value, Context context, String ns, Locator loc, AnnotationsImpl anno) throws BuildException {
        }

        @java.lang.Override
        public void annotation(VoidValue ea) throws BuildException {
        }

        @java.lang.Override
        public Pattern makePattern(Locator loc, AnnotationsImpl anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }

        @java.lang.Override
        public Pattern makePattern(Pattern except, Locator loc, AnnotationsImpl anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }
    }

    private class ValidationContextImpl
    implements ValidationContext {
        private final ValidationContext vc;
        private final String ns;

        ValidationContextImpl(ValidationContext vc, String ns) {
            this.vc = vc;
            this.ns = ns.length() == 0 ? null : ns;
        }

        @java.lang.Override
        public String resolveNamespacePrefix(String prefix) {
            String result;
            String string = result = prefix.length() == 0 ? this.ns : this.vc.resolveNamespacePrefix(prefix);
            if (result == SchemaBuilder.INHERIT_NS) {
                if (SchemaBuilderImpl.this.inheritNs.length() == 0) {
                    return null;
                }
                return SchemaBuilderImpl.this.inheritNs;
            }
            return result;
        }

        @java.lang.Override
        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        @java.lang.Override
        public boolean isUnparsedEntity(String entityName) {
            return this.vc.isUnparsedEntity(entityName);
        }

        @java.lang.Override
        public boolean isNotation(String notationName) {
            return this.vc.isNotation(notationName);
        }
    }

    static class GrammarImpl
    implements Grammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    IncludedGrammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;
        private final Map<String, RefPattern> defines;
        private final RefPattern startRef;
        private final Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parent;

        private GrammarImpl(SchemaBuilderImpl sb, Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parent) {
            this.sb = sb;
            this.parent = parent;
            this.defines = new HashMap<String, RefPattern>();
            this.startRef = new RefPattern(null);
        }

        protected GrammarImpl(SchemaBuilderImpl sb, GrammarImpl g) {
            this.sb = sb;
            this.parent = g.parent;
            this.startRef = g.startRef;
            this.defines = g.defines;
        }

        @java.lang.Override
        public Pattern endGrammar(Locator loc, AnnotationsImpl anno) throws BuildException {
            for (String name : this.defines.keySet()) {
                RefPattern rp = this.defines.get(name);
                if (rp.getPattern() != null) continue;
                this.sb.error("reference_to_undefined", name, rp.getRefLocator());
                rp.setPattern(this.sb.pb.makeError());
            }
            Pattern start = this.startRef.getPattern();
            if (start == null) {
                this.sb.error("missing_start_element", loc);
                start = this.sb.pb.makeError();
            }
            return start;
        }

        @java.lang.Override
        public void endDiv(Locator loc, AnnotationsImpl anno) throws BuildException {
        }

        @java.lang.Override
        public Pattern endIncludedGrammar(Locator loc, AnnotationsImpl anno) throws BuildException {
            return null;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, Pattern pattern, Locator loc, AnnotationsImpl anno) throws BuildException {
            this.define(this.lookup(name), combine, pattern, loc);
        }

        private void define(RefPattern rp, GrammarSection.Combine combine, Pattern pattern, Locator loc) throws BuildException {
            switch (rp.getReplacementStatus()) {
                case 0: {
                    if (combine == null) {
                        if (rp.isCombineImplicit()) {
                            if (rp.getName() == null) {
                                this.sb.error("duplicate_start", loc);
                            } else {
                                this.sb.error("duplicate_define", rp.getName(), loc);
                            }
                        } else {
                            rp.setCombineImplicit();
                        }
                    } else {
                        byte combineType;
                        byte by = combineType = combine == COMBINE_CHOICE ? (byte)1 : 2;
                        if (rp.getCombineType() != 0 && rp.getCombineType() != combineType) {
                            if (rp.getName() == null) {
                                this.sb.error("conflict_combine_start", loc);
                            } else {
                                this.sb.error("conflict_combine_define", rp.getName(), loc);
                            }
                        }
                        rp.setCombineType(combineType);
                    }
                    if (rp.getPattern() == null) {
                        rp.setPattern(pattern);
                        break;
                    }
                    if (rp.getCombineType() == 2) {
                        rp.setPattern(this.sb.pb.makeInterleave(rp.getPattern(), pattern));
                        break;
                    }
                    rp.setPattern(this.sb.pb.makeChoice(rp.getPattern(), pattern));
                    break;
                }
                case 1: {
                    rp.setReplacementStatus((byte)2);
                    break;
                }
            }
        }

        @java.lang.Override
        public void topLevelAnnotation(VoidValue ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentListImpl comments) throws BuildException {
        }

        private RefPattern lookup(String name) {
            if (name == "#start") {
                return this.startRef;
            }
            return this.lookup1(name);
        }

        private RefPattern lookup1(String name) {
            RefPattern p = this.defines.get(name);
            if (p == null) {
                p = new RefPattern(name);
                this.defines.put(name, p);
            }
            return p;
        }

        @java.lang.Override
        public Pattern makeRef(String name, Locator loc, AnnotationsImpl anno) throws BuildException {
            RefPattern p = this.lookup1(name);
            if (p.getRefLocator() == null && loc != null) {
                p.setRefLocator(loc);
            }
            return p;
        }

        @java.lang.Override
        public Pattern makeParentRef(String name, Locator loc, AnnotationsImpl anno) throws BuildException {
            if (this.parent == null) {
                this.sb.error("parent_ref_outside_grammar", loc);
                return this.sb.makeErrorPattern();
            }
            return this.parent.makeRef(name, loc, anno);
        }

        @java.lang.Override
        public Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDiv() {
            return this;
        }

        @java.lang.Override
        public Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeInclude() {
            return new IncludeImpl(this.sb, this);
        }
    }

    private class LocatorImpl
    implements Locator {
        private final String systemId;
        private final int lineNumber;
        private final int columnNumber;

        private LocatorImpl(String systemId, int lineNumber, int columnNumber) {
            this.systemId = systemId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @java.lang.Override
        public String getPublicId() {
            return null;
        }

        @java.lang.Override
        public String getSystemId() {
            return this.systemId;
        }

        @java.lang.Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @java.lang.Override
        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    private static class IncludeImpl
    implements Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;
        private Override overrides;
        private final GrammarImpl grammar;

        private IncludeImpl(SchemaBuilderImpl sb, GrammarImpl grammar) {
            this.sb = sb;
            this.grammar = grammar;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, Pattern pattern, Locator loc, AnnotationsImpl anno) throws BuildException {
            RefPattern rp = this.grammar.lookup(name);
            this.overrides = new Override(rp, this.overrides);
            this.grammar.define(rp, combine, pattern, loc);
        }

        @java.lang.Override
        public void endDiv(Locator loc, AnnotationsImpl anno) throws BuildException {
        }

        @java.lang.Override
        public void topLevelAnnotation(VoidValue ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentListImpl comments) throws BuildException {
        }

        @java.lang.Override
        public Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDiv() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @java.lang.Override
        public void endInclude(String href, String base, String ns, Locator loc, AnnotationsImpl anno) throws BuildException {
            SubParseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParseable = this.sb.subParser.createSubParseable(href, base);
            String uri = subParseable.getUri();
            OpenIncludes inc = this.sb.openIncludes;
            while (inc != null) {
                if (inc.uri.equals(uri)) {
                    this.sb.error("recursive_include", uri, loc);
                    return;
                }
                inc = inc.parent;
            }
            Override o = this.overrides;
            while (o != null) {
                o.replacementStatus = o.prp.getReplacementStatus();
                o.prp.setReplacementStatus((byte)1);
                o = o.next;
            }
            try {
                SchemaBuilderImpl isb = new SchemaBuilderImpl(ns, uri, this.sb);
                subParseable.parseAsInclude(isb, new GrammarImpl(isb, this.grammar));
                Override o2 = this.overrides;
                while (o2 != null) {
                    if (o2.prp.getReplacementStatus() == 1) {
                        if (o2.prp.getName() == null) {
                            this.sb.error("missing_start_replacement", loc);
                        } else {
                            this.sb.error("missing_define_replacement", o2.prp.getName(), loc);
                        }
                    }
                    o2 = o2.next;
                }
                o = this.overrides;
            }
            catch (IllegalSchemaException e) {
                try {
                    this.sb.noteError();
                    o = this.overrides;
                }
                catch (Throwable throwable) {
                    Override o3 = this.overrides;
                    while (o3 != null) {
                        o3.prp.setReplacementStatus(o3.replacementStatus);
                        o3 = o3.next;
                    }
                    throw throwable;
                }
                while (o != null) {
                    o.prp.setReplacementStatus(o.replacementStatus);
                    o = o.next;
                }
            }
            while (o != null) {
                o.prp.setReplacementStatus(o.replacementStatus);
                o = o.next;
            }
        }

        @java.lang.Override
        public Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeInclude() {
            return null;
        }
    }

    static class Override {
        final RefPattern prp;
        final Override next;
        byte replacementStatus;

        Override(RefPattern prp, Override next) {
            this.prp = prp;
            this.next = next;
        }
    }
}

