/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternInterner;

public class PatternBuilder {
    private final EmptyPattern empty;
    protected final NotAllowedPattern notAllowed;
    protected final PatternInterner interner;

    public PatternBuilder() {
        this.empty = new EmptyPattern();
        this.notAllowed = new NotAllowedPattern();
        this.interner = new PatternInterner();
    }

    public PatternBuilder(PatternBuilder parent) {
        this.empty = parent.empty;
        this.notAllowed = parent.notAllowed;
        this.interner = new PatternInterner(parent.interner);
    }

    public Pattern makeEmpty() {
        return this.empty;
    }

    Pattern makeNotAllowed() {
        return this.notAllowed;
    }

    public Pattern makeGroup(Pattern p1, Pattern p2) {
        if (p1 == this.empty) {
            return p2;
        }
        if (p2 == this.empty) {
            return p1;
        }
        if (p1 == this.notAllowed || p2 == this.notAllowed) {
            return this.notAllowed;
        }
        GroupPattern p = new GroupPattern(p1, p2);
        return this.interner.intern(p);
    }

    public Pattern makeInterleave(Pattern p1, Pattern p2) {
        if (p1 == this.empty) {
            return p2;
        }
        if (p2 == this.empty) {
            return p1;
        }
        if (p1 == this.notAllowed || p2 == this.notAllowed) {
            return this.notAllowed;
        }
        InterleavePattern p = new InterleavePattern(p1, p2);
        return this.interner.intern(p);
    }

    public Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == this.empty && p2.isNullable()) {
            return p2;
        }
        if (p2 == this.empty && p1.isNullable()) {
            return p1;
        }
        ChoicePattern p = new ChoicePattern(p1, p2);
        return this.interner.intern(p);
    }

    public Pattern makeOneOrMore(Pattern p) {
        if (p == this.empty || p == this.notAllowed || p instanceof OneOrMorePattern) {
            return p;
        }
        OneOrMorePattern p1 = new OneOrMorePattern(p);
        return this.interner.intern(p1);
    }

    Pattern makeOptional(Pattern p) {
        return this.makeChoice(p, this.empty);
    }

    Pattern makeZeroOrMore(Pattern p) {
        return this.makeOptional(this.makeOneOrMore(p));
    }
}

