/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern p, Locator locator) {
        super(false, 3, ListPattern.combineHashCode(37, p.hashCode()));
        this.p = p;
        this.locator = locator;
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep = this.p.expand(b);
        if (ep != this.p) {
            return b.makeList(ep, this.locator);
        }
        return this;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth);
    }

    @Override
    boolean samePattern(Pattern other) {
        return other instanceof ListPattern && this.p == ((ListPattern)other).p;
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseList(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, dad, null);
        }
        catch (RestrictionViolationException e) {
            e.maybeSetLocator(this.locator);
            throw e;
        }
    }

    public Pattern getOperand() {
        return this.p;
    }
}

