/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class WeakHashSet<E>
extends HashSet {
    private ReferenceQueue queue = new ReferenceQueue();
    private boolean checkEqualsByReference = false;

    public WeakHashSet() {
        this(false);
    }

    public WeakHashSet(boolean checkEqualsByReference) {
        this.checkEqualsByReference = checkEqualsByReference;
    }

    @Override
    public Iterator<E> iterator() {
        this.processQueue();
        final Iterator i = super.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return WeakHashSet.this.getReferenceObject((WeakReference)i.next());
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(WeakElement.create(o, this.checkEqualsByReference));
    }

    @Override
    public boolean add(Object o) {
        this.processQueue();
        return super.add(WeakElement.create(o, this.queue, this.checkEqualsByReference));
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(WeakElement.create(o, this.checkEqualsByReference));
        this.processQueue();
        return ret;
    }

    @Override
    public int size() {
        this.processQueue();
        return super.size();
    }

    private final Object getReferenceObject(WeakReference ref) {
        return ref == null ? null : ref.get();
    }

    private final void processQueue() {
        WeakElement wv = null;
        while ((wv = (WeakElement)this.queue.poll()) != null) {
            super.remove(wv);
        }
    }

    private static class WeakElement
    extends WeakReference {
        private int hash;
        private boolean checkEqualsByReference;

        private WeakElement(Object o, boolean checkEqualsByReference) {
            super(o);
            this.checkEqualsByReference = checkEqualsByReference;
            this.hash = o.hashCode();
        }

        private WeakElement(Object o, ReferenceQueue q, boolean checkEqualsByReference) {
            super(o, q);
            this.checkEqualsByReference = checkEqualsByReference;
            this.hash = o.hashCode();
        }

        private static WeakElement create(Object o, boolean checkEqualsByReference) {
            return o == null ? null : new WeakElement(o, checkEqualsByReference);
        }

        private static WeakElement create(Object o, ReferenceQueue q, boolean checkEqualsByReference) {
            return o == null ? null : new WeakElement(o, q, checkEqualsByReference);
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((WeakElement)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return this.checkEqualsByReference ? t.equals(u) : false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

