/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SortedList<E>
extends ArrayList<E>
implements Serializable {
    public static final long serialVersionUID = 2751121163240L;
    private Comparator<? super E> comparator;

    public SortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public SortedList(Comparator<? super E> comparator, int initialSize) {
        super(initialSize);
        this.comparator = comparator;
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean add(E o) {
        return this.addWithSort(o) != -1;
    }

    public int addWithSort(E obj) {
        int addIndex = -1;
        if (this.comparator != null) {
            int binarySearch = Collections.binarySearch(this, obj, this.comparator);
            if (binarySearch < 0) {
                addIndex = -binarySearch - 1;
                super.add(addIndex, obj);
            } else {
                super.add(binarySearch, obj);
                addIndex = binarySearch;
            }
        } else {
            super.add(obj);
            addIndex = this.size();
        }
        return addIndex;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Deprecated
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int indexOf(Object o) {
        if (this.comparator != null) {
            return Collections.binarySearch(this, o, this.comparator);
        }
        return super.indexOf(o);
    }

    @Override
    public boolean remove(Object o) {
        if (this.comparator != null) {
            int index = Collections.binarySearch(this, o, this.comparator);
            if (index >= 0) {
                return super.remove(index) != null;
            }
            return false;
        }
        return super.remove(o);
    }
}

