/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml.imagemap;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.imagemap.ImageMapFormatException;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappImageMapSupport;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappImageMapSupportFactory;
import ro.sync.ecss.extensions.xhtml.imagemap.XHTMLWebappImageMapSupport;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLWebappImageMapSupportFactory
implements WebappImageMapSupportFactory {
    public String getDescription() {
        return "Image map support for XHTML";
    }

    public WebappImageMapSupport createImageMapSupport(AuthorInplaceContext context) throws ImageMapFormatException {
        AuthorElement image = context.getElem();
        AttrValue useMapAttr = image.getAttribute("usemap");
        String mapId = this.getMapId(useMapAttr);
        AuthorElement map = this.getMapElement(context, mapId);
        return new XHTMLWebappImageMapSupport(map);
    }

    private String getMapId(AttrValue useMapAttr) throws ImageMapFormatException {
        if (useMapAttr == null) {
            throw new ImageMapFormatException("Attribute usemap not present");
        }
        String mapHref = useMapAttr.getValue().trim();
        if (mapHref.isEmpty() || !mapHref.startsWith("#")) {
            throw new ImageMapFormatException("Image map href not valid: " + mapHref);
        }
        String mapId = mapHref.substring(1);
        return mapId;
    }

    private AuthorElement getMapElement(AuthorInplaceContext context, String mapId) throws ImageMapFormatException {
        AuthorElement map;
        try {
            AuthorDocumentController ctrl = context.getAuthorAccess().getDocumentController();
            AuthorNode[] maps = ctrl.findNodesByXPath("//*[@id='" + mapId + "']", true, true, true);
            if (maps.length == 0) {
                throw new ImageMapFormatException("Map not found: " + mapId);
            }
            map = (AuthorElement)maps[0];
        }
        catch (AuthorOperationException e) {
            throw new ImageMapFormatException("Map not found: " + mapId, (Exception)((Object)e));
        }
        return map;
    }
}

