/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.xhtml.InsertMediaOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLExternalObjectInsertionHandler
extends AuthorExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)XHTMLExternalObjectInsertionHandler.class.getName());

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, List<ReferenceType> types, int source) throws AuthorOperationException {
        if (!urls.isEmpty()) {
            URL base = XHTMLExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            int cp = authorAccess.getEditorAccess().getCaretOffset();
            for (int i = urls.size() - 1; i >= 0; --i) {
                Integer off;
                URL url = urls.get(i);
                ReferenceType type = types.get(i);
                String relativeLocation = authorAccess.getUtilAccess().makeRelative(base, url);
                relativeLocation = authorAccess.getXMLUtilAccess().escapeAttributeValue(relativeLocation);
                SchemaAwareHandlerResult result = null;
                AuthorElement elementAtOffset = null;
                try {
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(cp);
                    if (nodeAtOffset.getType() == 0) {
                        elementAtOffset = (AuthorElement)nodeAtOffset;
                    }
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (XHTMLExternalObjectInsertionHandler.isImageReference(authorAccess, type, url)) {
                    if (elementAtOffset != null && "img".equals(elementAtOffset.getLocalName())) {
                        authorAccess.getDocumentController().setAttribute("src", new AttrValue(relativeLocation), elementAtOffset);
                    } else {
                        result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<img src=\"" + relativeLocation + "\" xmlns=\"http://www.w3.org/1999/xhtml\" alt=\"" + authorAccess.getUtilAccess().getFileName(relativeLocation) + "\"/>", cp, true);
                    }
                } else if (MediaObjectsUtil.isMediaReference(url)) {
                    String toInsert = InsertMediaOperation.createMediaContentToInsert(relativeLocation).toString();
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(toInsert, cp);
                } else {
                    result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<a href=\"" + relativeLocation + "\" xmlns=\"http://www.w3.org/1999/xhtml\"/>", cp, true);
                }
                if (result == null || i >= urls.size() - 1 || (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) == null) continue;
                authorAccess.getEditorAccess().setCaretPosition(off + 2);
            }
        }
    }

    private static boolean isImageReference(AuthorAccess authorAccess, ReferenceType type, URL url) {
        return type == ReferenceType.IMAGE_REFERENCE || type == null && authorAccess.getUtilAccess().isSupportedImageURL(url);
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        List<Object> types = Collections.nCopies(urls.size(), null);
        this.insertURLs(authorAccess, urls, types, source);
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return "xhtml2xhtml.xsl";
    }
}

