/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class MoveCaretUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)MoveCaretUtil.class.getName());

    private MoveCaretUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean hasImposedEditorVariableCaretOffset(String xmlFragment) {
        return xmlFragment.contains("<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveCaretToImposedEditorVariableOffset(AuthorAccess authorAccess, int insertionOffset) {
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        AuthorNode caretPI = MoveCaretUtil.detectCaretPI(ctrl, insertionOffset);
        if (caretPI != null) {
            Rectangle rect;
            int caretOffset = caretPI.getStartOffset();
            AuthorReviewController reviewController = authorAccess.getReviewController();
            boolean isTrackingChangesOn = reviewController.isTrackingChanges();
            if (isTrackingChangesOn) {
                reviewController.toggleTrackChanges();
            }
            try {
                ctrl.deleteNode(caretPI);
            }
            finally {
                if (isTrackingChangesOn) {
                    reviewController.toggleTrackChanges();
                }
            }
            AuthorEditorAccess edAccess = authorAccess.getEditorAccess();
            edAccess.setCaretPosition(caretOffset);
            if (authorAccess.getWorkspaceAccess().getPlatform() != Platform.WEBAPP && (rect = edAccess.modelToViewRectangle(edAccess.getCaretOffset())) != null && rect.y > 100) {
                rect.y -= 100;
                edAccess.scrollToRectangle(rect);
            }
        }
    }

    private static AuthorNode detectCaretPI(AuthorDocumentController ctrl, int startSearch) {
        try {
            return MoveCaretUtil.detectCaretPI(ctrl.getNodeAtOffset(startSearch));
        }
        catch (BadLocationException e) {
            logger.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    private static AuthorNode detectCaretPI(AuthorNode node) throws BadLocationException {
        AuthorNode toRet = null;
        if (node.getType() == 5 && node.getTextContent().equals("UNIQUE_CARET_MARKER_FOR_AUTHOR")) {
            toRet = node;
        }
        if (node instanceof AuthorParentNode) {
            List contentNodes = ((AuthorParentNode)node).getContentNodes();
            Iterator iterator = contentNodes.iterator();
            while (iterator.hasNext()) {
                AuthorNode detectPI = MoveCaretUtil.detectCaretPI((AuthorNode)iterator.next());
                if (detectPI == null) continue;
                toRet = detectPI;
                break;
            }
        }
        return toRet;
    }
}

