/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class DeleteElementsOperation
implements AuthorOperation {
    public static final String ARGUMENT_ELEMENT_XPATH_LOCATIONS = "elementLocations";
    protected ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];

    public DeleteElementsOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATIONS, 2, "An XPath expression indicating the elements to be deleted.\nNote: If it is not defined then the element at the caret position will be used.");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATIONS);
        AuthorNode[] nodesToDelete = null;
        if (xpathLocation instanceof String && ((String)xpathLocation).trim().length() > 0) {
            nodesToDelete = authorAccess.getDocumentController().findNodesByXPath(((String)xpathLocation).trim(), true, true, true);
            if (nodesToDelete.length == 0) {
                throw new AuthorOperationException("The element XPath location does not identify a node: " + xpathLocation);
            }
        } else {
            try {
                nodesToDelete = new AuthorNode[]{authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset())};
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Cannot identify the current node", (Throwable)e);
            }
        }
        if (nodesToDelete.length > 0) {
            int i;
            Arrays.sort(nodesToDelete, new Comparator<AuthorNode>(){

                @Override
                public int compare(AuthorNode o1, AuthorNode o2) {
                    int toRet = 0;
                    toRet = o1.getStartOffset() < o2.getStartOffset() ? -1 : 1;
                    return toRet;
                }
            });
            ArrayList<AuthorNode> finalNodesToDelete = new ArrayList<AuthorNode>();
            for (int i2 = 0; i2 < nodesToDelete.length; ++i2) {
                boolean isContained = false;
                AuthorNode node = nodesToDelete[i2];
                for (int j = finalNodesToDelete.size() - 1; j >= 0; --j) {
                    AuthorNode authorNode = (AuthorNode)finalNodesToDelete.get(j);
                    if (authorNode.getEndOffset() <= node.getEndOffset()) continue;
                    isContained = true;
                    break;
                }
                if (isContained) continue;
                finalNodesToDelete.add(node);
            }
            ArrayList<AuthorNode> nodesWithDocParent = null;
            ArrayList<AuthorNode> nodesToDel = null;
            for (i = 0; i < finalNodesToDelete.size(); ++i) {
                AuthorNode currentNode = (AuthorNode)finalNodesToDelete.get(i);
                if (currentNode.getParent() != null && currentNode.getParent().getType() == 2) {
                    if (nodesWithDocParent == null) {
                        nodesWithDocParent = new ArrayList<AuthorNode>();
                    }
                    nodesWithDocParent.add(currentNode);
                    continue;
                }
                if (currentNode.getParent() == null) continue;
                if (nodesToDel == null) {
                    nodesToDel = new ArrayList<AuthorNode>();
                }
                nodesToDel.add(currentNode);
            }
            if (nodesWithDocParent != null) {
                for (i = 0; i < nodesWithDocParent.size(); ++i) {
                    authorAccess.getDocumentController().deleteNode((AuthorNode)nodesWithDocParent.get(i));
                }
            }
            if (nodesToDel != null) {
                AuthorNode commonAncestor = authorAccess.getDocumentController().getCommonAncestor(finalNodesToDelete.toArray(new AuthorNode[0]));
                if (finalNodesToDelete.contains(commonAncestor)) {
                    commonAncestor = commonAncestor.getParent();
                }
                int[] startOffsets = new int[finalNodesToDelete.size()];
                int[] endOffsets = new int[finalNodesToDelete.size()];
                for (int j = 0; j < finalNodesToDelete.size(); ++j) {
                    AuthorNode node = (AuthorNode)finalNodesToDelete.get(j);
                    startOffsets[j] = node.getStartOffset();
                    endOffsets[j] = node.getEndOffset();
                }
                if (commonAncestor != null && commonAncestor instanceof AuthorElement) {
                    authorAccess.getDocumentController().multipleDelete((AuthorElement)commonAncestor, startOffsets, endOffsets);
                }
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Deletes the elements specified by an XPath expression or the element at the caret position";
    }
}

