/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SimpleURLChooserEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleURLChooserEditor.class.getName());
    private static final boolean IS_ECLIPSE = Boolean.getBoolean("com.oxygenxml.is.eclipse.plugin");
    private static final boolean IS_WIN32 = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).startsWith("WIN");
    private static final int VGAP = 0;
    private static final int HGAP = 5;
    private static final String UNDO_MANAGER_PROPERTY = "undo-manager-property";
    private final JButton browseBtn;
    private final JPanel urlChooserPanel = new JPanel(new BorderLayout(5, 0));
    private JTextField urlTextField;
    private boolean isBrowsing = false;
    private final Color defaultForeground;
    private AuthorUtilAccess utilAccess;
    private final java.awt.Font defaultFont;

    public SimpleURLChooserEditor() {
        URL imageURL = SimpleURLChooserEditor.class.getResource("/images/Open16.gif");
        this.browseBtn = new JButton();
        if (imageURL != null) {
            this.browseBtn.setIcon(new ImageIcon(imageURL));
        }
        if (IS_WIN32) {
            this.browseBtn.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 5));
        }
        this.urlTextField = this.createTextField();
        this.defaultForeground = this.urlTextField.getForeground();
        this.urlTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }
        });
        this.urlChooserPanel.add((Component)this.urlTextField, "Center");
        this.urlChooserPanel.add((Component)this.browseBtn, "East");
        this.urlChooserPanel.setOpaque(false);
        this.urlTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    SimpleURLChooserEditor.this.cancelEditing();
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    SimpleURLChooserEditor.this.stopEditing(true);
                }
            }
        });
        this.browseBtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    SimpleURLChooserEditor.this.cancelEditing();
                }
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != SimpleURLChooserEditor.this.browseBtn && e.getOppositeComponent() != SimpleURLChooserEditor.this.urlTextField && !SimpleURLChooserEditor.this.isBrowsing) {
                    SimpleURLChooserEditor.this.fireCommitValue(new EditingEvent((String)SimpleURLChooserEditor.this.getValue()));
                }
            }
        };
        this.browseBtn.addFocusListener(focusListener);
        this.urlTextField.addFocusListener(focusListener);
        Insets originalInsets = this.urlTextField.getMargin();
        Insets imposedInsets = null;
        imposedInsets = originalInsets != null ? (Insets)originalInsets.clone() : new Insets(1, 1, 1, 1);
        if (IS_WIN32 && IS_ECLIPSE) {
            imposedInsets.top = -1;
            imposedInsets.left += 3;
        }
        this.urlTextField.setMargin(imposedInsets);
        this.defaultFont = this.urlTextField.getFont();
    }

    public String getDescription() {
        return "A sample implementation that provides a browse button associated with a text field.";
    }

    public Object getRendererComponent(AuthorInplaceContext context) {
        this.prepareComponents(context, false);
        return this.urlChooserPanel;
    }

    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext context) {
        this.prepareComponents(context, false);
        return this.computeRenderingInfo(context);
    }

    private RendererLayoutInfo computeRenderingInfo(AuthorInplaceContext context) {
        Dimension preferredSize = this.urlTextField.getPreferredSize();
        int width = this.urlTextField.getPreferredSize().width;
        Integer columns = (Integer)context.getArguments().get("columns");
        if (columns != null && columns > 0) {
            FontMetrics fontMetrics = this.urlTextField.getFontMetrics(this.urlTextField.getFont());
            width = SimpleURLChooserEditor.getApproximativeCharsWidth(columns, fontMetrics);
        }
        width = (int)((double)width + (5.0 + this.browseBtn.getPreferredSize().getWidth()));
        int correction = 0;
        if (IS_ECLIPSE) {
            correction = 5;
        }
        return new RendererLayoutInfo(this.urlTextField.getBaseline(preferredSize.width, preferredSize.height), new ro.sync.exml.view.graphics.Dimension(width, preferredSize.height + correction));
    }

    public String getTooltipText(AuthorInplaceContext context, int x, int y) {
        this.prepareComponents(context, false);
        return "Browse URL";
    }

    public Object getEditorComponent(final AuthorInplaceContext context, ro.sync.exml.view.graphics.Rectangle allocation, Point mouseLocation) {
        this.prepareComponents(context, true);
        AuthorAccess authorAccess = context.getAuthorAccess();
        final URL editorLocation = authorAccess.getEditorAccess().getEditorLocation();
        this.browseBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    SimpleURLChooserEditor.this.isBrowsing = true;
                    try {
                        URL chooseURL = context.getAuthorAccess().getWorkspaceAccess().chooseURL("Choose URL", null, null);
                        if (chooseURL == null) break block5;
                        String relativeURL = context.getAuthorAccess().getUtilAccess().makeRelative(editorLocation, chooseURL);
                        try {
                            URL clearedURL = SimpleURLChooserEditor.this.utilAccess.removeUserCredentials(new URL(relativeURL));
                            SimpleURLChooserEditor.this.urlTextField.setText(clearedURL.toExternalForm());
                        }
                        catch (MalformedURLException e1) {
                            SimpleURLChooserEditor.this.urlTextField.setText(relativeURL);
                        }
                        SimpleURLChooserEditor.this.fireCommitValue(new EditingEvent((String)SimpleURLChooserEditor.this.getValue()));
                    }
                    finally {
                        SimpleURLChooserEditor.this.isBrowsing = false;
                    }
                }
            }
        });
        return this.urlChooserPanel;
    }

    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        try {
            Rectangle modelToView = this.urlTextField.modelToView(this.urlTextField.getCaretPosition());
            rectangle = new ro.sync.exml.view.graphics.Rectangle(modelToView.x, modelToView.y, modelToView.width, modelToView.height);
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return rectangle;
    }

    private static int getApproximativeCharsWidth(int numberOfChars, FontMetrics fontMetrics) {
        char[] chars = new char[numberOfChars];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 119;
        }
        return fontMetrics.charsWidth(chars, 0, chars.length);
    }

    public void requestFocus() {
        this.urlTextField.requestFocus();
    }

    public Object getValue() {
        String text = this.urlTextField.getText();
        try {
            URL clearedURL = this.utilAccess.removeUserCredentials(new URL(text));
            return clearedURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            return text;
        }
    }

    public void stopEditing() {
        this.stopEditing(false);
    }

    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    private void stopEditing(boolean onEnter) {
        String text = this.urlTextField.getText();
        try {
            URL clearedURL = this.utilAccess.removeUserCredentials(new URL(text));
            text = clearedURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (onEnter) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent(text));
        }
    }

    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    private void prepareComponents(AuthorInplaceContext context, boolean forEditing) {
        Font font;
        this.utilAccess = context.getAuthorAccess().getUtilAccess();
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)context.getArguments().get("color");
        if (color != null) {
            this.urlTextField.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.urlTextField.setForeground(this.defaultForeground);
        }
        this.setInitialValue(context, forEditing);
        UndoManager undoManager = (UndoManager)this.urlTextField.getDocument().getProperty(UNDO_MANAGER_PROPERTY);
        if (undoManager != null) {
            undoManager.discardAllEdits();
        }
        if ((font = (Font)context.getArguments().get("font")) != null) {
            java.awt.Font currentFont = new java.awt.Font(font.getName(), font.getStyle(), font.getSize());
            this.urlTextField.setFont(currentFont);
            this.browseBtn.setFont(currentFont);
        } else {
            this.urlTextField.setFont(this.defaultFont);
            this.browseBtn.setFont(this.defaultFont);
        }
        InplaceEditorUtil.relayout(this.urlTextField, context);
        Point relMousePos = context.getRelativeMouseLocation();
        boolean rollover = false;
        if (relMousePos != null) {
            RendererLayoutInfo renderInfo = this.computeRenderingInfo(context);
            this.urlChooserPanel.setSize(renderInfo.getSize().width, renderInfo.getSize().height);
            this.urlChooserPanel.doLayout();
            Component componentAt = this.urlChooserPanel.getComponentAt(relMousePos.x, relMousePos.y);
            rollover = componentAt == this.browseBtn;
        }
        this.browseBtn.getModel().setRollover(rollover);
    }

    private void setInitialValue(AuthorInplaceContext context, boolean forEditing) {
        String text = (String)context.getArguments().get("initial_value");
        if (!forEditing && text == null) {
            this.urlTextField.setForeground(Color.GRAY);
            text = (String)context.getArguments().get("default_value");
        }
        if (text == null) {
            text = "";
        }
        try {
            URL clearedURL = this.utilAccess.removeUserCredentials(new URL(text));
            this.urlTextField.setText(clearedURL.toExternalForm());
        }
        catch (MalformedURLException e) {
            this.urlTextField.setText(text);
        }
    }

    protected JTextField createTextField() {
        JTextField textField = new JTextField();
        final UndoManager undoManager = new UndoManager();
        Document doc = textField.getDocument();
        doc.putProperty(UNDO_MANAGER_PROPERTY, undoManager);
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        textField.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        });
        int modifier = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).startsWith("MAC OS") ? 256 : 128;
        KeyStroke undoKS = KeyStroke.getKeyStroke(90, modifier, false);
        KeyStroke redoKS = KeyStroke.getKeyStroke(89, modifier, false);
        textField.getInputMap().put(undoKS, "Undo");
        textField.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        });
        textField.getInputMap().put(redoKS, "Redo");
        return textField;
    }

    public CursorType getCursorType(AuthorInplaceContext context, int x, int y) {
        return CursorType.CURSOR_NORMAL;
    }

    public CursorType getCursorType(int x, int y) {
        return null;
    }

    public void refresh(AuthorInplaceContext context) {
        this.setInitialValue(context, true);
    }

    public boolean insertContent(String content) {
        boolean handled = false;
        try {
            this.urlTextField.getDocument().insertString(this.urlTextField.getCaretPosition(), content, null);
            handled = true;
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return handled;
    }
}

