/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.cssvalidator;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public final class CssValueUtils {
    private CssValueUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static CssIdent getEqual(CssValue value, CssIdent ... idents) {
        for (CssIdent ident : idents) {
            if (!value.equals(ident)) continue;
            return ident;
        }
        return null;
    }

    public static boolean isFunctionAndValid(CssValue value, String propNameToValidateAgainst, ApplContext ac) throws InvalidParamException {
        boolean isFunction = value instanceof CssFunction;
        if (isFunction && !CssProperty.validateFunction((CssFunction)value, ac, propNameToValidateAgainst)) {
            throw new InvalidParamException("value", value, propNameToValidateAgainst, ac);
        }
        return isFunction;
    }

    public static boolean isFunctionAndValid(CssValue value, CssProperty propToValidateAgainst, ApplContext ac) throws InvalidParamException {
        return CssValueUtils.isFunctionAndValid(value, propToValidateAgainst.getPropertyName(), ac);
    }

    public static boolean isAttrOrFunctionAndValid(CssValue value, CssProperty propToValidateAgainst, ApplContext ac) throws InvalidParamException {
        return value instanceof CssAttr || CssValueUtils.isFunctionAndValid(value, propToValidateAgainst, ac);
    }

    public static boolean isStringOrAttrOrFunctionAndValid(CssValue value, CssProperty propToValidateAgainst, ApplContext ac) throws InvalidParamException {
        return value instanceof CssString || CssValueUtils.isAttrOrFunctionAndValid(value, propToValidateAgainst, ac);
    }
}

