package org.w3c.flute.parser.selectors;

import java.util.ArrayList;
import java.util.List;

import org.w3c.flute.css.sac.PageSelector;
import org.w3c.flute.css.sac.PageSelectorList;

/**
 * Simple implementation.
 *  
 * @author dan
 */
public class PageSelectorListImpl implements PageSelectorList {

  /**
   * The list of page selectors. It is always at least one, 
   * otherwise no PageSelectorList would be created.
   */
  private List<PageSelector> list = new ArrayList<PageSelector>(1);
  
  @Override
  public void add(PageSelector selector) {
    list.add(selector);
  }

  @Override
  public Iterable<PageSelector> getIterable() {   
    return list;
  }
  
  /**
   * Formats a string with the page selectors, separated by commas. 
   *
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    int size = list.size();
    for (int i = 0; i < size; i++) {
      sb.append(list.get(i));
      if ( i < size - 1) {
        sb.append(", ");
      }      
    }   
    return sb.toString();
  }
}
