/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.SimpleSelector;

/**
 * @version $Revision$
 * @author  Philippe Le Hegaret, Dan 
 */
public class ChildSelectorImpl extends DescendantSelectorImpl{

    /**
     * An integer indicating the type of <code>Selector</code>
     */
    @Override
    public short getSelectorType() {
      return Selector.SAC_CHILD_SELECTOR;
    }

    /**
     * Creates a new descendant selector.
     * 
     * @param ancestorSelector The selector that should matches the ancestor.
     * @param simpleSelector The selector that matches the current element.
     * @param isSubject <code>true</code> if the simple selector is the subject in a larger descendant selector.
     * @param locator Can be used to extract the systemID, line and column where the selector was defined.
     */
    public ChildSelectorImpl(Selector ancestorSelector, SimpleSelector simpleSelector, boolean isSubject, Locator locator) {
      super(ancestorSelector, simpleSelector, isSubject, locator);
    }       
    
    /**
     * @see org.w3c.flute.css.sac.Condition#getSerialization(Map)
     */
    @Override
    public String getSerialization(Map<String, String> proxyNamespaceMapping) {
      return getSerialization(" > ", proxyNamespaceMapping);
    }
}
