package ro.sync.util.editorvars.parser.model;

/**
 * A lexical unit. Base for editor variables, parameters, plain text, etc.
 */
public abstract class LexicalItem {
  
  /**
   * The type of the lexical unit.
   */
  public enum Type {
    /**
     * Plain text.
     */
    PLAIN_TEXT,
    /**
     * Editor variable.
     */
    EDITOR_VARIABLE,
    /**
     * The ask editor variable is special.
     */
    ASK_EDITOR_VARIABLE,
    /**
     * A parameter. It can be formed from combinations of plain text parts and editor variables.
     */
    COMPOUND_ITEM
  }
  
  /**
   * The type of the lexical unit.
   */
  private final Type type;

  /**
   * Constructor.
   * 
   * @param type The type of the lexical unit. See {@link Type}.
   */
  public LexicalItem(Type type) {
    this.type = type;
  }

  /**
   * @return The type of the lexical unit.
   * 
   * @see Type
   */
  public Type getType() {
    return type;
  }
  
  @Override
  public String toString() {
    return "Type: " + type;
  }
  
  /**
   * @return The string value of this lexical item.
   */
  public abstract String getStringValue();
}
