package ro.sync.util.editorvars.expander;

import ro.sync.util.editorvars.parser.ParseException;

/**
 * Gets notified when an editor variable doesn't respect the required syntax.
 */
public interface ErrorListener {

  /**
   * An editor variable didn't respect the required syntax so it will be treated as plain text.
   *  
   * @param varName Editor variable name.
   * @param ex      Information about the offending characters.
   */
  void error(String varName, ParseException ex);
}
