/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtilBasic;
import ro.sync.basic.io.IOStreamUtil;
import ro.sync.basic.io.zip.TraversalPathException;
import ro.sync.basic.io.zip.ZipUtil;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class FileSystemUtil
extends FileSystemUtilBasic {
    private static final String[] SIZE_UNIT = new String[]{" KB", " MB", " GB"};
    private static final Logger logger = LoggerFactory.getLogger((String)FileSystemUtil.class.getName());
    public static final String COPY_NAME_SUFFIX = " - Copy";
    public static final String OXYGEN_TEMP_DIR = "OxygenXMLTemp";

    public static String proposeValidFileName(String name) {
        return FileSystemUtil.proposeValidFileName(name, false);
    }

    public static String proposeValidFileName(String name, boolean replaceDots) {
        String toReturn = null;
        if (name != null) {
            toReturn = URLUtil.filterPasswords(name);
            StringBuilder validBuilder = new StringBuilder();
            int len = toReturn.length();
            for (int i = 0; i < len; ++i) {
                int ch = toReturn.charAt(i);
                if (Character.isWhitespace((char)ch)) {
                    ch = 95;
                } else if (!(Character.isAlphabetic(ch) || Character.isDigit((char)ch) || !replaceDots && ch == 46)) {
                    ch = 95;
                }
                validBuilder.append((char)ch);
            }
            toReturn = validBuilder.toString();
            toReturn = toReturn.replaceAll("^_+", "");
            toReturn = toReturn.replaceAll("_+$", "");
            toReturn = toReturn.replaceAll("_+", "_");
        }
        return toReturn;
    }

    public static String getName(String name) {
        String resourceName = "";
        if (name != null) {
            int lastURLSeparatorIdx;
            int lastFileSeparatorIdx = name.lastIndexOf(File.separatorChar);
            int lastIndex = lastFileSeparatorIdx > (lastURLSeparatorIdx = name.lastIndexOf(47)) ? lastFileSeparatorIdx : lastURLSeparatorIdx;
            resourceName = name.substring(lastIndex + 1);
        }
        return resourceName;
    }

    public static void deleteRecursivelly(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileSystemUtil.deleteRecursivelly(files[i]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static void zip(File zipFile, File dir2Zip, FileFilter fileFilter, boolean recursive, boolean useDirNameAsArchiveRoot) throws Exception {
        ZipUtil.zip(zipFile, dir2Zip, fileFilter, recursive, useDirNameAsArchiveRoot);
    }

    public static List<File> unzip(File zippedFile, File destinationDirectory, FileFilter fileFilter) throws IOException, TraversalPathException {
        return ZipUtil.unzip(zippedFile, destinationDirectory, fileFilter);
    }

    public static String replaceExtension(String name, String newExtension) {
        String existingExtension = FileSystemUtil.getExtension((String)name);
        if (!newExtension.equals(existingExtension)) {
            if (existingExtension.length() > 0) {
                return ((String)name).substring(0, ((String)name).length() - existingExtension.length()) + newExtension;
            }
            name = ((String)name).endsWith(".") ? (String)name + newExtension : (String)name + "." + newExtension;
        }
        return name;
    }

    public static File findFile(File currentFile, String fileName, FileFilter patternFileFilter) {
        if (currentFile.isDirectory()) {
            File[] files = currentFile.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File found = FileSystemUtil.findFile(files[i], fileName, patternFileFilter);
                    if (found == null) continue;
                    return found;
                }
            }
        } else {
            if (fileName != null && Equaler.verifyEquals(currentFile.getName(), fileName)) {
                return currentFile;
            }
            if (patternFileFilter != null && patternFileFilter.accept(currentFile)) {
                return currentFile;
            }
        }
        return null;
    }

    public static File findFileByExtension(File currentFile, String extension) {
        if (currentFile.isDirectory()) {
            File[] files = currentFile.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File found = FileSystemUtil.findFileByExtension(files[i], extension);
                    if (found == null) continue;
                    return found;
                }
            }
        } else if (Equaler.verifyEquals(FileSystemUtil.getExtension(currentFile.getName()), extension)) {
            return currentFile;
        }
        return null;
    }

    public static File getCommonAncestor(File file1, File file2) {
        File commonAncestor = null;
        if (!file1.isDirectory()) {
            file1 = file1.getParentFile();
        }
        while (file1 != null) {
            if (FileSystemUtil.isAncestor(file1, file2)) {
                commonAncestor = file1;
                break;
            }
            file1 = file1.getParentFile();
        }
        return commonAncestor;
    }

    public static File getDuplicateDestinationFile(File sourceFile, File destinationFile) {
        if (sourceFile.equals(destinationFile)) {
            int index;
            String name = destinationFile.getName();
            String extension = "";
            if (destinationFile.isFile() && (index = name.lastIndexOf(46)) != -1) {
                extension = name.substring(index);
                name = name.substring(0, index);
            }
            int count = 1;
            File parentFile = destinationFile.getParentFile();
            while (destinationFile.exists()) {
                Object countStr = "";
                if (count > 1) {
                    countStr = " (" + count + ")";
                }
                destinationFile = new File(parentFile, name + COPY_NAME_SUFFIX + (String)countStr + extension);
                ++count;
            }
        }
        return destinationFile;
    }

    public static String getFileSize(long sizeInBytes) {
        double doubleValue = Long.valueOf(sizeInBytes).doubleValue();
        Object fileSizeStringValue = "";
        if (doubleValue == 0.0) {
            fileSizeStringValue = "0" + SIZE_UNIT[0];
        } else if (doubleValue > 0.0) {
            int unitIndex = -1;
            while (doubleValue > 1024.0) {
                doubleValue /= 1024.0;
                ++unitIndex;
            }
            if (unitIndex == -1) {
                doubleValue = 1.0;
                ++unitIndex;
            }
            DecimalFormat FILE_SIZE_FORMATTER = new DecimalFormat("###.##");
            fileSizeStringValue = (Serializable)(unitIndex > 0 ? FILE_SIZE_FORMATTER.format(doubleValue) : Long.valueOf(Math.round(doubleValue))) + SIZE_UNIT[unitIndex];
        }
        return fileSizeStringValue;
    }

    public static boolean isAncestor(File file1, File file2) {
        boolean toReturn = false;
        if (file1 != null) {
            while (file2 != null) {
                if (file2.equals(file1)) {
                    toReturn = true;
                    break;
                }
                file2 = file2.getParentFile();
            }
        }
        return toReturn;
    }

    public static void listRecursively(File[] files, boolean addFolders, FileFilter filter, List<File> fileList) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] children;
                if (addFolders) {
                    fileList.add(file);
                }
                if ((children = file.listFiles(filter)) == null) continue;
                FileSystemUtil.listRecursively(children, addFolders, filter, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    public static boolean renameFileTo(File src, File dst) {
        boolean renamed = false;
        boolean sameFile = false;
        if (!PlatformDetector.isLinux()) {
            File dstCanonicalFile;
            File srcCanonicalFile = URLUtil.getCanonicalFile(src);
            boolean bl = sameFile = srcCanonicalFile.compareTo(dstCanonicalFile = URLUtil.getCanonicalFile(dst)) == 0;
            if (PlatformDetector.isMacOS() && !sameFile) {
                sameFile = srcCanonicalFile.getPath().equalsIgnoreCase(dstCanonicalFile.getPath());
            }
        }
        if (!(!sameFile && dst.exists() || (renamed = src.renameTo(dst)) || sameFile)) {
            try {
                FileSystemUtil.copyFile(src, dst, false);
                renamed = true;
                if (!src.delete()) {
                    logger.warn("Cannot delete the source file: " + src);
                }
            }
            catch (IOException e) {
                logger.error("Cannot copy " + src + " to " + dst, (Throwable)e);
            }
        }
        return renamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canCreateAndRename(File dir) {
        boolean canCreateAndRename = false;
        if (dir != null && dir.exists() && dir.isDirectory()) {
            String fileName = System.currentTimeMillis() + "0";
            File toCreate = new File(dir, fileName);
            try {
                boolean created = toCreate.createNewFile();
                if (created && toCreate.exists()) {
                    String newFileName = System.currentTimeMillis() + "1";
                    File renamed = new File(dir, newFileName);
                    boolean couldRename = toCreate.renameTo(renamed);
                    if (couldRename) {
                        canCreateAndRename = true;
                    }
                    renamed.delete();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                toCreate.delete();
            }
        }
        return canCreateAndRename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        boolean canWrite = false;
        if (!file.exists() || file.canWrite()) {
            RandomAccessFile raf = null;
            boolean wrote = false;
            boolean fileExisted = file.exists();
            long timestamp = file.lastModified();
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(raf.length());
                raf.write(32);
                wrote = true;
                raf.setLength(raf.length() - 1L);
                canWrite = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {}
                }
                if (wrote && timestamp > 0L) {
                    file.setLastModified(timestamp);
                }
                if (!fileExisted) {
                    file.delete();
                }
            }
        }
        return canWrite;
    }

    public static boolean canWriteInDir(File dir) {
        boolean isWritable = false;
        if (dir != null) {
            while (dir != null && !dir.exists()) {
                dir = dir.getParentFile();
            }
            if (dir != null && !(isWritable = Files.isWritable(dir.toPath()))) {
                File testFile = dir;
                if (dir.isDirectory()) {
                    testFile = new File(dir, "test.xml");
                }
                isWritable = FileSystemUtil.canWrite(testFile);
            }
        }
        return isWritable;
    }

    public static void copyDir(File source, File destination, boolean recursive, boolean ignoreReadOnlyFlag) throws FileNotFoundException, IOException {
        FileSystemUtil.copyDir(source, destination, recursive, ignoreReadOnlyFlag, null);
    }

    public static void copyDir(File source, File destination, boolean recursive, boolean ignoreReadOnlyFlag, FileFilter filter) throws FileNotFoundException, IOException {
        File[] content;
        if (source == null) {
            return;
        }
        if (!source.isDirectory()) {
            return;
        }
        if (!destination.exists()) {
            if (!destination.mkdirs()) {
                throw new IOException("The destination folder \"" + destination.getAbsolutePath() + "\" cannot be created.");
            }
            if (!ignoreReadOnlyFlag && !source.canWrite()) {
                destination.setReadOnly();
            }
        } else if (!destination.canWrite()) {
            throw new IOException("The destination folder \"" + destination.getAbsolutePath() + "\" is not accessible.");
        }
        File[] fileArray = content = filter == null ? source.listFiles() : source.listFiles(filter);
        if (content != null) {
            for (int i = 0; i < content.length; ++i) {
                if (content[i].isDirectory()) {
                    if (!recursive) continue;
                    FileSystemUtil.copyDir(content[i], new File(destination, content[i].getName()), true, ignoreReadOnlyFlag, filter);
                    continue;
                }
                FileSystemUtil.copyFile(content[i], new File(destination, content[i].getName()), ignoreReadOnlyFlag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File dstFile, boolean ignoreFileFlags) throws IOException {
        File parentFolder = dstFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            throw new IOException("Could not create folder: " + parentFolder);
        }
        FileInputStream fis = new FileInputStream(srcFile);
        try {
            FileOutputStream fos = new FileOutputStream(dstFile);
            FileSystemUtil.copyInputStreamToOutputStream(fis, fos, true);
        }
        finally {
            IOStreamUtil.closeQuietly(fis);
        }
        try {
            long srcLastModified = srcFile.lastModified();
            if (srcLastModified > 0L) {
                dstFile.setLastModified(srcLastModified);
            }
            if (!ignoreFileFlags) {
                if (!srcFile.canWrite()) {
                    dstFile.setReadOnly();
                }
                dstFile.setExecutable(srcFile.canExecute());
                dstFile.setReadable(srcFile.canRead());
                dstFile.setWritable(srcFile.canWrite());
            }
        }
        catch (SecurityException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static File getOxygenTempDirectory() {
        String systemTempDir = System.getProperty("java.io.tmpdir");
        File oxygenTempDir = null;
        String userName = System.getProperty("user.name");
        oxygenTempDir = PlatformDetector.isLinux() && userName != null ? new File(systemTempDir, "OxygenXMLTemp-" + userName) : new File(systemTempDir, OXYGEN_TEMP_DIR);
        return oxygenTempDir;
    }
}

