/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakableOutputStream
extends FilterOutputStream {
    private static Logger logger = LoggerFactory.getLogger((String)BreakableOutputStream.class.getName());
    private List writingThreads = new ArrayList(1);
    private boolean previousOperationFailed;
    private IOException exception;

    public BreakableOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.startWrite();
            try {
                this.out.write(b);
            }
            catch (IOException ex) {
                this.checkException(ex);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private synchronized void startWrite() throws IOException {
        this.writingThreads.add(Thread.currentThread());
        logger.debug("Start write...");
        this.checkException(null);
    }

    private void checkException(IOException ex) throws IOException {
        logger.debug("Check exception " + ex);
        if (this.previousOperationFailed) {
            throw this.exception;
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.startWrite();
            try {
                this.out.write(b);
            }
            catch (IOException ex) {
                this.checkException(ex);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private synchronized void endWrite() {
        this.writingThreads.remove(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.startWrite();
            try {
                this.out.write(b, off, len);
            }
            catch (IOException ex) {
                this.checkException(ex);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkException(null);
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            this.checkException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug("in close()");
            }
            this.checkException(null);
            try {
                this.out.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Ignoring " + e);
            }
        }
    }

    public synchronized void setPreviousOperationFailed(IOException exception) {
        block5: {
            this.previousOperationFailed = true;
            this.exception = exception;
            logger.debug("PreviousOperationFailed set to true. ");
            try {
                this.out.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Ignoring " + e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("errorMessage: " + this.exception.getMessage());
        }
        for (Thread thread : this.writingThreads) {
            if (logger.isDebugEnabled()) {
                logger.debug("Interrupting the writing thread: " + thread);
            }
            thread.interrupt();
        }
    }
}

