/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSCommitter {
    private static volatile boolean ourAutoUnlock;
    private FSFS myFSFS;
    private FSTransactionRoot myTxnRoot;
    private FSTransactionInfo myTxn;
    private Collection<String> myLockTokens;
    private Map<String, String> myAutoUnlockPaths;
    private String myAuthor;

    public static synchronized void setAutoUnlock(boolean autoUnlock) {
        ourAutoUnlock = autoUnlock;
    }

    public static synchronized boolean isAutoUnlock() {
        return ourAutoUnlock;
    }

    public FSCommitter(FSFS fsfs, FSTransactionRoot txnRoot, FSTransactionInfo txn, Collection<String> lockTokens, String author) {
        this.myFSFS = fsfs;
        this.myTxnRoot = txnRoot;
        this.myTxn = txn;
        this.myLockTokens = lockTokens != null ? lockTokens : new HashSet();
        this.myAutoUnlockPaths = new HashMap<String, String>();
        this.myAuthor = author;
    }

    public Map<String, String> getAutoUnlockPaths() {
        return this.myAutoUnlockPaths;
    }

    public void deleteNode(String path) throws SVNException {
        long mergeInfoCount;
        FSTransactionRoot txnRoot = this.getTxnRoot();
        FSParentPath parentPath = txnRoot.openPath(path, true, true);
        SVNNodeKind kind = parentPath.getRevNode().getType();
        if (parentPath.getParent() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ROOT_DIR, "The root directory cannot be deleted");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((txnRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        txnRoot.deleteEntry(parentPath.getParent().getRevNode(), parentPath.getEntryName());
        txnRoot.removeRevNodeFromCache(parentPath.getAbsPath());
        if (this.myFSFS.supportsMergeInfo() && (mergeInfoCount = parentPath.getRevNode().getMergeInfoCount()) > 0L) {
            this.incrementMergeInfoUpTree(parentPath.getParent(), -mergeInfoCount);
        }
        this.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_DELETE, false, false, false, -1L, null, kind);
    }

    public void changeNodeProperty(String path, String name, SVNPropertyValue propValue) throws SVNException {
        FSRepositoryUtil.validateProperty(name, propValue);
        FSTransactionRoot txnRoot = this.getTxnRoot();
        FSParentPath parentPath = txnRoot.openPath(path, true, true);
        SVNNodeKind kind = parentPath.getRevNode().getType();
        if ((txnRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(parentPath, path);
        SVNProperties properties = parentPath.getRevNode().getProperties(this.myFSFS);
        boolean mergeInfoModified = false;
        if (this.myFSFS.supportsMergeInfo() && name.equals("svn:mergeinfo")) {
            long increment = 0L;
            boolean hadMergeInfo = parentPath.getRevNode().hasMergeInfo();
            if (propValue != null && !hadMergeInfo) {
                increment = 1L;
            } else if (propValue == null && hadMergeInfo) {
                increment = -1L;
            }
            if (increment != 0L) {
                parentPath.getRevNode().setHasMergeInfo(propValue != null);
                this.incrementMergeInfoUpTree(parentPath, increment);
            }
            mergeInfoModified = true;
        }
        if (propValue == null) {
            properties.remove(name);
        } else {
            properties.put(name, propValue);
        }
        txnRoot.setProplist(parentPath.getRevNode(), properties);
        this.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, mergeInfoModified, -1L, null, kind);
    }

    public void makeCopy(FSRevisionRoot fromRoot, String fromPath, String toPath, boolean preserveHistory) throws SVNException {
        FSPathChangeKind changeKind;
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String txnId = txnRoot.getTxnID();
        FSRevisionNode fromNode = fromRoot.getRevisionNode(fromPath);
        FSParentPath toParentPath = txnRoot.openPath(toPath, false, true);
        if ((txnRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, toPath, this.myAuthor, this.myLockTokens, true, false);
        }
        if (toParentPath.getRevNode() != null && toParentPath.getRevNode().getId().equals(fromNode.getId())) {
            return;
        }
        long mergeInfoStart = 0L;
        if (toParentPath.getRevNode() != null) {
            changeKind = FSPathChangeKind.FS_PATH_CHANGE_REPLACE;
            if (this.myFSFS.supportsMergeInfo()) {
                mergeInfoStart = toParentPath.getRevNode().getMergeInfoCount();
            }
        } else {
            changeKind = FSPathChangeKind.FS_PATH_CHANGE_ADD;
        }
        this.makePathMutable(toParentPath.getParent(), toPath);
        String fromCanonPath = SVNPathUtil.canonicalizeAbsolutePath(fromPath);
        this.copy(toParentPath.getParent().getRevNode(), toParentPath.getEntryName(), fromNode, preserveHistory, fromRoot.getRevision(), fromCanonPath, txnId);
        if (changeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
            txnRoot.removeRevNodeFromCache(toParentPath.getAbsPath());
        }
        long mergeInfoEnd = 0L;
        if (this.myFSFS.supportsMergeInfo() && mergeInfoStart != (mergeInfoEnd = fromNode.getMergeInfoCount())) {
            this.incrementMergeInfoUpTree(toParentPath.getParent(), mergeInfoEnd - mergeInfoStart);
        }
        FSRevisionNode newNode = txnRoot.getRevisionNode(toPath);
        this.addChange(toPath, newNode.getId(), changeKind, false, false, false, fromRoot.getRevision(), fromCanonPath, fromNode.getType());
    }

    public void makeFile(String path) throws SVNException {
        SVNPathUtil.checkPathIsValid(path);
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String txnId = txnRoot.getTxnID();
        FSParentPath parentPath = txnRoot.openPath(path, false, true);
        if (parentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(txnRoot, path, this.myFSFS), SVNLogType.FSFS);
        }
        if ((txnRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        FSRevisionNode childNode = this.makeEntry(parentPath.getParent().getRevNode(), parentPath.getParent().getAbsPath(), parentPath.getEntryName(), false, txnId);
        txnRoot.putRevNodeToCache(parentPath.getAbsPath(), childNode);
        this.addChange(path, childNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, true, false, false, -1L, null, SVNNodeKind.FILE);
    }

    public void makeDir(String path) throws SVNException {
        SVNPathUtil.checkPathIsValid(path);
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String txnId = txnRoot.getTxnID();
        FSParentPath parentPath = txnRoot.openPath(path, false, true);
        if (parentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(txnRoot, path, this.myFSFS), SVNLogType.FSFS);
        }
        if ((txnRoot.getTxnFlags() & 2) != 0) {
            this.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        FSRevisionNode subDirNode = this.makeEntry(parentPath.getParent().getRevNode(), parentPath.getParent().getAbsPath(), parentPath.getEntryName(), true, txnId);
        txnRoot.putRevNodeToCache(parentPath.getAbsPath(), subDirNode);
        this.addChange(path, subDirNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, false, false, false, -1L, null, SVNNodeKind.DIR);
    }

    public FSRevisionNode makeEntry(FSRevisionNode parent, String parentPath, String entryName, boolean isDir, String txnId) throws SVNException {
        SVNErrorMessage err;
        if (!SVNPathUtil.isSinglePathComponent(entryName)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to create a node with an illegal name ''{0}''", (Object)entryName);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (parent.getType() != SVNNodeKind.DIR) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to create entry in non-directory parent");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!parent.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to clone child of non-mutable node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSRevisionNode newRevNode = new FSRevisionNode();
        newRevNode.setType(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE);
        String createdPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(parentPath, entryName));
        newRevNode.setCreatedPath(createdPath);
        newRevNode.setCopyRootPath(parent.getCopyRootPath());
        newRevNode.setCopyRootRevision(parent.getCopyRootRevision());
        newRevNode.setCopyFromRevision(-1L);
        newRevNode.setCopyFromPath(null);
        FSID newNodeId = this.createNode(newRevNode, parent.getId().getCopyID(), txnId);
        FSRevisionNode childNode = this.myFSFS.getRevisionNode(newNodeId);
        FSTransactionRoot txnRoot = this.getTxnRoot();
        txnRoot.setEntry(parent, entryName, childNode.getId(), newRevNode.getType());
        return childNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChange(String path, FSID id, FSPathChangeKind changeKind, boolean textModified, boolean propsModified, boolean mergeInfoModified, long copyFromRevision, String copyFromPath, SVNNodeKind kind) throws SVNException {
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        OutputStream changesFile = null;
        try {
            FSTransactionRoot txnRoot = this.getTxnRoot();
            changesFile = SVNFileUtil.openFileForWriting(txnRoot.getTransactionChangesFile(), true);
            FSPathChange pathChange = new FSPathChange(path, id, changeKind, textModified, propsModified, mergeInfoModified, copyFromPath, copyFromRevision, kind);
            txnRoot.writeChangeEntry(changesFile, pathChange, true);
        }
        catch (IOException ioe) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(changesFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(changesFile);
        }
        SVNFileUtil.closeFile(changesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long commitTxn(boolean runPreCommitHook, boolean runPostCommitHook, SVNErrorMessage[] postCommitHookError, StringBuffer conflictPath) throws SVNException {
        ArrayList<FSRepresentation> representations;
        long newRevision;
        block17: {
            FSWriteLock writeLock;
            if (this.myFSFS.isHooksEnabled() && runPreCommitHook) {
                FSHooks.runPreCommitHook(this.myFSFS.getRepositoryRoot(), this.myTxn.getTxnId());
            }
            SVNProperties txnProperties = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
            for (String propertyName : new HashSet<String>(txnProperties.nameSet())) {
                if (!propertyName.startsWith("svn:txn-")) continue;
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), propertyName, null);
            }
            newRevision = -1L;
            while (true) {
                long youngishRev = this.myFSFS.getYoungestRevision();
                FSRevisionRoot youngishRoot = this.myFSFS.createRevisionRoot(youngishRev);
                FSRevisionNode youngishRootNode = youngishRoot.getRevisionNode("/");
                FSCommitter.mergeChanges(this.myFSFS, this.getTxnRoot(), youngishRootNode, conflictPath);
                this.myTxn.setBaseRevision(youngishRev);
                writeLock = FSWriteLock.getWriteLockForDB(this.myFSFS);
                representations = this.myFSFS.getRepositoryCacheManager() != null ? new ArrayList<FSRepresentation>() : null;
                FSWriteLock fSWriteLock = writeLock;
                // MONITORENTER : fSWriteLock
                try {
                    writeLock.lock();
                    newRevision = this.commit(representations);
                    break block17;
                }
                catch (SVNException svne) {
                    long youngestRev;
                    if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.FS_TXN_OUT_OF_DATE) throw svne;
                    if (youngishRev != (youngestRev = this.myFSFS.getYoungestRevision())) continue;
                    throw svne;
                }
                break;
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
        // MONITOREXIT : fSWriteLock
        if (representations != null && !representations.isEmpty() && this.myFSFS.getRepositoryCacheManager() != null) {
            try {
                this.myFSFS.getRepositoryCacheManager().runWriteTransaction(new IFSSqlJetTransaction(){

                    @Override
                    public void run() throws SVNException {
                        for (FSRepresentation fsRepresentation : representations) {
                            FSCommitter.this.myFSFS.getRepositoryCacheManager().insert(fsRepresentation, false);
                        }
                    }
                });
            }
            catch (SVNException e) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
            }
        }
        if (!this.myFSFS.isHooksEnabled()) return newRevision;
        if (!runPostCommitHook) return newRevision;
        try {
            FSHooks.runPostCommitHook(this.myFSFS.getRepositoryRoot(), newRevision);
            return newRevision;
        }
        catch (SVNException svne) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, "Commit succeeded, but post-commit hook failed", 1);
            SVNErrorMessage childErr = svne.getErrorMessage();
            childErr.setDontShowErrorCode(true);
            errorMessage.setChildErrorMessage(childErr);
            if (postCommitHookError != null && postCommitHookError.length > 0) {
                postCommitHookError[0] = errorMessage;
                return newRevision;
            }
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return newRevision;
    }

    public void makePathMutable(FSParentPath parentPath, String errorPath) throws SVNException {
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String txnId = txnRoot.getTxnID();
        if (parentPath.getRevNode().getId().isTxn()) {
            return;
        }
        FSRevisionNode clone = null;
        if (parentPath.getParent() != null) {
            this.makePathMutable(parentPath.getParent(), errorPath);
            FSID parentId = null;
            String copyId = null;
            switch (parentPath.getCopyStyle()) {
                case 2: {
                    parentId = parentPath.getParent().getRevNode().getId();
                    copyId = parentId.getCopyID();
                    break;
                }
                case 3: {
                    copyId = this.reserveCopyId(txnId);
                    break;
                }
                case 1: {
                    copyId = null;
                    break;
                }
                default: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: can not make path ''{0}'' mutable", (Object)errorPath);
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
            String copyRootPath = parentPath.getRevNode().getCopyRootPath();
            long copyRootRevision = parentPath.getRevNode().getCopyRootRevision();
            FSRevisionRoot copyrootRoot = this.myFSFS.createRevisionRoot(copyRootRevision);
            FSRevisionNode copyRootNode = copyrootRoot.getRevisionNode(copyRootPath);
            FSID childId = parentPath.getRevNode().getId();
            FSID copyRootId = copyRootNode.getId();
            boolean isParentCopyRoot = false;
            if (!childId.getNodeID().equals(copyRootId.getNodeID())) {
                isParentCopyRoot = true;
            }
            String clonePath = parentPath.getParent().getAbsPath();
            clone = txnRoot.cloneChild(parentPath.getParent().getRevNode(), clonePath, parentPath.getEntryName(), copyId, isParentCopyRoot);
            txnRoot.putRevNodeToCache(parentPath.getAbsPath(), clone);
        } else {
            FSTransactionInfo txn = txnRoot.getTxn();
            if (txn.getRootID().equals(txn.getBaseID())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: txn ''{0}'' root id ''{1}'' matches base id ''{2}''", txnId, txn.getRootID(), txn.getBaseID());
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            clone = this.myFSFS.getRevisionNode(txn.getRootID());
        }
        parentPath.setRevNode(clone);
    }

    public String reserveCopyId(String txnId) throws SVNException {
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String[] nextIds = txnRoot.readNextIDs();
        String copyId = FSRepositoryUtil.generateNextKey(nextIds[1]);
        this.myFSFS.writeNextIDs(txnId, nextIds[0], copyId);
        return "_" + nextIds[1];
    }

    public void incrementMergeInfoUpTree(FSParentPath parentPath, long increment) throws SVNException {
        while (parentPath != null) {
            FSTransactionRoot txnRoot = this.getTxnRoot();
            txnRoot.incrementMergeInfoCount(parentPath.getRevNode(), increment);
            parentPath = parentPath.getParent();
        }
    }

    private void copy(FSRevisionNode toNode, String entryName, FSRevisionNode fromNode, boolean preserveHistory, long fromRevision, String fromPath, String txnId) throws SVNException {
        FSID id = null;
        FSTransactionRoot txnRoot = this.getTxnRoot();
        if (preserveHistory) {
            FSID srcId = fromNode.getId();
            FSRevisionNode toRevNode = FSRevisionNode.dumpRevisionNode(fromNode);
            String copyId = this.reserveCopyId(txnId);
            toRevNode.setPredecessorId(srcId);
            if (toRevNode.getCount() != -1L) {
                toRevNode.setCount(toRevNode.getCount() + 1L);
            }
            String createdPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(toNode.getCreatedPath(), entryName));
            toRevNode.setCreatedPath(createdPath);
            toRevNode.setCopyFromPath(fromPath);
            toRevNode.setCopyFromRevision(fromRevision);
            toRevNode.setCopyRootPath(null);
            id = txnRoot.createSuccessor(srcId, toRevNode, copyId);
        } else {
            id = fromNode.getId();
        }
        txnRoot.setEntry(toNode, entryName, id, fromNode.getType());
    }

    private FSID createNode(FSRevisionNode revNode, String copyId, String txnId) throws SVNException {
        FSTransactionRoot txnRoot = this.getTxnRoot();
        String nodeId = txnRoot.getNewTxnNodeId();
        FSID id = FSID.createTxnId(nodeId, copyId, txnId);
        revNode.setId(id);
        revNode.setIsFreshTxnRoot(false);
        this.myFSFS.putTxnRevisionNode(id, revNode);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long commit(Collection<FSRepresentation> representations) throws SVNException {
        FSWriteLock txnWriteLock;
        String startCopyId;
        String startNodeId;
        long oldRev = this.myFSFS.getYoungestRevision();
        if (this.myTxn.getBaseRevision() != oldRev) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_TXN_OUT_OF_DATE, "Transaction out of date");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        this.verifyLocks();
        if (this.myFSFS.getDBFormat() < 3) {
            String[] ids = this.myFSFS.getNextRevisionIDs();
            startNodeId = ids[0];
            startCopyId = ids[1];
        } else {
            startNodeId = null;
            startCopyId = null;
        }
        long newRevision = oldRev + 1L;
        OutputStream protoFileOS = null;
        FSID newRootId = null;
        FSTransactionRoot txnRoot = this.getTxnRoot();
        FSWriteLock fSWriteLock = txnWriteLock = FSWriteLock.getWriteLockForTxn(this.myTxn.getTxnId(), this.myFSFS);
        synchronized (fSWriteLock) {
            try {
                txnWriteLock.lock();
                File revisionPrototypeFile = txnRoot.getWritableTransactionProtoRevFile();
                long offset = revisionPrototypeFile.length();
                this.commit(startNodeId, startCopyId, newRevision, protoFileOS, newRootId, txnRoot, revisionPrototypeFile, offset, representations);
                File dstRevFile = this.myFSFS.getNewRevisionFile(newRevision);
                SVNFileUtil.rename(revisionPrototypeFile, dstRevFile);
            }
            finally {
                txnWriteLock.unlock();
                FSWriteLock.release(txnWriteLock);
            }
        }
        String commitTime = SVNDate.formatDate(new Date(System.currentTimeMillis()));
        SVNProperties presetRevisionProperties = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
        if (presetRevisionProperties == null || !presetRevisionProperties.containsName("svn:date")) {
            this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:date", SVNPropertyValue.create(commitTime));
        }
        File txnPropsFile = this.myFSFS.getTransactionPropertiesFile(this.myTxn.getTxnId());
        if (this.myFSFS.getDBFormat() < 6 || newRevision >= this.myFSFS.getMinUnpackedRevProp()) {
            File dstRevPropsFile = this.myFSFS.getNewRevisionPropertiesFile(newRevision);
            SVNFileUtil.rename(txnPropsFile, dstRevPropsFile);
        }
        try {
            txnRoot.writeFinalCurrentFile(newRevision, startNodeId, startCopyId);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        this.myFSFS.setYoungestRevisionCache(newRevision);
        this.myFSFS.purgeTxn(this.myTxn.getTxnId());
        return newRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(String startNodeId, String startCopyId, long newRevision, OutputStream protoFileOS, FSID newRootId, FSTransactionRoot txnRoot, File revisionPrototypeFile, long offset, Collection<FSRepresentation> representations) throws SVNException {
        try {
            protoFileOS = SVNFileUtil.openFileForWriting(revisionPrototypeFile, true);
            FSID rootId = FSID.createTxnId("0", "0", this.myTxn.getTxnId());
            CountingOutputStream revWriter = new CountingOutputStream(protoFileOS, offset);
            newRootId = txnRoot.writeFinalRevision(newRootId, revWriter, newRevision, rootId, startNodeId, startCopyId, representations, true);
            long changedPathOffset = txnRoot.writeFinalChangedPathInfo(revWriter);
            if (this.myFSFS.isUseLogAddressing()) {
                txnRoot.writeIndexData(revWriter, newRevision, this.myTxn.getTxnId());
            } else {
                String offsetsLine = "\n" + newRootId.getOffset() + " " + changedPathOffset + "\n";
                protoFileOS.write(offsetsLine.getBytes("UTF-8"));
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(protoFileOS);
        }
        SVNProperties txnProps = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
        if (txnProps != null && !txnProps.isEmpty()) {
            if (txnProps.getStringValue("svn:check-ood") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-ood", null);
            }
            if (txnProps.getStringValue("svn:check-locks") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-locks", null);
            }
        }
    }

    public static void mergeChanges(FSFS owner, FSTransactionRoot txnRoot, FSRevisionNode sourceNode, StringBuffer conflictPath) throws SVNException {
        FSRevisionNode txnRootNode = txnRoot.getRootRevisionNode();
        FSRevisionNode ancestorNode = txnRoot.getTxnBaseRootNode();
        if (txnRootNode.getId().equals(ancestorNode.getId())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: no changes in transaction to commit");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        } else {
            FSCommitter.merge(owner, "/", txnRootNode, sourceNode, ancestorNode, txnRoot, conflictPath);
        }
    }

    private static long merge(FSFS owner, String targetPath, FSRevisionNode target, FSRevisionNode source, FSRevisionNode ancestor, FSTransactionRoot txnRoot, StringBuffer conflictPath) throws SVNException {
        FSID sourceId = source.getId();
        FSID targetId = target.getId();
        FSID ancestorId = ancestor.getId();
        long mergeInfoIncrement = 0L;
        if (ancestorId.equals(targetId)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Bad merge; target ''{0}'' has id ''{1}'', same as ancestor", targetPath, targetId);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (ancestorId.equals(sourceId) || sourceId.equals(targetId)) {
            return mergeInfoIncrement;
        }
        if (source.getType() != SVNNodeKind.DIR || target.getType() != SVNNodeKind.DIR || ancestor.getType() != SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorConflict(targetPath, conflictPath), SVNLogType.FSFS);
        }
        if (!FSRepresentation.compareRepresentations(target.getPropsRepresentation(), ancestor.getPropsRepresentation())) {
            SVNErrorManager.error(FSErrors.errorConflict(targetPath, conflictPath), SVNLogType.FSFS);
        }
        if (!FSRepresentation.compareRepresentations(source.getPropsRepresentation(), ancestor.getPropsRepresentation())) {
            SVNErrorManager.error(FSErrors.errorConflict(targetPath, conflictPath), SVNLogType.FSFS);
        }
        Map sourceEntries = source.getDirEntries(owner);
        Map targetEntries = target.getDirEntries(owner);
        Map ancestorEntries = ancestor.getDirEntries(owner);
        SVNHashSet removedEntries = new SVNHashSet();
        for (String ancestorEntryName : ancestorEntries.keySet()) {
            FSEntry ancestorEntry = (FSEntry)ancestorEntries.get(ancestorEntryName);
            FSEntry sourceEntry = removedEntries.contains(ancestorEntryName) ? null : (FSEntry)sourceEntries.get(ancestorEntryName);
            FSEntry targetEntry = (FSEntry)targetEntries.get(ancestorEntryName);
            if (sourceEntry == null || !ancestorEntry.getId().equals(sourceEntry.getId())) {
                FSRevisionNode sourceEntryNode;
                if (targetEntry != null && ancestorEntry.getId().equals(targetEntry.getId())) {
                    if (owner.supportsMergeInfo()) {
                        FSRevisionNode targetEntryNode = owner.getRevisionNode(targetEntry.getId());
                        long mergeInfoStart = targetEntryNode.getMergeInfoCount();
                        mergeInfoIncrement -= mergeInfoStart;
                    }
                    if (sourceEntry != null) {
                        if (owner.supportsMergeInfo()) {
                            sourceEntryNode = owner.getRevisionNode(sourceEntry.getId());
                            long mergeInfoEnd = sourceEntryNode.getMergeInfoCount();
                            mergeInfoIncrement += mergeInfoEnd;
                        }
                        txnRoot.setEntry(target, ancestorEntryName, sourceEntry.getId(), sourceEntry.getType());
                    } else {
                        txnRoot.deleteEntry(target, ancestorEntryName);
                    }
                } else {
                    if (sourceEntry == null || targetEntry == null) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, ancestorEntryName)), conflictPath), SVNLogType.FSFS);
                    }
                    if (sourceEntry.getType() == SVNNodeKind.FILE || targetEntry.getType() == SVNNodeKind.FILE || ancestorEntry.getType() == SVNNodeKind.FILE) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, ancestorEntryName)), conflictPath), SVNLogType.FSFS);
                    }
                    if (!(sourceEntry.getId().getNodeID().equals(ancestorEntry.getId().getNodeID()) && sourceEntry.getId().getCopyID().equals(ancestorEntry.getId().getCopyID()) && targetEntry.getId().getNodeID().equals(ancestorEntry.getId().getNodeID()) && targetEntry.getId().getCopyID().equals(ancestorEntry.getId().getCopyID()))) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, ancestorEntryName)), conflictPath), SVNLogType.FSFS);
                    }
                    sourceEntryNode = owner.getRevisionNode(sourceEntry.getId());
                    FSRevisionNode targetEntryNode = owner.getRevisionNode(targetEntry.getId());
                    FSRevisionNode ancestorEntryNode = owner.getRevisionNode(ancestorEntry.getId());
                    String childTargetPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, targetEntry.getName()));
                    long subMergeInfoIncrement = FSCommitter.merge(owner, childTargetPath, targetEntryNode, sourceEntryNode, ancestorEntryNode, txnRoot, conflictPath);
                    if (owner.supportsMergeInfo()) {
                        mergeInfoIncrement += subMergeInfoIncrement;
                    }
                }
            }
            removedEntries.add(ancestorEntryName);
        }
        for (String sourceEntryName : sourceEntries.keySet()) {
            if (removedEntries.contains(sourceEntryName)) continue;
            FSEntry sourceEntry = (FSEntry)sourceEntries.get(sourceEntryName);
            FSEntry targetEntry = (FSEntry)targetEntries.get(sourceEntryName);
            if (targetEntry != null) {
                SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, targetEntry.getName())), conflictPath), SVNLogType.FSFS);
            }
            if (owner.supportsMergeInfo()) {
                FSRevisionNode sourceEntryNode = owner.getRevisionNode(sourceEntry.getId());
                long mergeInfoCount = sourceEntryNode.getMergeInfoCount();
                mergeInfoIncrement += mergeInfoCount;
            }
            txnRoot.setEntry(target, sourceEntry.getName(), sourceEntry.getId(), sourceEntry.getType());
        }
        FSCommitter.updateAncestry(owner, sourceId, targetId);
        if (owner.supportsMergeInfo()) {
            txnRoot.incrementMergeInfoCount(target, mergeInfoIncrement);
        }
        return mergeInfoIncrement;
    }

    private static void updateAncestry(FSFS owner, FSID sourceId, FSID targetId) throws SVNException {
        if (!targetId.isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempt to update ancestry of non-mutable node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSRevisionNode targetNode = owner.getRevisionNode(targetId);
        FSRevisionNode sourceNode = owner.getRevisionNode(sourceId);
        targetNode.setPredecessorId(sourceNode.getId());
        long sourcePredecessorCount = sourceNode.getCount();
        targetNode.setPredecessorId(sourceId);
        targetNode.setCount(sourcePredecessorCount != -1L ? sourcePredecessorCount + 1L : sourcePredecessorCount);
        targetNode.setIsFreshTxnRoot(false);
        owner.putTxnRevisionNode(targetId, targetNode);
    }

    private void verifyLocks() throws SVNException {
        FSTransactionRoot txnRoot = this.getTxnRoot();
        Map changes = txnRoot.getChangedPaths();
        Object[] changedPaths = changes.keySet().toArray();
        Arrays.sort(changedPaths);
        String lastRecursedPath = null;
        for (int i = 0; i < changedPaths.length; ++i) {
            String changedPath = (String)changedPaths[i];
            boolean recurse = true;
            if (lastRecursedPath != null && SVNPathUtil.getPathAsChild(lastRecursedPath, changedPath) != null) continue;
            FSPathChange change = (FSPathChange)changes.get(changedPath);
            if (change.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_MODIFY) {
                recurse = false;
            }
            this.allowLockedOperation(this.myFSFS, changedPath, this.myAuthor, this.myLockTokens, recurse, true);
            if (!recurse) continue;
            lastRecursedPath = changedPath;
        }
    }

    private FSTransactionRoot getTxnRoot() throws SVNException {
        if (this.myTxnRoot == null && this.myTxn != null) {
            this.myTxnRoot = this.myFSFS.createTransactionRoot(this.myTxn);
        }
        return this.myTxnRoot;
    }

    public void allowLockedOperation(FSFS fsfs, String path, final String username, final Collection<String> lockTokens, boolean recursive, boolean haveWriteLock) throws SVNException {
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        if (recursive) {
            ISVNLockHandler handler = new ISVNLockHandler(){

                @Override
                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    if (FSCommitter.isAutoUnlock()) {
                        FSCommitter.this.scheduleForAutoUnlock(username, path, lock);
                    } else {
                        FSCommitter.this.verifyLock(lock, lockTokens, username);
                    }
                }

                @Override
                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }
            };
            fsfs.walkDigestFiles(fsfs.getDigestFileFromRepositoryPath(path), handler, haveWriteLock);
        } else {
            SVNLock lock = fsfs.getLockHelper(path, haveWriteLock);
            if (lock != null) {
                if (FSCommitter.isAutoUnlock()) {
                    this.scheduleForAutoUnlock(username, path, lock);
                } else {
                    this.verifyLock(lock, lockTokens, username);
                }
            }
        }
    }

    private void scheduleForAutoUnlock(String username, String path, SVNLock lock) {
        this.myAutoUnlockPaths.put(path, lock.getID());
    }

    private void verifyLock(SVNLock lock, Collection<String> lockTokens, String username) throws SVNException {
        SVNErrorMessage err;
        if (username == null || "".equals(username)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot verify lock on path ''{0}''; no username available", (Object)lock.getPath());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        } else if (username.compareTo(lock.getOwner()) != 0) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "User {0} does not own lock on path ''{1}'' (currently locked by {2})", username, lock.getPath(), lock.getOwner());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (lockTokens.contains(lock.getID())) {
            return;
        }
        err = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Cannot verify lock on path ''{0}''; no matching lock-token available", (Object)lock.getPath());
        SVNErrorManager.error(err, SVNLogType.FSFS);
    }

    public static void abortTransaction(FSFS fsfs, String txnId) throws SVNException {
        File txnDir = fsfs.getTransactionDir(txnId);
        SVNFileUtil.deleteAll(txnDir, true);
        if (txnDir.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Transaction cleanup failed");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }
}

