/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.converter.CalendarConverter;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PopupWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Beans;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class Lm
implements ProductNames {
    private static Logger LOGGER = Logger.getLogger(Lm.class.getName());
    public static final boolean DEBUG = false;
    public static final boolean DOC_DEBUG = false;
    public static final boolean CM_DEBUG = false;
    public static final boolean RA_DEBUG = false;
    public static final boolean ID_DEBUG = false;
    public static final boolean PG_DEBUG = false;
    public static final boolean CB_DEBUG = false;
    public static final boolean HG_DEBUG = false;
    public static final boolean AF_DEBUG = false;
    public static final boolean BP_DEBUG = false;
    public static final boolean DOCK_DEBUG = false;
    public static final boolean DOCK_ID_DEBUG = false;
    public static final boolean ACTION_DEBUG = false;
    public static final boolean COMPONENT_DEBUG = false;
    public static final boolean PROPERTY_TABLE_DEBUG = false;
    public static final boolean COMBOBOX_DEBUG = false;
    public static final boolean BEAN_INTROSPECTOR_DEBUG = false;
    public static final boolean DEMO = false;
    private static final String COMPANY = "JIDE Software, Inc.";
    private static final int YEAR = 2016;
    private static final int MONTH = 3;
    private static final int DAY = 4;
    private static boolean _showDemo = false;
    private static int count = 0;
    private static JFrame _parent;
    private static final String PRODUCT_VERSION = "3.6.12";
    private static final Calendar expireDate;
    private static final String EVAL_ONLY = "Evaluation Purpose Only";
    private static int _showProducts;
    private static boolean _showCommon;
    private static int _productsPurchased;
    private static String _companyName;
    private static String _projectName;
    private static final String PRODUCT_DOCKING_S = "Docking";
    private static final String PRODUCT_COMPONENT_S = "Component";
    private static final String PRODUCT_GRID_S = "Grid";
    private static final String PRODUCT_DIALOG_S = "Dialog";
    private static final String PRODUCT_ACTION_S = "Action";
    private static final String PRODUCT_SHORTCUT_S = "Shortcut";
    private static final String PRODUCT_PIVOT_S = "Pivot";
    private static final String PRODUCT_CODE_EDITOR_S = "CodeEditor";
    private static final String PRODUCT_FEEDREADER_S = "FeedReader";
    private static final String PRODUCT_DASHBOARD_S = "Dashboard";
    private static final String PRODUCT_DATAGRIDS_S = "Data";
    private static final String PRODUCT_CHART_S = "Charts";
    private static final String PRODUCT_GANTT_S = "Gantt";
    private static final String PRODUCT_DIFF_S = "Diff";
    private static final String PRODUCT_TREEMAP_S = "TreeMap";
    private static final String PRODUCT_JDAF_S = "JDAF";
    private static final String[] PRODUCTS;
    private static final BigInteger e;
    private static final BigInteger n;

    public static String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public static boolean showDemoMessageBoxDocking() {
        if (++count != 0 && count % 20 == 0) {
            _showDemo = false;
            Lm.z();
        }
        return false;
    }

    public static void showAboutMessageBox() {
        _showDemo = false;
        Lm.z();
    }

    private static String getProductName(int product) {
        StringBuffer buffer = new StringBuffer();
        if (product == 0) {
            return "";
        }
        if ((product & 1) != 0) {
            buffer.append("JIDE Docking Framework, ");
        }
        if ((product & 2) != 0) {
            buffer.append("JIDE Components, ");
        }
        if ((product & 4) != 0) {
            buffer.append("JIDE Grids, ");
        }
        if ((product & 8) != 0) {
            buffer.append("JIDE Dialogs, ");
        }
        if ((product & 0x10) != 0) {
            buffer.append("JIDE Action Framework, ");
        }
        if ((product & 0x40) != 0) {
            buffer.append("JIDE Shortcut Editor, ");
        }
        if ((product & 0x20) != 0) {
            buffer.append("JIDE Pivot Grid, ");
        }
        if ((product & 0x80) != 0) {
            buffer.append("JIDE Code Editor, ");
        }
        if ((product & 0x100) != 0) {
            buffer.append("JIDE Feed Reader, ");
        }
        if ((product & 0x400) != 0) {
            buffer.append("JIDE Dashboard, ");
        }
        if ((product & 0x800) != 0) {
            buffer.append("JIDE Data Grids, ");
        }
        if ((product & 0x1000) != 0) {
            buffer.append("JIDE Charts, ");
        }
        if ((product & 0x2000) != 0) {
            buffer.append("JIDE Gantt Chart, ");
        }
        if ((product & 0x4000) != 0) {
            buffer.append("JIDE Diff, ");
        }
        if ((product & 0x8000) != 0) {
            buffer.append("JIDE TreeMap, ");
        }
        if ((product & 0x200) != 0) {
            buffer.append("JIDE Desktop Application Framework, ");
        }
        String productName = new String(buffer);
        return productName.substring(0, productName.length() - 2);
    }

    protected static String getProductName(int[] products) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < products.length; ++i) {
            int product = products[i];
            if (product != 1) continue;
            buf.append(PRODUCTS[i]);
        }
        return buf.toString();
    }

    public static void showInvalidProductMessage(String className, int productName) {
        if (_productsPurchased == 0) {
            if (!_showCommon) {
                if ("true".equals(SecurityUtils.getProperty("jide.verifyLicense", "false"))) {
                    System.err.println("Verifying " + className);
                    Thread.dumpStack();
                }
                if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                    Lm.showMessageBox("<html><font size=3><b>Unauthorized usage of JIDE products</b></font><br><br><hr size='1'><br>You get this message box is because you didn't input a correct license key.<br>If you see this message box in one of our demo examples, just ignore it. If you wish to use JIDE products in <br>your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Continue");
                } else {
                    System.out.println("Unauthorized usage of JIDE products\nYou get this message is because you didn't input a correct license key.\nIf you see this message box in one of our demo examples, just ignore it.\nIf you wish to use JIDE products in your application, please contact sales@jidesoft.com.");
                }
                _showCommon = true;
            }
        } else if ((_showProducts & productName) == 0) {
            if ("true".equals(SecurityUtils.getProperty("jide.verifyLicense", "false"))) {
                System.err.println("Verifying " + className + " for " + productName);
                Thread.dumpStack();
            }
            String unauthorizedName = Lm.getProductName(productName);
            String productsName = Lm.getProductName(_productsPurchased);
            if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                Lm.showMessageBox("<html><font size=3><b>Unauthorized usage of JIDE products</b></font><br><br><hr size='1'><br>You get this message box is because the license key(s) are for " + productsName + " only.<br>The class " + className + " you tried to use is part of " + unauthorizedName + ".<br>If you wish to use " + unauthorizedName + " in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Continue");
            } else {
                System.out.println("Unauthorized usage of JIDE products\nYou get this message is because the license key(s) are for " + productsName + " only.\nThe class " + className + " you tried to use is part of " + unauthorizedName + ".\nIf you wish to use " + unauthorizedName + " in your application, please contact sales@jidesoft.com.");
            }
            _showProducts |= productName;
        }
    }

    private static void showDemoWelcomeMessageBox() {
        if (_productsPurchased == 0) {
            Lm.verifyLicense();
        }
        Calendar current = Calendar.getInstance();
        Object products = "JIDE Docking Framework, JIDE Action Framework, JIDE Components, JIDE Grids, JIDE Dialogs, JIDE Pivot Grid, JIDE Shortcut Editor, JIDE Code Editor, JIDE Feed Reader, JIDE Dashboard, JIDE Data Grids, JIDE Charts, JIDE Gantt Chart, and JIDE Diff";
        int index = ((String)products).indexOf(",", ((String)products).length() / 2);
        products = ((String)products).substring(0, index + 1) + "<BR>" + ((String)products).substring(index + 1) + "<BR>" + Lm.getProductVersion();
        if (_productsPurchased == 0 && current.after(expireDate)) {
            Lm.showMessageBox("<html><font size=3><b>Demo for " + (String)products + "</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br><font color='red'><b>This demo version has expired on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) + ".</b></font><br>If you want to continue evaluating, please download it again from http://www.jidesoft.com.<br><br><b>Please Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited. If you wish to use any JIDE products in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Exit");
            System.exit(0);
        } else if (!_showDemo) {
            if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                Lm.showMessageBox("<html><font size=3><b>Demo for " + (String)products + "</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br>This is an evaluation version of JIDE products " + (_productsPurchased == 0 ? ". It will expire on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) : "that is temporarily licensed to <b>" + _companyName + "</b> for " + _projectName) + ".<br><br><b>Please Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited.<br> If you wish to use any JIDE products in your application, please contact sales@jidesoft.com. If you already purchased, please download the formal release package to get rid of this message box.</html>", COMPANY, -1, "Continue to Evaluate");
            } else {
                System.out.println("Demo for JIDE Docking Framework, JIDE Action Framework, JIDE Components, JIDE Grids, JIDE Dialogs, JIDE Pivot Grid, JIDE Shortcut Editor, JIDE Code Editor, JIDE Feed Reader, JIDE Dashboard, JIDE Data Grids, JIDE Charts, JIDE Gantt Chart, and JIDE Diff\n\nCopyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.\n\n---------\nThis is an evaluation version of JIDE products " + (_productsPurchased == 0 ? ". It will expire on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) : "that is temporarily licensed to <b>" + _companyName + " for " + _projectName) + ".\n\nPlease Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited.\n If you wish to use any JIDE products in your application, please contact sales@jidesoft.com. If you already purchased, please download the formal release package to get rid of this message box.");
            }
            _showDemo = true;
        }
    }

    public static void z() {
        Lm.showDemoWelcomeMessageBox();
    }

    private static String createInputString(String companyName, String projectName, int product1, int product2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(companyName);
        buffer.append(":");
        buffer.append(projectName);
        buffer.append(":");
        buffer.append(product1);
        if (product2 != 0) {
            buffer.append(":");
            buffer.append(product2);
        }
        return new String(buffer);
    }

    private static String createInputString(String companyName, String projectName, String product) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(companyName);
        buffer.append(":");
        buffer.append(projectName);
        buffer.append(":");
        buffer.append(product);
        return new String(buffer);
    }

    private static int convertProductStringToValue(String products) {
        int value = 0;
        if (products.indexOf(PRODUCT_DOCKING_S) != -1) {
            value |= 1;
        }
        if (products.indexOf(PRODUCT_COMPONENT_S) != -1) {
            value |= 2;
        }
        if (products.indexOf(PRODUCT_GRID_S) != -1) {
            value |= 4;
        }
        if (products.indexOf(PRODUCT_DIALOG_S) != -1) {
            value |= 8;
        }
        if (products.indexOf(PRODUCT_ACTION_S) != -1) {
            value |= 0x10;
        }
        if (products.indexOf(PRODUCT_SHORTCUT_S) != -1) {
            value |= 0x40;
        }
        if (products.indexOf(PRODUCT_PIVOT_S) != -1) {
            value |= 0x20;
        }
        if (products.indexOf(PRODUCT_CODE_EDITOR_S) != -1) {
            value |= 0x80;
        }
        if (products.indexOf(PRODUCT_FEEDREADER_S) != -1) {
            value |= 0x100;
        }
        if (products.indexOf(PRODUCT_DASHBOARD_S) != -1) {
            value |= 0x400;
        }
        if (products.indexOf(PRODUCT_DATAGRIDS_S) != -1) {
            value |= 0x800;
        }
        if (products.indexOf(PRODUCT_CHART_S) != -1) {
            value |= 0x1000;
        }
        if (products.indexOf(PRODUCT_GANTT_S) != -1) {
            value |= 0x2000;
        }
        if (products.indexOf(PRODUCT_DIFF_S) != -1) {
            value |= 0x4000;
        }
        if (products.indexOf(PRODUCT_TREEMAP_S) != -1) {
            value |= 0x8000;
        }
        if (products.indexOf(PRODUCT_JDAF_S) != -1) {
            value |= 0x200;
        }
        return value;
    }

    static boolean z(int product) {
        if (_productsPurchased == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No license key is input, try to get it from resource file or system property");
            }
            Lm.verifyLicense();
        }
        return (_productsPurchased & product) != 0 && !EVAL_ONLY.equals(_projectName);
    }

    public static void verifyLicense(String companyName, String projectName, String licenseKey) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verify license key: " + companyName + " + " + projectName + " + " + licenseKey);
        }
        Lm.internalVerifyProductLicense(companyName, projectName, licenseKey);
    }

    private static void verifyLicense() {
        ResourceBundle r = null;
        try {
            r = ResourceBundle.getBundle("com.jidesoft.utils.utils");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (r == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    r = ResourceBundle.getBundle("com.jidesoft.utils.utils", Locale.getDefault(), loader);
                }
            }
            catch (Exception loader) {}
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Retrieved license key from the resource file");
        }
        try {
            String licenseKey;
            String projectName;
            String companyName;
            String string = companyName = r != null ? r.getString("verifyLicense.companyName") : SecurityUtils.getProperty("verifyLicense.companyName", null);
            if (companyName == null || companyName.trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Company name is empty");
                }
                return;
            }
            String string2 = projectName = r != null ? r.getString("verifyLicense.projectName") : SecurityUtils.getProperty("verifyLicense.projectName", null);
            if (projectName == null || projectName.trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Product name is empty");
                }
                return;
            }
            String string3 = licenseKey = r != null ? r.getString("verifyLicense.licenseKey") : SecurityUtils.getProperty("verifyLicense.licenseKey", null);
            if (licenseKey == null || licenseKey.trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("License key is empty");
                }
                return;
            }
            Lm.internalVerifyProductLicense(companyName, projectName, licenseKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void internalVerifyProductLicense(String companyName, String projectName, String licenseKey) {
        Object o;
        String date;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verifying ...");
        }
        if (companyName == null || companyName.trim().length() == 0 || projectName == null || projectName.trim().length() == 0 || licenseKey == null || licenseKey.trim().length() == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Verify failed as one of the names are null");
            }
            return;
        }
        companyName = companyName.trim();
        if ((projectName = projectName.trim()).startsWith("Trial") && (date = projectName.substring("Trial".length()).trim()).length() > 0 && (o = new CalendarConverter().fromString(date, null)) instanceof Calendar && Calendar.getInstance().after((Calendar)o)) {
            Lm.showMessageBox("<html><font size=3><b>Trial Version for JIDE Products</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br><font color='red'><b>This trial version has expired on " + DateFormat.getDateInstance(1).format(((Calendar)o).getTime()) + ".</b></font><br>If you want to continue evaluating, please email sales@jidesoft.com to extend your trial license.<br><br><b>Please Note: This release package is for trial purpose only. Distribution of it is strictly prohibited.<br> If you wish to use any JIDE products in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Exit");
            System.exit(0);
        }
        int[] sw = new int[PRODUCTS.length];
        Arrays.fill(sw, 0);
        BigInteger key = Lm.computeInteger(licenseKey);
        BigInteger classNameValue = key.modPow(e, n);
        if (Lm.verifyCommonProducts(companyName, projectName, sw, classNameValue)) {
            return;
        }
        if (Lm.verifyAllProducts(companyName, projectName, sw, classNameValue)) {
            return;
        }
        for (int i = 15; i >= 0; --i) {
            for (int j = 7; j >= 0; --j) {
                int inputValue = Lm.computerSum(Lm.createInputString(companyName, projectName, i, j * 16));
                if (!classNameValue.equals(new BigInteger("" + inputValue))) continue;
                _productsPurchased |= i + j * 16;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Verified (old way): " + _productsPurchased);
                }
                return;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verify failed");
        }
    }

    private static boolean verifyAllProducts(String companyName, String projectName, int[] sw, BigInteger classNameValue) {
        sw[0] = 1;
        while (sw[0] >= 0) {
            sw[1] = 1;
            while (sw[1] >= 0) {
                sw[2] = 1;
                while (sw[2] >= 0) {
                    sw[3] = 1;
                    while (sw[3] >= 0) {
                        sw[4] = 1;
                        while (sw[4] >= 0) {
                            sw[5] = 1;
                            while (sw[5] >= 0) {
                                sw[6] = 1;
                                while (sw[6] >= 0) {
                                    sw[7] = 1;
                                    while (sw[7] >= 0) {
                                        sw[8] = 1;
                                        while (sw[8] >= 0) {
                                            sw[9] = 1;
                                            while (sw[9] >= 0) {
                                                sw[10] = 1;
                                                while (sw[10] >= 0) {
                                                    sw[11] = 1;
                                                    while (sw[11] >= 0) {
                                                        sw[12] = 1;
                                                        while (sw[12] >= 0) {
                                                            sw[13] = 1;
                                                            while (sw[13] >= 0) {
                                                                sw[14] = 1;
                                                                while (sw[14] >= 0) {
                                                                    sw[15] = 1;
                                                                    while (sw[15] >= 0) {
                                                                        if (Lm.verify(companyName, projectName, sw, classNameValue)) {
                                                                            return true;
                                                                        }
                                                                        sw[15] = sw[15] - 1;
                                                                    }
                                                                    sw[14] = sw[14] - 1;
                                                                }
                                                                sw[13] = sw[13] - 1;
                                                            }
                                                            sw[12] = sw[12] - 1;
                                                        }
                                                        sw[11] = sw[11] - 1;
                                                    }
                                                    sw[10] = sw[10] - 1;
                                                }
                                                sw[9] = sw[9] - 1;
                                            }
                                            sw[8] = sw[8] - 1;
                                        }
                                        sw[7] = sw[7] - 1;
                                    }
                                    sw[6] = sw[6] - 1;
                                }
                                sw[5] = sw[5] - 1;
                            }
                            sw[4] = sw[4] - 1;
                        }
                        sw[3] = sw[3] - 1;
                    }
                    sw[2] = sw[2] - 1;
                }
                sw[1] = sw[1] - 1;
            }
            sw[0] = sw[0] - 1;
        }
        return false;
    }

    private static boolean verifyCommonProducts(String companyName, String projectName, int[] sw, BigInteger classNameValue) {
        Arrays.fill(sw, 1);
        if (Lm.verify(companyName, projectName, sw, classNameValue)) {
            return true;
        }
        Arrays.fill(sw, 0);
        sw[0] = 1;
        sw[1] = 1;
        if (Lm.verify(companyName, projectName, sw, classNameValue)) {
            return true;
        }
        sw[2] = 1;
        sw[3] = 1;
        sw[4] = 1;
        if (Lm.verify(companyName, projectName, sw, classNameValue)) {
            return true;
        }
        for (int i = 0; i < sw.length; ++i) {
            Arrays.fill(sw, 0);
            sw[i] = 1;
            if (!Lm.verify(companyName, projectName, sw, classNameValue)) continue;
            return true;
        }
        Arrays.fill(sw, 0);
        sw[2] = 1;
        sw[6] = 1;
        return Lm.verify(companyName, projectName, sw, classNameValue);
    }

    private static boolean verify(String companyName, String projectName, int[] sw, BigInteger classNameValue) {
        String possibleProductName = Lm.getProductName(sw);
        int inputValue = Lm.computerSum2(Lm.createInputString(companyName, projectName, possibleProductName));
        if (classNameValue.equals(new BigInteger("" + inputValue))) {
            _productsPurchased |= Lm.convertProductStringToValue(possibleProductName);
            _companyName = companyName;
            _projectName = projectName;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Verified: " + _productsPurchased);
            }
            return true;
        }
        return false;
    }

    public static void clearLicense() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("License key is cleared");
        }
        _productsPurchased = 0;
    }

    private static BigInteger computeInteger(String str) {
        BigInteger value = BigInteger.ZERO;
        for (int i1 = str.length() - 1; i1 >= 0; --i1) {
            int valueOfChar;
            char c1 = str.charAt(i1);
            if ('0' <= c1 && c1 <= '9') {
                valueOfChar = c1 - 48;
            } else if ('A' <= c1 && c1 <= 'Z') {
                valueOfChar = c1 - 65 + 10;
            } else if ('a' <= c1 && c1 <= 'z') {
                valueOfChar = c1 - 97 + 36;
            } else if (c1 == '.') {
                valueOfChar = 62;
            } else if (c1 == ':') {
                valueOfChar = 63;
            } else {
                System.err.println("incorrect char:" + c1);
                continue;
            }
            value = value.shiftLeft(6);
            value = value.add(BigInteger.valueOf(valueOfChar));
        }
        return value;
    }

    private static int computerSum(String str) {
        int sum = 1976;
        for (int j1 = 0; j1 < str.length(); ++j1) {
            sum += str.charAt(j1);
            sum += 666;
            sum ^= 0x7895;
        }
        return sum;
    }

    private static int computerSum2(String str) {
        int sum = 1979;
        for (int j = 0; j < str.length(); ++j) {
            sum += str.charAt(j);
            sum += 88888;
            sum ^= 0x31527B;
        }
        return sum;
    }

    public static void setParent(JFrame parent) {
        _parent = parent;
    }

    private static void showMessageBox(Object message, String title, int messageType) {
        Lm.showMessageBox(message, title, messageType, null);
    }

    private static void showMessageBox(Object message, String title, int messageType, String buttonText) {
        if (_parent == null) {
            JFrame parent = new JFrame(COMPANY);
            parent.setIconImage(JideIconsFactory.getImageIcon("jide/jide32.png").getImage());
            parent.setLocation(0, Integer.MAX_VALUE);
            parent.pack();
            parent.setVisible(true);
            PortingUtils.notifyUser();
            parent.toFront();
            MessageDialog dialog = new MessageDialog(parent, title, message.toString(), messageType, buttonText);
            dialog.display(false);
            parent.setVisible(false);
            parent.dispose();
        } else {
            MessageDialog dialog = new MessageDialog(_parent, title, message.toString(), messageType, buttonText);
            dialog.display(false);
        }
    }

    public static void showPopupMessageBox(String message) {
        PopupWindow popupWindow = new PopupWindow(_parent);
        JLabel toolTip = new JLabel();
        toolTip.setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        toolTip.setForeground(Color.black);
        toolTip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        toolTip.setText(message);
        popupWindow.add(toolTip);
        popupWindow.show(_parent, 100, 200);
    }

    private static void showVersion() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JIDE Version: ").append(PRODUCT_VERSION);
        buffer.append("<BR>");
        buffer.append("JDK Version: ").append(SystemInfo.getJavaVersion());
        buffer.append("<BR>");
        buffer.append("JDK Vendor: ").append(SystemInfo.getJavaVendor());
        buffer.append("<BR>");
        buffer.append("Java Class Version: ").append(SystemInfo.getJavaClassVersion());
        buffer.append("<BR>");
        buffer.append("Platform: ").append(SystemInfo.getOS());
        buffer.append("<BR>");
        buffer.append("Platform Version: ").append(SystemInfo.getOSVersion());
        buffer.append("<BR>");
        buffer.append("Platform Architecture: ").append(SystemInfo.getOSArchitecture());
        buffer.append("<BR>");
        String text = buffer.toString();
        text = text.replaceAll("<BR>", "\n");
        System.out.println(text);
        Lm.showMessageBox("<HTML>" + buffer + "</HTML>", "JIDE Products - System Information", -1);
    }

    public static void main(String[] args) {
        Lm.showVersion();
    }

    public static void getUIError(String componentName) {
        Lm.showMessageBox("<HTML><B>Missing value in LookAndFeel's UIDefaults</B>. <BR><BR><HR><BR>Component \"<B>" + componentName + "</B>\" requires its own ComponentUI and additional values in LookAndFeel's UIDefaults.<BR>Please make sure you call LookAndFeelFactory.installJideExtension() whenever you switch L&F.<BR>For more details, please refer to Developer Guides or visit JIDE Developer's Forum (http://www.jidesoft.com/forum).\n", "LookAndFeel Error", -1, "  Exit  ");
        System.exit(-1);
    }

    static {
        expireDate = Calendar.getInstance();
        expireDate.set(2016, 2, 4, 0, 0, 0);
        _showProducts = 0;
        _showCommon = false;
        _productsPurchased = 0;
        _companyName = null;
        _projectName = null;
        PRODUCTS = new String[]{PRODUCT_DOCKING_S, PRODUCT_COMPONENT_S, PRODUCT_GRID_S, PRODUCT_DIALOG_S, PRODUCT_ACTION_S, PRODUCT_SHORTCUT_S, PRODUCT_PIVOT_S, PRODUCT_CODE_EDITOR_S, PRODUCT_FEEDREADER_S, PRODUCT_DASHBOARD_S, PRODUCT_DATAGRIDS_S, PRODUCT_CHART_S, PRODUCT_GANTT_S, PRODUCT_DIFF_S, PRODUCT_TREEMAP_S, PRODUCT_JDAF_S};
        e = new BigInteger("19", 10);
        n = new BigInteger("305508269643653255827856366547026610628423058227532461973", 10);
    }

    private static class MessageDialog
    extends CancelableDialog {
        private String _message;
        private int _messageType;
        private String _buttonText;

        public MessageDialog(Frame owner, String title, String message) throws HeadlessException {
            this(owner, title, message, -1, null);
        }

        public MessageDialog(Frame owner, String title, String message, int messageType) throws HeadlessException {
            this(owner, title, message, messageType, null);
        }

        public MessageDialog(Frame owner, String title, String message, int messageType, String buttonText) throws HeadlessException {
            super(owner, title, true);
            this._message = message;
            this._messageType = messageType;
            this._buttonText = buttonText;
            this.initComponents();
        }

        private void initComponents() {
            JLabel iconLabel;
            JPanel panel = new JPanel(new BorderLayout(6, 6));
            JButton button = new JButton(this.getDefaultCancelAction());
            this.getRootPane().setDefaultButton(button);
            if (this._buttonText != null) {
                button.setText(this._buttonText);
            }
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JLabel label = new JLabel(this._message);
            JPanel messagePanel = new JPanel(new BorderLayout(12, 12));
            switch (this._messageType) {
                case 2: {
                    iconLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.warningIcon"));
                    break;
                }
                case 0: {
                    iconLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.errorIcon"));
                    break;
                }
                case 1: {
                    iconLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.informationIcon"));
                    break;
                }
                case 3: {
                    iconLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.questionIcon"));
                    break;
                }
                default: {
                    iconLabel = new JLabel(JideIconsFactory.getImageIcon("jide/jide_logo.png"));
                }
            }
            messagePanel.add((Component)JideSwingUtilities.createTopPanel(iconLabel), "Before");
            messagePanel.add((Component)label, "Center");
            panel.add((Component)messagePanel, "Center");
            panel.add((Component)JideSwingUtilities.createCenterPanel(button), "Last");
            this.getContentPane().add(panel);
        }
    }

    private static class CancelableDialog
    extends JDialog {
        private boolean _result = false;
        private CancelAction _cancelAction = new CancelAction(this);

        public CancelableDialog() throws HeadlessException {
            this((Frame)null, "", true);
        }

        public CancelableDialog(Frame owner) throws HeadlessException {
            this(owner, "", true);
        }

        public CancelableDialog(Frame owner, String title) throws HeadlessException {
            this(owner, title, true);
        }

        public CancelableDialog(Frame owner, boolean modal) throws HeadlessException {
            this(owner, "", modal);
        }

        public CancelableDialog(Frame frame, String title, boolean modal) {
            super(frame, title, modal);
            this.getRootPane().registerKeyboardAction(this._cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
        }

        public final boolean getResult() {
            return this._result;
        }

        public final void setResult(boolean result) {
            this._result = result;
        }

        public void display(boolean resizable) {
            this.setDefaultEnabled(this.getRootPane());
            this.pack();
            this.setResizable(resizable);
            JideSwingUtilities.globalCenterWindow(this);
            this.setVisible(true);
        }

        private void setDefaultEnabled(Component c) {
            if (c instanceof JButton) {
                c.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        this.getRootPane().setDefaultButton((JButton)e.getSource());
                    }
                });
            }
            Component[] children = null;
            if (c instanceof JMenu) {
                children = ((JMenu)c).getMenuComponents();
            } else if (c instanceof Container) {
                children = ((Container)c).getComponents();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.setDefaultEnabled(children[i]);
                }
            }
        }

        public void display() {
            this.display(false);
        }

        public AbstractAction getDefaultCancelAction() {
            return this._cancelAction;
        }

        private class CancelAction
        extends AbstractAction {
            private JDialog _dlg;

            protected CancelAction(JDialog aboutBox) {
                super("Close");
                this._dlg = aboutBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelableDialog.this._result = false;
                this._dlg.setVisible(false);
            }
        }
    }
}

