/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.eclipse.EclipseMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class EclipseJideSplitButtonUI
extends EclipseMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent c) {
        return new EclipseJideSplitButtonUI();
    }

    @Override
    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c) {
        EclipseJideSplitButtonUI ui;
        if (condition == 0 && (ui = (EclipseJideSplitButtonUI)EclipseJideSplitButtonUI.getUIOfType(((JideSplitButton)c).getUI(), EclipseJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem b = this.menuItem;
        LazyActionMap.installLazyActionMap(b, EclipseJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap km = this.getInputMap(0, b);
        SwingUtilities.replaceUIInputMap(b, 0, km);
    }

    @Override
    protected void uninstallKeyboardActions() {
        JMenuItem b = this.menuItem;
        SwingUtilities.replaceUIInputMap(b, 2, null);
        SwingUtilities.replaceUIInputMap(b, 0, null);
        SwingUtilities.replaceUIActionMap(b, null);
        super.uninstallKeyboardActions();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected Rectangle getButtonRect(JComponent c, int orientation, int width, int height) {
        Rectangle rect = orientation == 0 && c.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin, height);
        return rect;
    }

    protected Rectangle getDropDownRect(JComponent c, int orientation, int width, int height) {
        Object position = c.getClientProperty("JButton.segmentPosition");
        Rectangle rect = c.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), height) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), height);
        if (position != null && !"only".equals(position)) {
            if ("first".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("middle".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("last".equals(position)) {
                // empty if block
            }
        }
        return rect;
    }

    protected void paintSunkenBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintSunken2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 2, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 2);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + 1, b.x + b.width - 3, b.y + 1);
        g.drawLine(b.x + 1, b.y + 1, b.x + 1, b.y + b.height - 3);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.x, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintRaisedBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintRaised2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + b.height - 2, b.x + b.width - 2, b.y + b.height - 2);
        g.drawLine(b.x + b.width - 2, 1, b.x + b.width - 2, b.y + b.height - 2);
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    private Color getForegroundOfState(JMenuItem menuItem) {
        int state = JideSwingUtilities.getButtonState(menuItem);
        Color foreground = null;
        if (menuItem instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)menuItem)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = menuItem.getForeground();
        }
        return foreground;
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        JideSplitButton b;
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        orientation = 0;
        Object o = menuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean paintBackground = o instanceof Boolean ? ((Boolean)o).booleanValue() : menuItem.isOpaque();
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g, menuItem, bgColor);
            if (menuItem.isEnabled()) {
                if (model.isArmed() || model.isPressed() || this.isMouseOver()) {
                    g.setColor(this.selectionForeground);
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.selectionForeground, menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                } else {
                    g.setColor(this.getForegroundOfState(menuItem));
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                }
            } else {
                g.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlDkShadow"), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
            }
            return;
        }
        if (paintBackground) {
            if (menuItem.getParent() != null) {
                g.setColor(menuItem.getParent().getBackground());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if ((b = (JideSplitButton)menuItem).getButtonStyle() == 0) {
            if (model.isSelected()) {
                if (b.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                } else if (b.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
                }
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                    }
                } else {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                if (b.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                }
            } else if (paintBackground) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled() && b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
            }
        } else if (b.getButtonStyle() == 2) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunkenBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (b.isAlwaysDropdown()) {
                    rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                } else {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            }
        } else if (b.getButtonStyle() == 1) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunken2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if (this.isMouseOver() && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                }
            } else if (b.isRolloverEnabled() && this.isMouseOver() && model.isEnabled()) {
                if (b.isAlwaysDropdown()) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    this.paintRaised2Border(g, rect);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            } else if (b.isAlwaysDropdown()) {
                Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            } else {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            }
        }
        this.paintArrow(menuItem, g);
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g) {
        int menuHeight;
        int menuWidth;
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        int startX = menuItem.getComponentOrientation().isLeftToRight() ? menuWidth - 9 : 4;
        if (menuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), startX, menuHeight / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlShadow"), startX, menuHeight / 2 - 1, 5, 0);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMinimumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            } else {
                d.height = (int)((float)d.height - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            }
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMaximumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
            } else {
                d.height = (int)((float)d.height + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
            }
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getPreferredSize(c);
        }
        AbstractButton b = (AbstractButton)c;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            isHorizontal = false;
        }
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, this.defaultTextIconGap);
        int size = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        d.width += size;
        if (isHorizontal) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    protected void paintIcon(JMenuItem b, Graphics g) {
        ButtonModel model = b.getModel();
        if (b.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(b) == 1) {
                g.translate(0, b.getWidth() - 1);
                ((Graphics2D)g).rotate(-1.5707963267948966);
            }
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
                if (icon == null) {
                    icon = b.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b, icon);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(b, g, EclipseJideSplitButtonUI.iconRect.x, EclipseJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(b) == 1) {
                ((Graphics2D)g).rotate(1.5707963267948966);
                g.translate(0, -b.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 1;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("downPressed"));
        map.put(new Actions("downReleased"));
    }

    @Override
    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int mnemonic = this.menuItem.getModel().getMnemonic();
        if (mnemonic != 0 && this.windowInputMap != null) {
            int[] shortcutKeys = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (shortcutKeys == null) {
                shortcutKeys = new int[]{8};
            }
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu menu) {
        MenuElement[] selectedPath;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        if (menu.isTopLevelMenu()) {
            if (menu.isSelected()) {
                manager.clearSelectedPath();
            } else {
                Container cnt = EclipseJideSplitButtonUI.getFirstParentMenuElement(menu);
                if (cnt != null && cnt instanceof MenuElement) {
                    ArrayList<Container> parents = new ArrayList<Container>();
                    while (cnt instanceof MenuElement) {
                        parents.add(0, cnt);
                        if (cnt instanceof JPopupMenu) {
                            cnt = (Container)((JPopupMenu)cnt).getInvoker();
                            continue;
                        }
                        cnt = EclipseJideSplitButtonUI.getFirstParentMenuElement(cnt);
                    }
                    MenuElement[] me = new MenuElement[parents.size() + 1];
                    for (int i = 0; i < parents.size(); ++i) {
                        Container container = (Container)parents.get(i);
                        me[i] = (MenuElement)((Object)container);
                    }
                    me[parents.size()] = menu;
                    manager.setSelectedPath(me);
                } else {
                    MenuElement[] me = new MenuElement[]{menu};
                    manager.setSelectedPath(me);
                }
            }
        }
        if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
            if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                EclipseJideSplitButtonUI.appendPath(selectedPath, menu.getPopupMenu());
            } else {
                EclipseJideSplitButtonUI.setupPostTimer(menu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MenuElement)) continue;
            return parent;
        }
        return null;
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.cancelMenuIfNecessary(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            EclipseJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.isClickOnButton(e, menu)) {
                if (((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    menu.getModel().setArmed(true);
                    menu.getModel().setPressed(true);
                }
                if (!menu.hasFocus() && menu.isRequestFocusEnabled()) {
                    menu.requestFocus();
                }
            } else {
                EclipseJideSplitButtonUI.downButtonPressed(menu);
            }
        }

        private boolean isClickOnButton(MouseEvent e, JMenu menu) {
            int size;
            if (((JideSplitButton)menu).isAlwaysDropdown()) {
                return false;
            }
            boolean clickOnDropDown = false;
            int n = size = ((JMenu)EclipseJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? EclipseJideSplitButtonUI.this._splitButtonMargin : EclipseJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(EclipseJideSplitButtonUI.this.menuItem) == 0) {
                if (e.getPoint().getX() < (double)(menu.getWidth() - size)) {
                    clickOnDropDown = true;
                }
            } else if (e.getPoint().getY() < (double)(menu.getHeight() - size)) {
                clickOnDropDown = true;
            }
            return clickOnDropDown;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(e, menu)) {
                EclipseJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                EclipseJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(e);
        }

        private void cancelMenuIfNecessary(MouseEvent e) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(e, menu) && ((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    menu.getModel().setPressed(false);
                    menu.getModel().setArmed(false);
                } else {
                    menu.getModel().setArmed(false);
                    menu.getModel().setPressed(false);
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElements = manager.getSelectedPath();
                for (int i = menuElements.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElements[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(menu)) continue;
                    menu.getModel().setRollover(false);
                    EclipseJideSplitButtonUI.this.setMouseOver(false);
                    manager.clearSelectedPath();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        EclipseMenuUI.appendPath(EclipseJideSplitButtonUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(EclipseJideSplitButtonUI.this.getPath());
                        EclipseMenuUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                EclipseJideSplitButtonUI.this.setMouseOver(true);
            }
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            EclipseJideSplitButtonUI.this.setMouseOver(false);
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            String key = this.getName();
            if (PRESS.equals(key) && ((JideSplitButton)b).isAlwaysDropdown()) {
                key = DOWN_PRESS;
            }
            if (PRESS.equals(key)) {
                ButtonModel model = b.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else if (DOWN_PRESS.equals(key)) {
                EclipseJideSplitButtonUI.downButtonPressed((JMenu)b);
            } else if (DOWN_RELEASE.equals(key)) {
                // empty if block
            }
        }

        @Override
        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }
}

