/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ClickThroughLabel;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.oxygenxml.RetinaIconUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;

public class BasicDockableFrameTitlePane
extends JComponent
implements MouseListener {
    protected AbstractButton _autohideButton;
    protected AbstractButton _closeButton;
    protected AbstractButton _hideAutohideButton;
    protected AbstractButton _floatButton;
    protected AbstractButton _maximizeButton;
    protected final LinkedHashMap<Action, AbstractButton> _additionalButtons = new LinkedHashMap();
    protected JComponent _title;
    protected Gripper _gripper;
    protected JPopupMenu _popupMenu;
    protected DockableFrame _frame;
    protected Color _backgroundColor;
    protected Color _selectedTitleColor;
    protected Color _selectedTextColor;
    protected Color _selectedTitleBorderColor;
    protected Color _notSelectedTitleColor;
    protected Color _notSelectedTextColor;
    protected Color _notSelectedTitleBorderColor;
    protected PropertyChangeListener _propertyChangeListener;
    protected String _closeText;
    protected String _hideAutohideText;
    protected String _dockableText;
    protected String _autohideText;
    protected String _floatingText;
    protected String _maximizeText;
    protected String _closeButtonToolTip;
    protected String _hideAutohideButtonToolTip;
    protected String _autohideButtonToolTip;
    protected String _floatButtonToolTip;
    protected String _maximizeButtonToolTip;
    protected Icon _closeIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideIcon");
    protected Icon _closeActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideActiveIcon");
    protected Icon _closeRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideRolloverIcon");
    protected Icon _closeRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideRolloverActiveIcon");
    protected Icon _hideAutohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideIcon");
    protected Icon _hideAutohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideActiveIcon");
    protected Icon _hideAutohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideRolloverIcon");
    protected Icon _hideAutohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideRolloverActiveIcon");
    protected Icon _autohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideIcon");
    protected Icon _autohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideActiveIcon");
    protected Icon _autohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideRolloverIcon");
    protected Icon _autohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideRolloverActiveIcon");
    protected Icon _stopAutohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideIcon");
    protected Icon _stopAutohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideActiveIcon");
    protected Icon _stopAutohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideRolloverIcon");
    protected Icon _stopAutohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideRolloverActiveIcon");
    protected Icon _floatIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatIcon");
    protected Icon _floatActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatActiveIcon");
    protected Icon _floatRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatRolloverIcon");
    protected Icon _floatRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatRolloverActiveIcon");
    protected Icon _unfloatIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatIcon");
    protected Icon _unfloatActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatActiveIcon");
    protected Icon _unfloatRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatRolloverIcon");
    protected Icon _unfloatRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatRolloverActiveIcon");
    protected Icon _maximizeIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeIcon");
    protected Icon _maximizeActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeActiveIcon");
    protected Icon _maximizeRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeRolloverIcon");
    protected Icon _maximizeRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeRolloverActiveIcon");
    protected Icon _restoreIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreIcon");
    protected Icon _restoreActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreActiveIcon");
    protected Icon _restoreRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreRolloverIcon");
    protected Icon _restoreRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreRolloverActiveIcon");
    protected int _gripperWidth = 6;
    protected String _titleButtonUI = null;
    protected boolean _titleBarComponentCanBeOneSameLine = false;
    protected boolean _alwaysShowAllButtons = false;
    protected boolean _showIcon = false;
    protected boolean _use3DButtons = false;
    protected boolean _contentFilledButtons = false;
    protected int _buttonsAlignment = 11;
    protected int _titleAlignment = 10;
    protected int _buttonGap = 2;
    protected Insets _titleInsets = new Insets(0, 0, 0, 0);
    private ThemePainter _painter;
    protected Painter _gripperPainter;
    private Dimension _maximumButtonSize = null;

    public BasicDockableFrameTitlePane(DockableFrame f) {
        this._frame = f;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.setLayout(this.createLayout());
        this.createComponents();
        this.updateAdditionalButtons();
        this.addSubComponents();
    }

    protected void uninstallTitlePane() {
        this.removeAll();
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    protected Dimension getMaximumButtonSize() {
        if (this._maximumButtonSize == null) {
            if (this._closeIcon == null) {
                this._maximumButtonSize = new Dimension(8, 8);
            } else {
                int height;
                int width = 8;
                if (width < this._closeIcon.getIconWidth()) {
                    width = this._closeIcon.getIconWidth();
                }
                if (width < this._autohideIcon.getIconWidth()) {
                    width = this._autohideIcon.getIconWidth();
                }
                if (width < this._stopAutohideIcon.getIconWidth()) {
                    width = this._stopAutohideIcon.getIconWidth();
                }
                if (width < this._floatIcon.getIconWidth()) {
                    width = this._floatIcon.getIconWidth();
                }
                if (width < this._unfloatIcon.getIconWidth()) {
                    width = this._unfloatIcon.getIconWidth();
                }
                if (width < this._maximizeIcon.getIconWidth()) {
                    width = this._maximizeIcon.getIconWidth();
                }
                if (width < this._restoreIcon.getIconWidth()) {
                    width = this._restoreIcon.getIconWidth();
                }
                if ((height = 8) < this._closeIcon.getIconHeight()) {
                    height = this._closeIcon.getIconHeight();
                }
                if (height < this._autohideIcon.getIconHeight()) {
                    height = this._autohideIcon.getIconHeight();
                }
                if (height < this._stopAutohideIcon.getIconHeight()) {
                    height = this._stopAutohideIcon.getIconHeight();
                }
                if (height < this._floatIcon.getIconHeight()) {
                    height = this._floatIcon.getIconHeight();
                }
                if (height < this._unfloatIcon.getIconHeight()) {
                    height = this._unfloatIcon.getIconHeight();
                }
                if (height < this._maximizeIcon.getIconHeight()) {
                    height = this._maximizeIcon.getIconHeight();
                }
                if (height < this._restoreIcon.getIconHeight()) {
                    height = this._restoreIcon.getIconHeight();
                }
                this._maximumButtonSize = new Dimension(width += 2, height += 2);
            }
        }
        return this._maximumButtonSize;
    }

    protected void addSubComponents() {
        if (!this._frame.isShowTitleBar()) {
            return;
        }
        if (this._gripper != null) {
            this.add(this._gripper);
        }
        if (this._maximizeButton != null) {
            this.add(this._maximizeButton);
        }
        if (this._floatButton != null) {
            this.add(this._floatButton);
        }
        if (this._closeButton != null) {
            this.add(this._closeButton);
        }
        if (this._hideAutohideButton != null) {
            this.add(this._hideAutohideButton);
        }
        if (this._autohideButton != null) {
            this.add(this._autohideButton);
        }
        for (AbstractButton button : this._additionalButtons.values()) {
            this.add(button);
        }
        if (this._frame.getTitleBarComponent() != null) {
            this.add(this._frame.getTitleBarComponent());
        }
        this.add(this._title);
    }

    protected void updateAdditionalButtons() {
        List<Action> actions = this._frame.getAdditionalButtonActions();
        HashSet<Action> toBeRemoved = new HashSet<Action>(this._additionalButtons.keySet());
        toBeRemoved.removeAll(actions);
        for (Action action : toBeRemoved) {
            this.remove((Component)this._additionalButtons.remove(action));
        }
        for (Action action : actions) {
            if (this._additionalButtons.containsKey(action)) continue;
            AbstractButton button = this.createTitleBarButton();
            Icon icon = this._frame.getActionIcon(action);
            if (icon != null) {
                button.setIcon(icon);
            }
            this._additionalButtons.put(action, button);
            this.changeButtonType(button, 101);
            button.setAction(action);
        }
    }

    protected void createActions() {
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._frame.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this._propertyChangeListener != null) {
            this._frame.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("DockableFrameTitlePane.gripperPainter");
        this.setBorder(UIDefaultsLookup.getBorder("DockableFrame.titleBorder"));
        this._backgroundColor = UIDefaultsLookup.getColor("DockableFrame.background");
        this._selectedTitleColor = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
        this._selectedTextColor = this.getPainter().getDockableFrameTitleBarActiveForeground();
        this._selectedTitleBorderColor = UIDefaultsLookup.getColor("DockableFrame.activeTitleBorderColor");
        this._notSelectedTitleColor = UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBackground");
        this._notSelectedTextColor = this.getPainter().getDockableFrameTitleBarInactiveForeground();
        this._notSelectedTitleBorderColor = UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBorderColor");
        this.setFont(UIDefaultsLookup.getFont("DockableFrameTitlePane.font"));
        if (this._title != null) {
            this.adjustSelectionColor();
        }
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        this._closeText = resourceBundle.getString("DockableFrameTitlePane.closeText");
        this._hideAutohideText = resourceBundle.getString("DockableFrameTitlePane.hideAutohideText");
        this._dockableText = resourceBundle.getString("DockableFrameTitlePane.dockableText");
        this._floatingText = resourceBundle.getString("DockableFrameTitlePane.floatingText");
        this._autohideText = resourceBundle.getString("DockableFrameTitlePane.autohideText");
        this._maximizeText = resourceBundle.getString("DockableFrameTitlePane.maximizeText");
        this._closeButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.closeTooltip");
        this._hideAutohideButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.hideAutohideTooltip");
        this._autohideButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.autohideTooltip");
        this._floatButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.floatingTooltip");
        this._maximizeButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.maximizeTooltip");
        this._titleBarComponentCanBeOneSameLine = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.titleBarComponent");
        Object showIcon = UIDefaultsLookup.get("DockableFrameTitlePane." + this._frame.getKey() + ".showIcon");
        this._showIcon = showIcon instanceof Boolean ? (Boolean)showIcon : UIDefaultsLookup.getBoolean("DockableFrameTitlePane.showIcon");
        this._use3DButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.use3dButtons");
        this._contentFilledButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.contentFilledButtons");
        this._alwaysShowAllButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.alwaysShowAllButtons");
        this._buttonsAlignment = UIDefaultsLookup.getInt("DockableFrameTitlePane.buttonsAlignment");
        this._titleAlignment = UIDefaultsLookup.getInt("DockableFrameTitlePane.titleAlignment");
        this._buttonGap = UIDefaultsLookup.getInt("DockableFrameTitlePane.buttonGap");
        this._titleInsets = UIDefaultsLookup.getInsets("DockableFrameTitlePane.margin");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._titleButtonUI = UIDefaultsLookup.getString("DockableFrameTitlePane.titleButtonUI");
    }

    protected void adjustSelectionColor() {
        if (this.dockableFrameHasFocus()) {
            this._title.setForeground(this._selectedTextColor);
        } else {
            this._title.setForeground(this._notSelectedTextColor);
        }
    }

    protected boolean dockableFrameHasFocus() {
        return this._frame.isActive() && this._frame.getDockingManager() != null && this._frame.getDockingManager().isActive();
    }

    protected void uninstallDefaults() {
        this._backgroundColor = null;
        this._selectedTitleColor = null;
        this._selectedTextColor = null;
        this._selectedTitleBorderColor = null;
        this._notSelectedTitleColor = null;
        this._notSelectedTextColor = null;
        this._notSelectedTitleBorderColor = null;
        this._closeText = null;
        this._hideAutohideText = null;
        this._dockableText = null;
        this._floatingText = null;
        this._autohideText = null;
        this._maximizeText = null;
        this._closeButtonToolTip = null;
        this._hideAutohideButtonToolTip = null;
        this._autohideButtonToolTip = null;
        this._floatButtonToolTip = null;
        this._maximizeButtonToolTip = null;
        this._titleInsets = null;
        this.setBorder(null);
        this._painter = null;
        this._gripperPainter = null;
    }

    protected void createComponents() {
        this._gripper = new Gripper();
        Object object = this._frame.getClientProperty("DraggingListener");
        if (object != null) {
            this._gripper.addMouseListener((MouseListener)object);
            this._gripper.addMouseMotionListener((MouseMotionListener)object);
        }
        this._title = this._frame.getTitleLabelComponent();
        if (this._title == null) {
            this._title = this.createDefaultTitleLabel();
        }
        if (this._title instanceof JLabel) {
            ((JLabel)this._title).setHorizontalAlignment(this._titleAlignment);
            ((JLabel)this._title).setVerticalAlignment(0);
            if (this._showIcon) {
                ((JLabel)this._title).setIcon(this._frame.getFrameIcon());
            }
        }
        this.adjustSelectionColor();
        this._floatButton = this.createTitleBarButton();
        this.setupButton(this._floatButton, this._frame.getFloatingAction());
        this._autohideButton = this.createTitleBarButton();
        this.setupButton(this._autohideButton, this._frame.getAutohideAction());
        this._closeButton = this.createTitleBarButton();
        this.setupButton(this._closeButton, this._frame.getCloseAction());
        this._hideAutohideButton = this.createTitleBarButton();
        this.setupButton(this._hideAutohideButton, this._frame.getHideAutohideAction());
        this._maximizeButton = this.createTitleBarButton();
        this.setupButton(this._maximizeButton, this._frame.getMaximizeAction());
        this.setButtonIcons();
    }

    protected JComponent createDefaultTitleLabel() {
        ClickThroughLabel clickThroughLabel = new ClickThroughLabel(this._frame.getTitle());
        if (this._frame != null) {
            String toolTipText = this._frame.getToolTipText();
            this.setToolTipText(toolTipText);
            clickThroughLabel.setToolTipText(toolTipText);
        }
        clickThroughLabel.setTarget(this);
        clickThroughLabel.setOpaque(false);
        clickThroughLabel.setFont(this.getFont());
        return clickThroughLabel;
    }

    protected void setupButton(final AbstractButton button, final Action action) {
        button.addActionListener(action);
        this.updateButtonFromAction(action, button);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicDockableFrameTitlePane.this.updateButtonFromAction(action, button);
            }
        });
    }

    protected void updateButtonFromAction(Action action, AbstractButton button) {
        Icon icon;
        Object tooltip;
        Object name = action.getValue("Name");
        if (name != null) {
            button.setName("" + name);
        }
        if ((tooltip = action.getValue("ShortDescription")) != null && tooltip.toString().length() != 0) {
            button.setToolTipText(tooltip.toString());
        }
        button.setEnabled(action.isEnabled());
        if (this._additionalButtons.containsKey(action) && (icon = this._frame.getActionIcon(action)) != null) {
            button.setIcon(icon);
        }
        this.updateButtonVisibilities();
    }

    protected void updateButtonVisibilities() {
        if (!this._alwaysShowAllButtons) {
            if (this._autohideButton != null) {
                this._autohideButton.setVisible(this.shouldAutohideButtonVisible());
            }
            if (this._maximizeButton != null) {
                this._maximizeButton.setVisible(this.shouldMaximizeButtonVisible());
            }
            if (this._floatButton != null) {
                this._floatButton.setVisible(this.shouldFloatButtonVisible());
            }
            if (this._closeButton != null) {
                this._closeButton.setVisible(this.shouldCloseButtonVisible());
            }
            if (this._hideAutohideButton != null) {
                this._hideAutohideButton.setVisible(this.shouldHideAutohideButtonVisible());
            }
        }
    }

    protected AbstractButton createTitleBarButton() {
        NoFocusButton noFocusButton = new NoFocusButton();
        noFocusButton.setUse3DButtons(this._use3DButtons);
        noFocusButton.setContentAreaFilled(this._contentFilledButtons);
        noFocusButton.putClientProperty("ignoreClickToActivate", Boolean.TRUE);
        return noFocusButton;
    }

    protected void changeButtonType(AbstractButton button, int type) {
        if (button != null && button instanceof NoFocusButton) {
            ((NoFocusButton)button).setType(type);
        }
    }

    protected void setButtonIcons() {
        this.changeButtonType(this._closeButton, 0);
        this.changeButtonType(this._hideAutohideButton, 7);
        if (!this._frame.isAutohideShowing()) {
            this.changeButtonType(this._autohideButton, 1);
        } else {
            this.changeButtonType(this._autohideButton, 2);
        }
        if (!this._frame.isFloated()) {
            this.changeButtonType(this._floatButton, 3);
        } else {
            this.changeButtonType(this._floatButton, 4);
        }
        if (!this._frame.isMaximized()) {
            this.changeButtonType(this._maximizeButton, 5);
        } else {
            this.changeButtonType(this._maximizeButton, 6);
        }
    }

    protected void addPopupMenuItems(JPopupMenu popup) {
        JMenuItem closeMenuItem = popup.add(new JCheckBoxMenuItem(this._frame.getCloseAction()));
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        closeMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.closeMnemonic").charAt(0));
        JMenuItem hideAutohideMenuItem = popup.add(new JCheckBoxMenuItem(this._frame.getHideAutohideAction()));
        hideAutohideMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.hideAutohideMnemonic").charAt(0));
        JMenuItem floatingMenuItem = popup.add(new JCheckBoxMenuItem(this._frame.getFloatingAction()));
        floatingMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.floatingMnemonic").charAt(0));
        JMenuItem autohideMenuItem = popup.add(new JCheckBoxMenuItem(this._frame.getAutohideAction()));
        autohideMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.autohideMnemonic").charAt(0));
        JMenuItem maximizeMenuItem = popup.add(new JCheckBoxMenuItem(this._frame.getMaximizeAction()));
        maximizeMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.maximizeMnemonic").charAt(0));
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    @Override
    public void paintComponent(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getTitleBarHeight());
        }
        this.paintTitleBackground(g);
        this._title.setOpaque(false);
        this.adjustSelectionColor();
    }

    protected void paintGripper(Graphics g) {
        if (!this._frame.isShowGripper()) {
            return;
        }
        if (this._gripper != null) {
            this._gripper.setSelected(this.dockableFrameHasFocus());
        }
        Rectangle gripperRect = this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, 0, this._gripperWidth, this.getTitleBarHeight()) : new Rectangle(this.getWidth() - this._gripperWidth, 0, this.getWidth() - this._titleInsets.right, this.getTitleBarHeight());
        if (this._gripperPainter != null) {
            this._gripperPainter.paint(this._frame, g, gripperRect, 0, this.dockableFrameHasFocus() ? 3 : 0);
        } else {
            this.getPainter().paintGripper(this._frame, g, gripperRect, 0, this.dockableFrameHasFocus() ? 3 : 0);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        boolean paintAsSelected = this.dockableFrameHasFocus();
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getTitleBarHeight());
        this.getPainter().paintDockableFrameTitlePane(this, g, rect, 0, paintAsSelected ? 3 : 0);
    }

    protected String getTitle(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || ((String)text).equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, (String)text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < ((String)text).length() && (totalWidth += fm.charWidth(((String)text).charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = ((String)text).substring(0, nChars) + clipString;
        }
        return text;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void popupMenu(MouseEvent e) {
        this._popupMenu.show(this, e.getX() + 1, e.getY() + 1);
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected int getLeftmostButtonX(int width, Container c) {
        int x = width;
        if (this.shouldCloseButtonVisible() && this._closeButton != null && x > this._closeButton.getX()) {
            x = this._closeButton.getX();
        }
        if (this.shouldAutohideButtonVisible() && this._autohideButton != null && x > this._autohideButton.getX()) {
            x = this._autohideButton.getX();
        }
        if (this.shouldHideAutohideButtonVisible() && this._hideAutohideButton != null && x > this._hideAutohideButton.getX()) {
            x = this._hideAutohideButton.getX();
        }
        if (this.shouldFloatButtonVisible() && this._floatButton != null && x > this._floatButton.getX()) {
            x = this._floatButton.getX();
        }
        if (this.shouldMaximizeButtonVisible() && this._maximizeButton != null && x > this._maximizeButton.getX()) {
            x = this._maximizeButton.getX();
        }
        for (AbstractButton button : this._additionalButtons.values()) {
            if (x <= button.getX()) continue;
            x = button.getX();
        }
        if (this._frame.isShowTitleBar() && this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() && this.isSameLine(c)) {
            x -= this._frame.getTitleBarComponent().getPreferredSize().width - this._buttonGap;
        }
        return x;
    }

    protected boolean isCloseButtonVisible() {
        return (this._frame.getAvailableButtons() & 1) != 0;
    }

    protected boolean isHideAutohideButtonVisible() {
        return (this._frame.getAvailableButtons() & 2) != 0;
    }

    protected boolean isAutohideButtonVisible() {
        return (this._frame.getAvailableButtons() & 4) != 0;
    }

    protected boolean isFloatingButtonVisible() {
        return (this._frame.getAvailableButtons() & 8) != 0;
    }

    protected boolean isMaximizeButtonVisible() {
        return (this._frame.getAvailableButtons() & 0x10) != 0;
    }

    protected int getTitleBarHeight() {
        int height;
        JComponent labelComponent;
        Dimension buttonSize = this.getMaximumButtonSize();
        JComponent jComponent = labelComponent = this._frame != null ? this._frame.getTitleLabelComponent() : null;
        if (labelComponent != null && labelComponent.isVisible()) {
            height = labelComponent.getPreferredSize().height;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            height = fm.getHeight() + 2;
        }
        height = Math.max(buttonSize.height + (this._closeIcon == null ? 0 : 5), height);
        Insets insets = this.getInsets();
        if (this._frame != null && this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() && this.isSameLine(this._frame)) {
            Dimension titlebarSize = this._frame.getTitleBarComponent().getPreferredSize();
            return Math.max(height, titlebarSize.height) + insets.top + insets.bottom + this._titleInsets.top + this._titleInsets.bottom + this.getExtraHeight();
        }
        return height + insets.top + insets.bottom + this._titleInsets.top + this._titleInsets.bottom;
    }

    protected int calculateButtonWidth() {
        int width = 0;
        if (this.shouldCloseButtonVisible() && this._closeButton != null) {
            width += this._closeButton.getWidth() + this._buttonGap;
        }
        if (this.shouldHideAutohideButtonVisible() && this._hideAutohideButton != null) {
            width += this._hideAutohideButton.getWidth() + this._buttonGap;
        }
        if (this.shouldAutohideButtonVisible() && this._autohideButton != null) {
            width += this._autohideButton.getWidth() + this._buttonGap;
        }
        if (this.shouldFloatButtonVisible() && this._floatButton != null) {
            width += this._floatButton.getWidth() + this._buttonGap;
        }
        if (this.shouldMaximizeButtonVisible() && this._maximizeButton != null) {
            width += this._maximizeButton.getWidth() + this._buttonGap;
        }
        for (AbstractButton button : this._additionalButtons.values()) {
            width += button.getWidth() + this._buttonGap;
        }
        return width;
    }

    protected boolean isSameLine(Container c) {
        int title_length;
        if (!this._titleBarComponentCanBeOneSameLine) {
            return false;
        }
        if (c.getWidth() <= 0) {
            return true;
        }
        Dimension titlebarSize = this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() ? this._frame.getTitleBarComponent().getPreferredSize() : new Dimension(0, 0);
        int width = this.calculateButtonWidth();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String frameTitle = this._frame.getTitle();
        int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
        int n = title_length = frameTitle != null ? frameTitle.length() : 0;
        if (title_length > 3) {
            int subtitle_w = fm.stringWidth((String)(frameTitle != null ? frameTitle.substring(0, 3) + "..." : ""));
            width += title_w < subtitle_w ? title_w : subtitle_w;
        } else {
            width += title_w;
        }
        boolean sameLine = false;
        if (this._titleBarComponentCanBeOneSameLine && width + titlebarSize.width <= c.getWidth()) {
            sameLine = true;
        }
        return sameLine;
    }

    protected void enableButton(AbstractButton button, boolean enabled) {
        if (button == null) {
            return;
        }
        button.setEnabled(enabled);
        this.updateButtonVisibilities();
    }

    private boolean shouldCloseButtonVisible() {
        return this._frame.getCloseAction().isEnabled() && (this._frame.getAvailableButtons() & 1) != 0;
    }

    private boolean shouldHideAutohideButtonVisible() {
        return this._frame.getHideAutohideAction().isEnabled() && (this._frame.getAvailableButtons() & 2) != 0;
    }

    private boolean shouldAutohideButtonVisible() {
        return this._frame.getAutohideAction().isEnabled() && (this._frame.getAvailableButtons() & 4) != 0;
    }

    private boolean shouldFloatButtonVisible() {
        return this._frame.getFloatingAction().isEnabled() && (this._frame.getAvailableButtons() & 8) != 0;
    }

    private boolean shouldMaximizeButtonVisible() {
        return this._frame.getMaximizeAction().isEnabled() && (this._frame.getAvailableButtons() & 0x10) != 0;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected int getExtraHeight() {
        return 1;
    }

    public class NoFocusButton
    extends JideButton
    implements MouseMotionListener,
    MouseListener {
        public static final int CLOSE_BUTTON = 0;
        public static final int AUTOHIDE_BUTTON = 1;
        public static final int STOP_AUTOHIDE_BUTTON = 2;
        public static final int FLOAT_BUTTON = 3;
        public static final int UNFLOAT_BUTTON = 4;
        public static final int MAXIMIZE_BUTTON = 5;
        public static final int RESTORE_BUTTON = 6;
        public static final int HIDE_AUTOHIDE_BUTTON = 7;
        public static final int ACTION_BUTTON = 100;
        public static final int ADDITIONAL_BUTTON = 101;
        private int _type;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;
        private boolean _use3DButtons;

        public void setUse3DButtons(boolean use3DBorder) {
            this._use3DButtons = use3DBorder;
        }

        @Override
        public void updateUI() {
            if (BasicDockableFrameTitlePane.this._titleButtonUI != null) {
                try {
                    this.setUI((ButtonUI)Class.forName(BasicDockableFrameTitlePane.this._titleButtonUI).newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    super.updateUI();
                }
            } else {
                super.updateUI();
            }
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
        }

        public NoFocusButton() {
            if (this._use3DButtons) {
                this.setOpaque(false);
                this.setContentAreaFilled(false);
            }
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public NoFocusButton(Action action) {
            this();
            this.setAction(action);
            this.setType(100);
        }

        protected void originalPaintComponent(Graphics g) {
            super.paintComponent(g);
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this._use3DButtons) {
                super.paintComponent(g);
            } else if (this._type != 101 || this.isEnabled()) {
                if (this.isMouseOver() && this.isMousePressed()) {
                    g.setColor(Color.black);
                    g.drawLine(0, 0, this.getWidth() - 1, 0);
                    g.drawLine(0, this.getHeight() - 2, 0, 1);
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus()) {
                        g.setColor(Color.lightGray);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                    g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                } else if (this.isMouseOver()) {
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus()) {
                        g.setColor(Color.lightGray);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(0, 0, this.getWidth() - 1, 0);
                    g.drawLine(0, this.getHeight() - 2, 0, 1);
                    g.setColor(Color.black);
                    g.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                    g.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                }
            }
            Color textColor = BasicDockableFrameTitlePane.this.dockableFrameHasFocus() ? BasicDockableFrameTitlePane.this._selectedTextColor : BasicDockableFrameTitlePane.this._notSelectedTextColor;
            Icon icon = null;
            Icon activeIcon = null;
            Icon rolloverIcon = null;
            Icon rolloverActiveIcon = null;
            switch (this.getType()) {
                case 101: {
                    Icon actionIcon = BasicDockableFrameTitlePane.this._frame.getActionIcon(this.getAction());
                    if (actionIcon == null) break;
                    int xOffset = actionIcon.getIconWidth() / 2;
                    int yOffset = actionIcon.getIconHeight() / 2;
                    int startX = this.getWidth() / 2 - xOffset;
                    int startY = this.getHeight() / 2 - yOffset;
                    if (!this.isEnabled() && actionIcon instanceof ImageIcon) {
                        IconsFactory.createGrayImage(((ImageIcon)actionIcon).getImage()).paintIcon(this, g, startX, startY);
                        break;
                    }
                    actionIcon.paintIcon(this, g, startX, startY);
                    break;
                }
                case 100: {
                    Icon actionIcon = (ImageIcon)this.getAction().getValue("SmallIcon");
                    int xOffset = ((ImageIcon)actionIcon).getIconWidth() / 2;
                    int yOffset = ((ImageIcon)actionIcon).getIconHeight() / 2;
                    int startX = this.getWidth() / 2 - xOffset;
                    int startY = this.getHeight() / 2 - yOffset;
                    actionIcon = RetinaIconUtil.createImageIcon((ImageIcon)actionIcon, Color.black, textColor);
                    ((ImageIcon)actionIcon).paintIcon(this, g, startX, startY);
                    break;
                }
                case 0: {
                    icon = BasicDockableFrameTitlePane.this._closeIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._closeActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._closeRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._closeRolloverActiveIcon;
                    break;
                }
                case 7: {
                    icon = BasicDockableFrameTitlePane.this._hideAutohideIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._hideAutohideActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._hideAutohideRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._hideAutohideRolloverActiveIcon;
                    break;
                }
                case 1: {
                    icon = BasicDockableFrameTitlePane.this._autohideIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._autohideActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._autohideRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._autohideRolloverActiveIcon;
                    break;
                }
                case 2: {
                    icon = BasicDockableFrameTitlePane.this._stopAutohideIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._stopAutohideActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._stopAutohideRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._stopAutohideRolloverActiveIcon;
                    break;
                }
                case 3: {
                    icon = BasicDockableFrameTitlePane.this._floatIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._floatActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._floatRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._floatRolloverActiveIcon;
                    break;
                }
                case 4: {
                    icon = BasicDockableFrameTitlePane.this._unfloatIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._unfloatActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._unfloatRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._unfloatRolloverActiveIcon;
                    break;
                }
                case 5: {
                    icon = BasicDockableFrameTitlePane.this._maximizeIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._maximizeActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._maximizeRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._maximizeRolloverActiveIcon;
                    break;
                }
                case 6: {
                    icon = BasicDockableFrameTitlePane.this._restoreIcon;
                    activeIcon = BasicDockableFrameTitlePane.this._restoreActiveIcon;
                    rolloverIcon = BasicDockableFrameTitlePane.this._restoreRolloverIcon;
                    rolloverActiveIcon = BasicDockableFrameTitlePane.this._restoreRolloverActiveIcon;
                }
            }
            if (icon != null) {
                int xOffset = icon.getIconWidth() / 2;
                int yOffset = icon.getIconHeight() / 2;
                int startX = this.getWidth() / 2 - xOffset;
                int startY = this.getHeight() / 2 - yOffset;
                if (rolloverIcon != null) {
                    if (activeIcon != null && rolloverActiveIcon == null) {
                        rolloverActiveIcon = activeIcon;
                    } else if (activeIcon == null && rolloverActiveIcon != null) {
                        activeIcon = rolloverActiveIcon;
                    }
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus() && activeIcon != null) {
                        (this.isMouseOver() ? rolloverActiveIcon : activeIcon).paintIcon(this, g, startX, startY);
                    } else {
                        (this.isMouseOver() ? rolloverIcon : icon).paintIcon(this, g, startX, startY);
                    }
                } else {
                    if (icon instanceof ImageIcon) {
                        icon = RetinaIconUtil.createImageIcon((ImageIcon)icon, Color.black, textColor);
                    }
                    icon.paintIcon(this, g, startX, startY);
                }
            }
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JideSwingUtilities.retargetMouseEvent(506, e, BasicDockableFrameTitlePane.this._frame);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setMousePressed(true);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setMouseOver(true);
            this.repaint();
            JideSwingUtilities.retargetMouseEvent(504, e, BasicDockableFrameTitlePane.this._frame);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            JideSwingUtilities.retargetMouseEvent(504, e, BasicDockableFrameTitlePane.this._frame);
        }

        public int getType() {
            return this._type;
        }

        public void setType(int type) {
            this._type = type;
        }

        protected boolean isMouseOver() {
            return this._mouseOver;
        }

        protected void setMouseOver(boolean mouseOver) {
            this._mouseOver = mouseOver;
        }

        protected boolean isMousePressed() {
            return this._mousePressed;
        }

        protected void setMousePressed(boolean mousePressed) {
            this._mousePressed = mousePressed;
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container c) {
            Object object = c.getTreeLock();
            synchronized (object) {
                JComponent labelComponent;
                int width = 0;
                int height = 0;
                JComponent titleBarComponent = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent();
                Dimension titleBarComponentSize = titleBarComponent != null && titleBarComponent.isVisible() ? titleBarComponent.getPreferredSize() : new Dimension(0, 0);
                Dimension buttonSize = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
                width += BasicDockableFrameTitlePane.this.calculateButtonWidth();
                JComponent jComponent = labelComponent = BasicDockableFrameTitlePane.this._frame != null ? BasicDockableFrameTitlePane.this._frame.getTitleLabelComponent() : null;
                if (labelComponent != null && labelComponent.isVisible()) {
                    Dimension preferredSize = labelComponent.getPreferredSize();
                    Dimension minimumSize = labelComponent.getMinimumSize();
                    height = preferredSize.height;
                    width += minimumSize.width;
                } else {
                    int title_length;
                    FontMetrics fm = BasicDockableFrameTitlePane.this.getFontMetrics(BasicDockableFrameTitlePane.this.getFont());
                    String frameTitle = BasicDockableFrameTitlePane.this._frame.getTitle();
                    int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
                    int n = title_length = frameTitle != null ? frameTitle.length() : 0;
                    if (title_length > 3) {
                        int subtitle_w = fm.stringWidth((String)(frameTitle != null ? frameTitle.substring(0, 3) + "..." : ""));
                        width += title_w < subtitle_w ? title_w : subtitle_w;
                    } else {
                        width += title_w;
                    }
                    height = Math.max(fm.getHeight() + 2, height);
                }
                height = Math.max(buttonSize.height + (BasicDockableFrameTitlePane.this._closeIcon == null ? 0 : 5), height);
                height = BasicDockableFrameTitlePane.this.isSameLine(c) ? Math.max(titleBarComponentSize.height, height) + BasicDockableFrameTitlePane.this.getExtraHeight() : (height += titleBarComponentSize.height);
                if (BasicDockableFrameTitlePane.this.getBorder() != null) {
                    Insets insets = BasicDockableFrameTitlePane.this.getBorder().getBorderInsets(c);
                    height += insets.top + insets.bottom;
                    width += insets.left + insets.right;
                }
                width = Math.max(titleBarComponentSize.width, width);
                return new Dimension(width, height += BasicDockableFrameTitlePane.this._titleInsets.top + BasicDockableFrameTitlePane.this._titleInsets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container c) {
            Object object = c.getTreeLock();
            synchronized (object) {
                JComponent titleBarComponent;
                int x;
                boolean leftToRight;
                boolean bl = leftToRight = BasicDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() && BasicDockableFrameTitlePane.this._buttonsAlignment == 11;
                if (BasicDockableFrameTitlePane.this._titleInsets == null) {
                    BasicDockableFrameTitlePane.this._titleInsets = UIDefaultsLookup.getInsets("DockableFrameTitlePane.margin");
                }
                if (BasicDockableFrameTitlePane.this._titleInsets == null) {
                    BasicDockableFrameTitlePane.this._titleInsets = new Insets(0, 0, 0, 0);
                }
                int w = c.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.left - BasicDockableFrameTitlePane.this._titleInsets.right;
                int h = BasicDockableFrameTitlePane.this.getTitleBarHeight() - BasicDockableFrameTitlePane.this._titleInsets.top - BasicDockableFrameTitlePane.this._titleInsets.bottom;
                Dimension buttonSize = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
                int buttonHeight = buttonSize.height + (BasicDockableFrameTitlePane.this._closeIcon == null ? 0 : 2);
                int buttonWidth = buttonSize.width + BasicDockableFrameTitlePane.this._buttonGap;
                int n = x = leftToRight ? BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.right : BasicDockableFrameTitlePane.this._titleInsets.left;
                if (!leftToRight) {
                    x += BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth - BasicDockableFrameTitlePane.this._titleInsets.left + 2 : 0;
                }
                int offset = leftToRight ? -(buttonWidth + BasicDockableFrameTitlePane.this._buttonGap) : buttonWidth + BasicDockableFrameTitlePane.this._buttonGap;
                int voffset = 0;
                boolean firstOne = true;
                int[] buttons = BasicDockableFrameTitlePane.this._frame.getButtonsOrder();
                block10: for (int button : buttons) {
                    switch (button) {
                        case 1: {
                            if (BasicDockableFrameTitlePane.this.shouldCloseButtonVisible()) {
                                if (BasicDockableFrameTitlePane.this._closeButton == null) continue block10;
                                if (firstOne) {
                                    x += leftToRight ? offset : 0;
                                    firstOne = false;
                                } else {
                                    x += offset;
                                }
                                BasicDockableFrameTitlePane.this._closeButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._closeButton.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._closeButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._closeButton.setVisible(false);
                            continue block10;
                        }
                        case 4: {
                            if (BasicDockableFrameTitlePane.this.shouldAutohideButtonVisible()) {
                                if (BasicDockableFrameTitlePane.this._autohideButton == null) continue block10;
                                if (firstOne) {
                                    x += leftToRight ? offset : 0;
                                    firstOne = false;
                                } else {
                                    x += offset;
                                }
                                BasicDockableFrameTitlePane.this._autohideButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._autohideButton.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._autohideButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._autohideButton.setVisible(false);
                            continue block10;
                        }
                        case 2: {
                            if (BasicDockableFrameTitlePane.this.shouldHideAutohideButtonVisible()) {
                                if (BasicDockableFrameTitlePane.this._hideAutohideButton == null) continue block10;
                                if (firstOne) {
                                    x += leftToRight ? offset : 0;
                                    firstOne = false;
                                } else {
                                    x += offset;
                                }
                                BasicDockableFrameTitlePane.this._hideAutohideButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._hideAutohideButton.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._hideAutohideButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._hideAutohideButton.setVisible(false);
                            continue block10;
                        }
                        case 8: {
                            if (BasicDockableFrameTitlePane.this.shouldFloatButtonVisible()) {
                                if (BasicDockableFrameTitlePane.this._floatButton == null) continue block10;
                                if (firstOne) {
                                    x += leftToRight ? offset : 0;
                                    firstOne = false;
                                } else {
                                    x += offset;
                                }
                                BasicDockableFrameTitlePane.this._floatButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._floatButton.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._floatButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._floatButton.setVisible(false);
                            continue block10;
                        }
                        case 16: {
                            if (BasicDockableFrameTitlePane.this.shouldMaximizeButtonVisible()) {
                                if (BasicDockableFrameTitlePane.this._maximizeButton == null) continue block10;
                                if (firstOne) {
                                    x += leftToRight ? offset : 0;
                                    firstOne = false;
                                } else {
                                    x += offset;
                                }
                                BasicDockableFrameTitlePane.this._maximizeButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._maximizeButton.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._maximizeButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._maximizeButton.setVisible(false);
                        }
                    }
                }
                Object object2 = BasicDockableFrameTitlePane.this._additionalButtons.values().iterator();
                while (object2.hasNext()) {
                    AbstractButton button = (AbstractButton)object2.next();
                    if (firstOne) {
                        x += leftToRight ? offset : 0;
                        firstOne = false;
                    } else {
                        x += offset;
                    }
                    button.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                }
                if (!leftToRight && !firstOne) {
                    x += offset;
                }
                Insets insets = BasicDockableFrameTitlePane.this.getInsets();
                if (BasicDockableFrameTitlePane.this._frame.isShowTitleBar() && (titleBarComponent = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent()) != null && titleBarComponent.isVisible()) {
                    int cWidth = titleBarComponent.getPreferredSize().width;
                    int cHeight = titleBarComponent.getPreferredSize().height;
                    if (BasicDockableFrameTitlePane.this.isSameLine(c)) {
                        titleBarComponent.setBounds(x -= cWidth, BasicDockableFrameTitlePane.this._titleInsets.top + (h - cHeight) / 2 + voffset, cWidth, cHeight);
                    } else {
                        titleBarComponent.setBounds(insets.left, c.getHeight() - insets.bottom - cHeight, c.getWidth() - insets.left - insets.right, cHeight);
                    }
                }
                if (BasicDockableFrameTitlePane.this._titleAlignment == 0) {
                    if (leftToRight) {
                        if ((w + BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 > x - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0)) {
                            BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, x - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), h);
                            if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                                ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(11);
                            }
                        } else {
                            BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, w, h);
                            if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                                ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                            }
                        }
                    } else if ((w - BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 < (x += offset)) {
                        BasicDockableFrameTitlePane.this._title.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top, w - x - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), h);
                        if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(10);
                        }
                    } else {
                        BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left, BasicDockableFrameTitlePane.this._titleInsets.top, w, h);
                        if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                        }
                    }
                } else if (leftToRight) {
                    BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, x - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), h);
                } else {
                    BasicDockableFrameTitlePane.this._title.setBounds(x, BasicDockableFrameTitlePane.this._titleInsets.top, w - x - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), h);
                }
                if (BasicDockableFrameTitlePane.this._gripper != null) {
                    if (BasicDockableFrameTitlePane.this._frame.isShowGripper()) {
                        Rectangle gripperRect = BasicDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, BasicDockableFrameTitlePane.this._titleInsets.top, BasicDockableFrameTitlePane.this._gripperWidth, h) : new Rectangle(BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._gripperWidth, BasicDockableFrameTitlePane.this._titleInsets.top, BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.right, h);
                        BasicDockableFrameTitlePane.this._gripper.setBounds(gripperRect);
                    } else {
                        BasicDockableFrameTitlePane.this._gripper.setBounds(new Rectangle(0, 0, 0, 0));
                    }
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("active".equals(prop)) {
                BasicDockableFrameTitlePane.this.adjustSelectionColor();
            } else if ("maximizable".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._maximizeButton, BasicDockableFrameTitlePane.this._frame.getMaximizeAction().isEnabled());
            } else if ("hidable".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._closeButton, BasicDockableFrameTitlePane.this._frame.getCloseAction().isEnabled());
            } else if ("autohideShowing".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._hideAutohideButton, BasicDockableFrameTitlePane.this._frame.getHideAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.setButtonIcons();
            } else if ("dockable".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                this.resetButtonStates();
            } else if ("autohidable".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
            } else if ("floatable".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
            } else if (prop.equals("autohide") || "autohideShowing".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 2);
                this.resetButtonStates();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("docked".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 3);
                }
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 1);
                this.resetButtonStates();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("maximized".equals(prop)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 6);
                } else {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 5);
                }
                this.resetButtonStates();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("floated".equals(prop)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 4);
                }
                this.resetButtonStates();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("closeAction".equals(prop) || "autohideAction".equals(prop) || "hideAutohideAction".equals(prop) || "floatingAction".equals(prop) || "maximizeAction".equals(prop)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("availableButtons".equals(prop)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("title".equals(prop)) {
                if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                    ((JLabel)BasicDockableFrameTitlePane.this._title).setText(BasicDockableFrameTitlePane.this._frame.getTitle());
                }
            } else if ("frameIcon".equals(prop)) {
                if (BasicDockableFrameTitlePane.this._showIcon && BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                    ((JLabel)BasicDockableFrameTitlePane.this._title).setIcon(BasicDockableFrameTitlePane.this._frame.getFrameIcon());
                }
            } else if ("visible".equals(prop)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    BasicDockableFrameTitlePane.this.addSubComponents();
                    BasicDockableFrameTitlePane.this.invalidate();
                }
                this.resetButtonStates();
            } else if ("ToolTipText".equals(prop)) {
                if (BasicDockableFrameTitlePane.this._frame != null) {
                    String toolTipText = BasicDockableFrameTitlePane.this._frame.getToolTipText();
                    BasicDockableFrameTitlePane.this.setToolTipText(toolTipText);
                    BasicDockableFrameTitlePane.this._title.setToolTipText(toolTipText);
                }
            } else if ("rearrangable".equals(prop)) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("showGripper".equals(prop)) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("showTitleBar".equals(prop)) {
                BasicDockableFrameTitlePane.this.addSubComponents();
                BasicDockableFrameTitlePane.this.revalidate();
            } else if ("titleBarComponent".equals(prop)) {
                if (BasicDockableFrameTitlePane.this._frame.getTitleBarComponent() != null) {
                    BasicDockableFrameTitlePane.this.add(BasicDockableFrameTitlePane.this._frame.getTitleBarComponent());
                }
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("titleLabelComponent".equals(prop)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("additionalButtonActions".equals(prop)) {
                BasicDockableFrameTitlePane.this.updateAdditionalButtons();
                BasicDockableFrameTitlePane.this.addSubComponents();
                BasicDockableFrameTitlePane.this.revalidate();
            }
        }

        private void resetButtonStates() {
            if (BasicDockableFrameTitlePane.this._closeButton != null) {
                BasicDockableFrameTitlePane.this._closeButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._hideAutohideButton != null) {
                BasicDockableFrameTitlePane.this._hideAutohideButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._autohideButton != null) {
                BasicDockableFrameTitlePane.this._autohideButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._floatButton != null) {
                BasicDockableFrameTitlePane.this._floatButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._maximizeButton != null) {
                BasicDockableFrameTitlePane.this._maximizeButton.getModel().setRollover(false);
            }
        }
    }
}

