/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.CommandBarSeparator;
import com.jidesoft.plaf.CommandBarSeparatorUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public class BasicCommandBarSeparatorUI
extends CommandBarSeparatorUI {
    protected Color shadow;
    protected Color highlight;
    private int _size;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandBarSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults((CommandBarSeparator)c);
        this.installListeners((CommandBarSeparator)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((CommandBarSeparator)c);
        this.uninstallListeners((CommandBarSeparator)c);
    }

    protected void installDefaults(CommandBarSeparator s) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColors(s, "CommandBarSeparator.background", "CommandBarSeparator.foreground");
        this._size = UIDefaultsLookup.getInt("CommandBar.separatorSize");
    }

    protected void uninstallDefaults(CommandBarSeparator s) {
        this._painter = null;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected void installListeners(CommandBarSeparator s) {
        SeparatorPropertyChangeListener listener = new SeparatorPropertyChangeListener();
        if (listener != null) {
            s.putClientProperty(this, listener);
            s.addPropertyChangeListener(listener);
        }
    }

    protected void uninstallListeners(CommandBarSeparator s) {
        SeparatorPropertyChangeListener listener = (SeparatorPropertyChangeListener)s.getClientProperty(this);
        s.putClientProperty(this, null);
        if (listener != null) {
            s.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.getPainter().paintToolBarSeparator(c, g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), JideSwingUtilities.getOrientationOf(c), 0);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        CommandBarSeparator separator = (CommandBarSeparator)c;
        if (separator.getOrientation() == 0) {
            return new Dimension(5, 0);
        }
        return new Dimension(0, 5);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    protected class SeparatorPropertyChangeListener
    implements PropertyChangeListener {
        protected SeparatorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("orientation")) {
                Component c = (Component)evt.getSource();
                c.repaint();
            }
        }
    }
}

