/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicChevronUI
extends VsnetMenuUI {
    public static final int MARGIN = 3;
    protected Color shadow;
    protected Color highlight;
    protected int _size;
    protected boolean _alwaysVisible;
    private PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicChevronUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults((Chevron)c);
        this.installListeners((Chevron)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults((Chevron)c);
        this.uninstallListeners((Chevron)c);
    }

    protected void installDefaults(Chevron s) {
        this._size = UIDefaultsLookup.getInt("Chevron.size");
        this._alwaysVisible = UIDefaultsLookup.getBoolean("Chevron.alwaysVisible");
    }

    protected void uninstallDefaults(Chevron s) {
    }

    protected void installListeners(Chevron chevron) {
        if (this.propertyListener == null) {
            this.propertyListener = this.createPropertyChangeListener();
        }
        if (this.propertyListener != null) {
            chevron.addPropertyChangeListener(this.propertyListener);
        }
    }

    protected void uninstallListeners(Chevron chevron) {
        if (this.propertyListener != null) {
            chevron.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Chevron chevron = (Chevron)c;
        int w = c.getWidth();
        int h = c.getHeight();
        this.paintBackground(g, chevron);
        Rectangle rect = new Rectangle(0, 0, w, h);
        int orientation = chevron.getOrientation();
        if (chevron.isShowMore()) {
            this.getPainter().paintChevronMore(chevron, g, rect, orientation, chevron.getModel().isRollover() ? 2 : 0);
        }
        if (chevron.isShowOptions()) {
            Container parent = chevron.getParent();
            boolean isFloating = parent instanceof CommandBarTitleBar;
            if (isFloating) {
                this.getPainter().paintFloatingChevronOption(chevron, g, rect, orientation, chevron.getModel().isRollover() ? 2 : 0);
            } else {
                this.getPainter().paintChevronOption(chevron, g, rect, orientation, chevron.getModel().isRollover() ? 2 : 0);
            }
        }
    }

    protected void paintBackground(Graphics g, Chevron chevron) {
        Container parent = chevron.getParent();
        boolean isFloating = parent instanceof CommandBarTitleBar;
        Rectangle rect = new Rectangle(0, 0, chevron.getWidth(), chevron.getHeight());
        int orientation = JideSwingUtilities.getOrientationOf(chevron);
        if (chevron.getModel().isArmed() || this.menuItem instanceof JMenu && chevron.getModel().isSelected()) {
            if (!isFloating) {
                this.getPainter().paintChevronBackground(chevron, g, rect, orientation, 1);
            } else {
                this.getPainter().paintButtonBackground(chevron, g, rect, 0, 1);
            }
        } else if (chevron.getModel().isSelected()) {
            if (!isFloating) {
                this.getPainter().paintChevronBackground(chevron, g, rect, orientation, 3);
            } else {
                this.getPainter().paintButtonBackground(chevron, g, rect, 0, 3);
            }
        } else if (this.isMouseOver()) {
            if (!isFloating) {
                this.getPainter().paintChevronBackground(chevron, g, rect, orientation, 2);
            } else {
                this.getPainter().paintButtonBackground(chevron, g, rect, 0, 2);
            }
        } else {
            if (!isFloating) {
                this.getPainter().paintChevronBackground(chevron, g, rect, orientation, 0);
            }
            if (chevron.isOpaque() && "true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(g, rect, 0);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Chevron chevron = (Chevron)c;
        if (chevron.getParent() != null && (this.shouldChevronBeVisible(c) || chevron.isShowMore() || chevron.isShowOptions())) {
            boolean isFloating = chevron.getParent() instanceof CommandBarTitleBar;
            if (isFloating) {
                return new Dimension(chevron.getParent().getHeight(), chevron.getParent().getHeight());
            }
            if (chevron.getOrientation() == 0) {
                return new Dimension(this._size, c.getParent().getHeight());
            }
            return new Dimension(c.getParent().getWidth(), this._size);
        }
        return new Dimension(0, 0);
    }

    private boolean shouldChevronBeVisible(JComponent c) {
        DockableBar bar = (DockableBar)SwingUtilities.getAncestorOfClass(DockableBar.class, c);
        if (bar != null) {
            return this._alwaysVisible && bar.isChevronAlwaysVisible();
        }
        return this._alwaysVisible;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ((prop.equals("showMore") || prop.equals("showOption")) && e.getSource() instanceof Component) {
                ((Component)e.getSource()).repaint();
            }
        }
    }
}

