/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class SlidingAnimator {
    private DockingManager _dockingManager;
    private Handler _handler;
    private DockedFrameContainer _dockedFrameContainer;
    private SlidingOverFrameContainer _animationLayer;
    private Component _component;
    private SlidingOverFrameContainer.SlidingFrameConstraint _componentContstraints;
    private int _delay;
    private Timer _timer;
    private boolean _forceCompleteHide;
    private boolean _playingTransition;
    private boolean _closingTransition;
    private boolean _isOpened;
    private JComponent _sizeSurrogate;

    public SlidingAnimator(DockingManager dockingManager, Handler handler, DockedFrameContainer dockedFrameContainer, SlidingOverFrameContainer animationLayer, DockableFrame frame, int side, int delay, int steps) {
        if (dockingManager == null || handler == null || dockedFrameContainer == null || animationLayer == null) {
            throw new IllegalArgumentException("dockingManager, handler, dockedFrameContainer, and animationLayer must be non null.");
        }
        this._dockingManager = dockingManager;
        this._handler = handler;
        this._dockedFrameContainer = dockedFrameContainer;
        this._animationLayer = animationLayer;
        this._componentContstraints = new SlidingOverFrameContainer.SlidingFrameConstraint(this._animationLayer);
        this._componentContstraints.frame = frame;
        this._componentContstraints.side = side;
        this._componentContstraints.steps = steps;
        this._componentContstraints.currentStep = 0;
        this._componentContstraints.isLeftToRight = this._dockedFrameContainer.getComponentOrientation().isLeftToRight();
        this._componentContstraints.dockingComponent = this._dockedFrameContainer;
        this._sizeSurrogate = new JPanel(){

            @Override
            public boolean contains(int x, int y) {
                return false;
            }
        };
        this._sizeSurrogate.setOpaque(false);
        this._delay = delay;
        this._forceCompleteHide = false;
        this._isOpened = false;
        this._playingTransition = false;
        this._closingTransition = false;
        this._timer = new Timer(this._delay, new TimerActionListener());
    }

    public void startOpen(int initDelay) {
        if (this._forceCompleteHide) {
            return;
        }
        if (this._componentContstraints.currentStep >= this._componentContstraints.steps && this._componentContstraints.opening) {
            return;
        }
        this._componentContstraints.opening = true;
        if (!this.isSliding()) {
            if (initDelay == 0) {
                this.animateSlide();
            }
            this._timer.setInitialDelay(initDelay);
            this._timer.setDelay(this._delay);
            this._timer.restart();
        }
    }

    public void startHide(int initDelay, boolean forceComplete) {
        if (this._componentContstraints.currentStep <= 0 && !this._componentContstraints.opening) {
            return;
        }
        this._closingTransition = true;
        this._forceCompleteHide = forceComplete;
        this._componentContstraints.opening = false;
        if (!this.isSliding()) {
            if (initDelay == 0) {
                this.animateSlide();
            }
            this._timer.setInitialDelay(initDelay);
            this._timer.setDelay(this._delay / 2);
            this._timer.restart();
        }
    }

    public void showImmediately() {
        this.finishShowingComponent();
        if (this._handler != null && !this._isOpened) {
            this._handler.handleOpened(this._componentContstraints.frame);
        }
        this._isOpened = true;
    }

    public void hideImmediately() {
        this.removeShowingComponent();
        if (this._handler != null) {
            if (this._isOpened) {
                this._handler.handleHidden(this._componentContstraints.frame);
            } else {
                this._handler.handleShowingCancelled(this._componentContstraints.frame);
            }
        }
        this._isOpened = false;
        this._closingTransition = false;
    }

    public void removeImmediately() {
        this.removeShowingComponent();
        this._isOpened = false;
        this._closingTransition = false;
    }

    protected DockableFrame getDockableFrame(Component component) {
        DockableFrame frame = null;
        if (component instanceof DockableFrame) {
            frame = (DockableFrame)component;
        } else if (component instanceof HeavyweightWrapper) {
            frame = (DockableFrame)((HeavyweightWrapper)component).getComponent();
        }
        return frame;
    }

    public boolean isSliding() {
        return this._playingTransition;
    }

    public boolean isClosing() {
        return this._closingTransition;
    }

    public boolean isOpening() {
        return this.isSliding() && this._componentContstraints.opening;
    }

    public Component getSlidingComponent() {
        return this._component;
    }

    public DockableFrame getSlidingFrame() {
        return this._componentContstraints.frame;
    }

    protected void animateSlide() {
        if (this._componentContstraints.frame != null && (this._componentContstraints.frame.isAutohide() || this._componentContstraints.frame.isAutohideShowing())) {
            if (this._componentContstraints.currentStep <= 0) {
                if (this._componentContstraints.opening) {
                    this._componentContstraints.frame.fireDockableFrameEvent(4009);
                    this.beginShowing();
                    if (this._handler != null) {
                        this._handler.handleBeginShowing(this._componentContstraints.frame);
                    }
                } else {
                    this._componentContstraints.frame.fireDockableFrameEvent(4010);
                    this.hideImmediately();
                    return;
                }
            }
            if (this._componentContstraints.opening) {
                ++this._componentContstraints.currentStep;
                if (this._componentContstraints.currentStep > this._componentContstraints.steps) {
                    this._componentContstraints.currentStep = this._componentContstraints.steps;
                }
            } else {
                this._isOpened = false;
                --this._componentContstraints.currentStep;
                if (this._componentContstraints.currentStep < 0) {
                    this._componentContstraints.currentStep = 0;
                }
            }
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                this._componentContstraints.frame.getContentPane().setVisible(false);
            }
            this._playingTransition = true;
            try {
                this._componentContstraints.frame.setAutohideShowing(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.resizeShowingComponent();
            if (this._componentContstraints.currentStep >= this._componentContstraints.steps) {
                this.showImmediately();
            }
        }
    }

    protected void beginShowing() {
        Object saved;
        this._animationLayer.setVisible(true);
        this._component = !SystemInfo.isJdk6u14Above() && this._dockingManager.isHeavyweightComponentEnabled() && this._componentContstraints.frame.isSlidingAutohide() ? ((saved = this._componentContstraints.frame.getClientProperty("HeavyweightWrapper")) instanceof HeavyweightWrapper ? (HeavyweightWrapper)saved : new HeavyweightWrapper(this._componentContstraints.frame, true)) : this._componentContstraints.frame;
        if (!this._componentContstraints.frame.isVisible()) {
            this._componentContstraints.frame.setVisible(true);
        }
        this._componentContstraints.frame.getContext().setCurrentDockSide(this._componentContstraints.side);
        if (this._componentContstraints.frame.isSlidingAutohide()) {
            this.insertFrameOver();
        } else {
            this.insertFrameInto();
        }
    }

    protected void insertFrameOver() {
        if (this._component instanceof HeavyweightWrapper) {
            ((HeavyweightWrapper)this._component).delegateAdd(this._animationLayer, this._componentContstraints);
        } else {
            this._animationLayer.add(this._component, this._componentContstraints);
        }
    }

    protected void insertFrameInto() {
        this._animationLayer.add((Component)this._sizeSurrogate, this._componentContstraints);
        ContainerContainer splitPaneInserted = (ContainerContainer)this._dockedFrameContainer.getParent();
        this._component.setSize(this._componentContstraints.frame.getAutohideWidth(), this._componentContstraints.frame.getAutohideHeight());
        switch (this._componentContstraints.side) {
            case 4: {
                splitPaneInserted.setOrientation(1);
                splitPaneInserted.insertPane(this._component, "flexible", splitPaneInserted.getPaneCount());
                break;
            }
            case 8: {
                splitPaneInserted.setOrientation(1);
                splitPaneInserted.insertPane(this._component, "flexible", 0);
                break;
            }
            case 2: {
                splitPaneInserted.setOrientation(0);
                splitPaneInserted.insertPane(this._component, "flexible", splitPaneInserted.getPaneCount());
                break;
            }
            case 1: {
                splitPaneInserted.setOrientation(0);
                splitPaneInserted.insertPane(this._component, "flexible", 0);
            }
        }
        splitPaneInserted.doLayout();
    }

    protected void resizeShowingComponent() {
        this._animationLayer.validate();
        this._animationLayer.doLayout();
        Window parentWindow = SwingUtilities.getWindowAncestor(this._animationLayer);
        if (parentWindow != null) {
            parentWindow.validate();
        }
        if (this._component != null) {
            if (this._componentContstraints.frame.isSlidingAutohide()) {
                Rectangle boundsRepaint = this._component.getBounds();
                this._animationLayer.repaint(boundsRepaint.x, boundsRepaint.y, boundsRepaint.width, boundsRepaint.height);
            } else {
                ContainerContainer splitPaneInserted = (ContainerContainer)this._dockedFrameContainer.getParent();
                switch (this._componentContstraints.side) {
                    case 4: {
                        splitPaneInserted.setDividerLocation(0, splitPaneInserted.getWidth() - splitPaneInserted.getDividerSize() - this._sizeSurrogate.getSize().width);
                        break;
                    }
                    case 8: {
                        splitPaneInserted.setDividerLocation(0, this._sizeSurrogate.getSize().width);
                        break;
                    }
                    case 2: {
                        splitPaneInserted.setDividerLocation(0, splitPaneInserted.getHeight() - splitPaneInserted.getDividerSize() - this._sizeSurrogate.getSize().height);
                        break;
                    }
                    case 1: {
                        splitPaneInserted.setDividerLocation(0, this._sizeSurrogate.getSize().height);
                    }
                }
                this._dockedFrameContainer.getParent().invalidate();
                this._dockedFrameContainer.getParent().doLayout();
                this._dockedFrameContainer.getParent().repaint();
            }
        }
    }

    protected void finishShowingComponent() {
        this._playingTransition = false;
        this._timer.stop();
        this._componentContstraints.currentStep = this._componentContstraints.steps;
        this.resizeShowingComponent();
        if (this._componentContstraints.opening) {
            DockableFrame frame = this.getDockableFrame(this._component);
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                frame.getContentPane().setVisible(true);
            }
        }
        this._dockingManager.finishShowingAutohideFrame(this.getDockableFrame(this._component).getKey());
    }

    protected void removeShowingComponent() {
        this._timer.stop();
        this._playingTransition = false;
        this._animationLayer.setVisible(false);
        if (this._component != null) {
            Container parent = this._component.getParent();
            if (parent != null) {
                if (this._component instanceof HeavyweightWrapper) {
                    ((HeavyweightWrapper)this._component).delegateRemove(parent);
                } else {
                    JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
                }
            }
            this._animationLayer.remove(this._sizeSurrogate);
            this._component = null;
            this._componentContstraints.currentStep = 0;
            this._componentContstraints.opening = false;
            this._forceCompleteHide = false;
        }
        if (this._componentContstraints.frame != null && this._componentContstraints.frame.isAutohideShowing()) {
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                this._componentContstraints.frame.getContentPane().setVisible(true);
            }
            try {
                this._componentContstraints.frame.setAutohide(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this._animationLayer.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateAutohideWidthHeight(DockableFrame f) {
        try {
            f.setSettingSize(true);
            int side = f.getContext().getCurrentDockSide();
            switch (side) {
                case 4: 
                case 8: {
                    f.setAutohideWidth(f.getWidth());
                    return;
                }
                case 1: 
                case 2: {
                    f.setAutohideHeight(f.getHeight());
                    return;
                }
            }
            return;
        }
        finally {
            f.setSettingSize(false);
        }
    }

    public static interface Handler {
        public void handleBeginShowing(DockableFrame var1);

        public void handleShowingCancelled(DockableFrame var1);

        public void handleOpened(DockableFrame var1);

        public void handleHidden(DockableFrame var1);
    }

    protected class TimerActionListener
    implements ActionListener {
        protected TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlidingAnimator.this.animateSlide();
        }
    }
}

